/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The MoonInfo model module.
 * @module model/MoonInfo
 * @version 25.12.4
 */
class MoonInfo {
    /**
     * Constructs a new <code>MoonInfo</code>.
     * @alias module:model/MoonInfo
     * @param phaseName {String} 
     * @param phase {Number} 
     * @param illumination {Number} 
     * @param age {Number} 
     * @param distance {Number} 
     * @param diameterDegrees {Number} 
     * @param rise {String} 
     * @param set {String} 
     */
    constructor(phaseName, phase, illumination, age, distance, diameterDegrees, rise, set) { 
        
        MoonInfo.initialize(this, phaseName, phase, illumination, age, distance, diameterDegrees, rise, set);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, phaseName, phase, illumination, age, distance, diameterDegrees, rise, set) { 
        obj['phaseName'] = phaseName;
        obj['phase'] = phase;
        obj['illumination'] = illumination;
        obj['age'] = age;
        obj['distance'] = distance;
        obj['diameterDegrees'] = diameterDegrees;
        obj['rise'] = rise;
        obj['set'] = set;
    }

    /**
     * Constructs a <code>MoonInfo</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/MoonInfo} obj Optional instance to populate.
     * @return {module:model/MoonInfo} The populated <code>MoonInfo</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new MoonInfo();

            if (data.hasOwnProperty('phaseName')) {
                obj['phaseName'] = ApiClient.convertToType(data['phaseName'], 'String');
            }
            if (data.hasOwnProperty('phase')) {
                obj['phase'] = ApiClient.convertToType(data['phase'], 'Number');
            }
            if (data.hasOwnProperty('illumination')) {
                obj['illumination'] = ApiClient.convertToType(data['illumination'], 'Number');
            }
            if (data.hasOwnProperty('age')) {
                obj['age'] = ApiClient.convertToType(data['age'], 'Number');
            }
            if (data.hasOwnProperty('distance')) {
                obj['distance'] = ApiClient.convertToType(data['distance'], 'Number');
            }
            if (data.hasOwnProperty('diameterDegrees')) {
                obj['diameterDegrees'] = ApiClient.convertToType(data['diameterDegrees'], 'Number');
            }
            if (data.hasOwnProperty('rise')) {
                obj['rise'] = ApiClient.convertToType(data['rise'], 'String');
            }
            if (data.hasOwnProperty('set')) {
                obj['set'] = ApiClient.convertToType(data['set'], 'String');
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>MoonInfo</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>MoonInfo</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of MoonInfo.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['phaseName'] && !(typeof data['phaseName'] === 'string' || data['phaseName'] instanceof String)) {
            throw new Error("Expected the field `phaseName` to be a primitive type in the JSON string but got " + data['phaseName']);
        }
        // ensure the json data is a string
        if (data['rise'] && !(typeof data['rise'] === 'string' || data['rise'] instanceof String)) {
            throw new Error("Expected the field `rise` to be a primitive type in the JSON string but got " + data['rise']);
        }
        // ensure the json data is a string
        if (data['set'] && !(typeof data['set'] === 'string' || data['set'] instanceof String)) {
            throw new Error("Expected the field `set` to be a primitive type in the JSON string but got " + data['set']);
        }

        return true;
    }

/**
     * @return {String}
     */
    getPhaseName() {
        return this.phaseName;
    }

    /**
     * @param {String} phaseName
     */
    setPhaseName(phaseName) {
        this['phaseName'] = phaseName;
    }
/**
     * @return {Number}
     */
    getPhase() {
        return this.phase;
    }

    /**
     * @param {Number} phase
     */
    setPhase(phase) {
        this['phase'] = phase;
    }
/**
     * @return {Number}
     */
    getIllumination() {
        return this.illumination;
    }

    /**
     * @param {Number} illumination
     */
    setIllumination(illumination) {
        this['illumination'] = illumination;
    }
/**
     * @return {Number}
     */
    getAge() {
        return this.age;
    }

    /**
     * @param {Number} age
     */
    setAge(age) {
        this['age'] = age;
    }
/**
     * @return {Number}
     */
    getDistance() {
        return this.distance;
    }

    /**
     * @param {Number} distance
     */
    setDistance(distance) {
        this['distance'] = distance;
    }
/**
     * @return {Number}
     */
    getDiameterDegrees() {
        return this.diameterDegrees;
    }

    /**
     * @param {Number} diameterDegrees
     */
    setDiameterDegrees(diameterDegrees) {
        this['diameterDegrees'] = diameterDegrees;
    }
/**
     * @return {String}
     */
    getRise() {
        return this.rise;
    }

    /**
     * @param {String} rise
     */
    setRise(rise) {
        this['rise'] = rise;
    }
/**
     * @return {String}
     */
    getSet() {
        return this.set;
    }

    /**
     * @param {String} set
     */
    setSet(set) {
        this['set'] = set;
    }

}

MoonInfo.RequiredProperties = ["phaseName", "phase", "illumination", "age", "distance", "diameterDegrees", "rise", "set"];

/**
 * @member {String} phaseName
 */
MoonInfo.prototype['phaseName'] = undefined;

/**
 * @member {Number} phase
 */
MoonInfo.prototype['phase'] = undefined;

/**
 * @member {Number} illumination
 */
MoonInfo.prototype['illumination'] = undefined;

/**
 * @member {Number} age
 */
MoonInfo.prototype['age'] = undefined;

/**
 * @member {Number} distance
 */
MoonInfo.prototype['distance'] = undefined;

/**
 * @member {Number} diameterDegrees
 */
MoonInfo.prototype['diameterDegrees'] = undefined;

/**
 * @member {String} rise
 */
MoonInfo.prototype['rise'] = undefined;

/**
 * @member {String} set
 */
MoonInfo.prototype['set'] = undefined;






export default MoonInfo;

