/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import MoonInfo from './MoonInfo';
import SunInfo from './SunInfo';

/**
 * The MoonSunData model module.
 * @module model/MoonSunData
 * @version 25.12.4
 */
class MoonSunData {
    /**
     * Constructs a new <code>MoonSunData</code>.
     * @alias module:model/MoonSunData
     * @param moon {module:model/MoonInfo} 
     * @param sun {module:model/SunInfo} 
     */
    constructor(moon, sun) { 
        
        MoonSunData.initialize(this, moon, sun);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, moon, sun) { 
        obj['moon'] = moon;
        obj['sun'] = sun;
    }

    /**
     * Constructs a <code>MoonSunData</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/MoonSunData} obj Optional instance to populate.
     * @return {module:model/MoonSunData} The populated <code>MoonSunData</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new MoonSunData();

            if (data.hasOwnProperty('moon')) {
                obj['moon'] = MoonInfo.constructFromObject(data['moon']);
            }
            if (data.hasOwnProperty('sun')) {
                obj['sun'] = SunInfo.constructFromObject(data['sun']);
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>MoonSunData</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>MoonSunData</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of MoonSunData.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // validate the optional field `moon`
        if (data['moon']) { // data not null
          MoonInfo.validateJSON(data['moon']);
        }
        // validate the optional field `sun`
        if (data['sun']) { // data not null
          SunInfo.validateJSON(data['sun']);
        }

        return true;
    }

/**
     * @return {module:model/MoonInfo}
     */
    getMoon() {
        return this.moon;
    }

    /**
     * @param {module:model/MoonInfo} moon
     */
    setMoon(moon) {
        this['moon'] = moon;
    }
/**
     * @return {module:model/SunInfo}
     */
    getSun() {
        return this.sun;
    }

    /**
     * @param {module:model/SunInfo} sun
     */
    setSun(sun) {
        this['sun'] = sun;
    }

}

MoonSunData.RequiredProperties = ["moon", "sun"];

/**
 * @member {module:model/MoonInfo} moon
 */
MoonSunData.prototype['moon'] = undefined;

/**
 * @member {module:model/SunInfo} sun
 */
MoonSunData.prototype['sun'] = undefined;






export default MoonSunData;

