/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import Location from './Location';

/**
 * The MoonSunRequest model module.
 * @module model/MoonSunRequest
 * @version 25.12.4
 */
class MoonSunRequest {
    /**
     * Constructs a new <code>MoonSunRequest</code>.
     * @alias module:model/MoonSunRequest
     * @param dateTime {String} Date and time in YYYY-MM-DDTHH:mm format
     * @param location {module:model/Location} 
     */
    constructor(dateTime, location) { 
        
        MoonSunRequest.initialize(this, dateTime, location);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, dateTime, location) { 
        obj['dateTime'] = dateTime;
        obj['location'] = location;
    }

    /**
     * Constructs a <code>MoonSunRequest</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/MoonSunRequest} obj Optional instance to populate.
     * @return {module:model/MoonSunRequest} The populated <code>MoonSunRequest</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new MoonSunRequest();

            if (data.hasOwnProperty('dateTime')) {
                obj['dateTime'] = ApiClient.convertToType(data['dateTime'], 'String');
            }
            if (data.hasOwnProperty('location')) {
                obj['location'] = Location.constructFromObject(data['location']);
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>MoonSunRequest</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>MoonSunRequest</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of MoonSunRequest.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['dateTime'] && !(typeof data['dateTime'] === 'string' || data['dateTime'] instanceof String)) {
            throw new Error("Expected the field `dateTime` to be a primitive type in the JSON string but got " + data['dateTime']);
        }
        // validate the optional field `location`
        if (data['location']) { // data not null
          Location.validateJSON(data['location']);
        }

        return true;
    }

/**
     * Returns Date and time in YYYY-MM-DDTHH:mm format
     * @return {String}
     */
    getDateTime() {
        return this.dateTime;
    }

    /**
     * Sets Date and time in YYYY-MM-DDTHH:mm format
     * @param {String} dateTime Date and time in YYYY-MM-DDTHH:mm format
     */
    setDateTime(dateTime) {
        this['dateTime'] = dateTime;
    }
/**
     * @return {module:model/Location}
     */
    getLocation() {
        return this.location;
    }

    /**
     * @param {module:model/Location} location
     */
    setLocation(location) {
        this['location'] = location;
    }

}

MoonSunRequest.RequiredProperties = ["dateTime", "location"];

/**
 * Date and time in YYYY-MM-DDTHH:mm format
 * @member {String} dateTime
 */
MoonSunRequest.prototype['dateTime'] = undefined;

/**
 * @member {module:model/Location} location
 */
MoonSunRequest.prototype['location'] = undefined;






export default MoonSunRequest;

