/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import Aspect from './Aspect';
import CelestialPoint from './CelestialPoint';
import Chart from './Chart';
import Houses from './Houses';

/**
 * The NatalData model module.
 * @module model/NatalData
 * @version 25.12.4
 */
class NatalData {
    /**
     * Constructs a new <code>NatalData</code>.
     * @alias module:model/NatalData
     * @param dateTime {String} 
     * @param aspects {Array.<module:model/Aspect>} 
     * @param points {Object.<String, module:model/CelestialPoint>} 
     * @param houses {module:model/Houses} 
     * @param chart {module:model/Chart} 
     */
    constructor(dateTime, aspects, points, houses, chart) { 
        
        NatalData.initialize(this, dateTime, aspects, points, houses, chart);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, dateTime, aspects, points, houses, chart) { 
        obj['dateTime'] = dateTime;
        obj['aspects'] = aspects;
        obj['points'] = points;
        obj['houses'] = houses;
        obj['chart'] = chart;
    }

    /**
     * Constructs a <code>NatalData</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/NatalData} obj Optional instance to populate.
     * @return {module:model/NatalData} The populated <code>NatalData</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new NatalData();

            if (data.hasOwnProperty('dateTime')) {
                obj['dateTime'] = ApiClient.convertToType(data['dateTime'], 'String');
            }
            if (data.hasOwnProperty('aspects')) {
                obj['aspects'] = ApiClient.convertToType(data['aspects'], [Aspect]);
            }
            if (data.hasOwnProperty('points')) {
                obj['points'] = ApiClient.convertToType(data['points'], {'String': CelestialPoint});
            }
            if (data.hasOwnProperty('houses')) {
                obj['houses'] = Houses.constructFromObject(data['houses']);
            }
            if (data.hasOwnProperty('chart')) {
                obj['chart'] = Chart.constructFromObject(data['chart']);
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>NatalData</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>NatalData</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of NatalData.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['dateTime'] && !(typeof data['dateTime'] === 'string' || data['dateTime'] instanceof String)) {
            throw new Error("Expected the field `dateTime` to be a primitive type in the JSON string but got " + data['dateTime']);
        }
        if (data['aspects']) { // data not null
            // ensure the json data is an array
            if (!Array.isArray(data['aspects'])) {
                throw new Error("Expected the field `aspects` to be an array in the JSON data but got " + data['aspects']);
            }
            // validate the optional field `aspects` (array)
            for (const item of data['aspects']) {
                Aspect.validateJSON(item);
            };
        }
        // validate the optional field `houses`
        if (data['houses']) { // data not null
          Houses.validateJSON(data['houses']);
        }
        // validate the optional field `chart`
        if (data['chart']) { // data not null
          Chart.validateJSON(data['chart']);
        }

        return true;
    }

/**
     * @return {String}
     */
    getDateTime() {
        return this.dateTime;
    }

    /**
     * @param {String} dateTime
     */
    setDateTime(dateTime) {
        this['dateTime'] = dateTime;
    }
/**
     * @return {Array.<module:model/Aspect>}
     */
    getAspects() {
        return this.aspects;
    }

    /**
     * @param {Array.<module:model/Aspect>} aspects
     */
    setAspects(aspects) {
        this['aspects'] = aspects;
    }
/**
     * @return {Object.<String, module:model/CelestialPoint>}
     */
    getPoints() {
        return this.points;
    }

    /**
     * @param {Object.<String, module:model/CelestialPoint>} points
     */
    setPoints(points) {
        this['points'] = points;
    }
/**
     * @return {module:model/Houses}
     */
    getHouses() {
        return this.houses;
    }

    /**
     * @param {module:model/Houses} houses
     */
    setHouses(houses) {
        this['houses'] = houses;
    }
/**
     * @return {module:model/Chart}
     */
    getChart() {
        return this.chart;
    }

    /**
     * @param {module:model/Chart} chart
     */
    setChart(chart) {
        this['chart'] = chart;
    }

}

NatalData.RequiredProperties = ["dateTime", "aspects", "points", "houses", "chart"];

/**
 * @member {String} dateTime
 */
NatalData.prototype['dateTime'] = undefined;

/**
 * @member {Array.<module:model/Aspect>} aspects
 */
NatalData.prototype['aspects'] = undefined;

/**
 * @member {Object.<String, module:model/CelestialPoint>} points
 */
NatalData.prototype['points'] = undefined;

/**
 * @member {module:model/Houses} houses
 */
NatalData.prototype['houses'] = undefined;

/**
 * @member {module:model/Chart} chart
 */
NatalData.prototype['chart'] = undefined;






export default NatalData;

