/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import Location from './Location';

/**
 * The NatalRequest model module.
 * @module model/NatalRequest
 * @version 25.12.4
 */
class NatalRequest {
    /**
     * Constructs a new <code>NatalRequest</code>.
     * @alias module:model/NatalRequest
     * @param dateTime {String} Birth date and time in YYYY-MM-DDTHH:mm format
     * @param location {module:model/Location} 
     */
    constructor(dateTime, location) { 
        
        NatalRequest.initialize(this, dateTime, location);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, dateTime, location) { 
        obj['dateTime'] = dateTime;
        obj['location'] = location;
        obj['houseSystem'] = 'placidus';
        obj['language'] = 'en';
        obj['includeText'] = true;
        obj['includeReadableEntities'] = false;
    }

    /**
     * Constructs a <code>NatalRequest</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/NatalRequest} obj Optional instance to populate.
     * @return {module:model/NatalRequest} The populated <code>NatalRequest</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new NatalRequest();

            if (data.hasOwnProperty('dateTime')) {
                obj['dateTime'] = ApiClient.convertToType(data['dateTime'], 'String');
            }
            if (data.hasOwnProperty('location')) {
                obj['location'] = Location.constructFromObject(data['location']);
            }
            if (data.hasOwnProperty('houseSystem')) {
                obj['houseSystem'] = ApiClient.convertToType(data['houseSystem'], 'String');
            }
            if (data.hasOwnProperty('language')) {
                obj['language'] = ApiClient.convertToType(data['language'], 'String');
            }
            if (data.hasOwnProperty('includeText')) {
                obj['includeText'] = ApiClient.convertToType(data['includeText'], 'Boolean');
            }
            if (data.hasOwnProperty('includeReadableEntities')) {
                obj['includeReadableEntities'] = ApiClient.convertToType(data['includeReadableEntities'], 'Boolean');
            }
            if (data.hasOwnProperty('points')) {
                obj['points'] = ApiClient.convertToType(data['points'], ['String']);
            }
            if (data.hasOwnProperty('orbs')) {
                obj['orbs'] = ApiClient.convertToType(data['orbs'], {'String': 'Number'});
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>NatalRequest</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>NatalRequest</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of NatalRequest.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['dateTime'] && !(typeof data['dateTime'] === 'string' || data['dateTime'] instanceof String)) {
            throw new Error("Expected the field `dateTime` to be a primitive type in the JSON string but got " + data['dateTime']);
        }
        // validate the optional field `location`
        if (data['location']) { // data not null
          Location.validateJSON(data['location']);
        }
        // ensure the json data is a string
        if (data['houseSystem'] && !(typeof data['houseSystem'] === 'string' || data['houseSystem'] instanceof String)) {
            throw new Error("Expected the field `houseSystem` to be a primitive type in the JSON string but got " + data['houseSystem']);
        }
        // ensure the json data is a string
        if (data['language'] && !(typeof data['language'] === 'string' || data['language'] instanceof String)) {
            throw new Error("Expected the field `language` to be a primitive type in the JSON string but got " + data['language']);
        }
        // ensure the json data is an array
        if (!Array.isArray(data['points'])) {
            throw new Error("Expected the field `points` to be an array in the JSON data but got " + data['points']);
        }

        return true;
    }

/**
     * Returns Birth date and time in YYYY-MM-DDTHH:mm format
     * @return {String}
     */
    getDateTime() {
        return this.dateTime;
    }

    /**
     * Sets Birth date and time in YYYY-MM-DDTHH:mm format
     * @param {String} dateTime Birth date and time in YYYY-MM-DDTHH:mm format
     */
    setDateTime(dateTime) {
        this['dateTime'] = dateTime;
    }
/**
     * @return {module:model/Location}
     */
    getLocation() {
        return this.location;
    }

    /**
     * @param {module:model/Location} location
     */
    setLocation(location) {
        this['location'] = location;
    }
/**
     * Returns House system for calculations (default: \"placidus\")
     * @return {module:model/NatalRequest.HouseSystemEnum}
     */
    getHouseSystem() {
        return this.houseSystem;
    }

    /**
     * Sets House system for calculations (default: \"placidus\")
     * @param {module:model/NatalRequest.HouseSystemEnum} houseSystem House system for calculations (default: \"placidus\")
     */
    setHouseSystem(houseSystem) {
        this['houseSystem'] = houseSystem;
    }
/**
     * Returns Language code for text content
     * @return {String}
     */
    getLanguage() {
        return this.language;
    }

    /**
     * Sets Language code for text content
     * @param {String} language Language code for text content
     */
    setLanguage(language) {
        this['language'] = language;
    }
/**
     * Returns Include interpretation text
     * @return {Boolean}
     */
    getIncludeText() {
        return this.includeText;
    }

    /**
     * Sets Include interpretation text
     * @param {Boolean} includeText Include interpretation text
     */
    setIncludeText(includeText) {
        this['includeText'] = includeText;
    }
/**
     * Returns Include human-readable entity titles
     * @return {Boolean}
     */
    getIncludeReadableEntities() {
        return this.includeReadableEntities;
    }

    /**
     * Sets Include human-readable entity titles
     * @param {Boolean} includeReadableEntities Include human-readable entity titles
     */
    setIncludeReadableEntities(includeReadableEntities) {
        this['includeReadableEntities'] = includeReadableEntities;
    }
/**
     * Returns Celestial points to calculate (e.g., [\"sun\", \"moon\", \"mercury\"]). Defaults to all major planets.
     * @return {Array.<String>}
     */
    getPoints() {
        return this.points;
    }

    /**
     * Sets Celestial points to calculate (e.g., [\"sun\", \"moon\", \"mercury\"]). Defaults to all major planets.
     * @param {Array.<String>} points Celestial points to calculate (e.g., [\"sun\", \"moon\", \"mercury\"]). Defaults to all major planets.
     */
    setPoints(points) {
        this['points'] = points;
    }
/**
     * Returns Custom orb values per aspect type (e.g., { \"conjunction\": 8, \"opposition\": 6 })
     * @return {Object.<String, Number>}
     */
    getOrbs() {
        return this.orbs;
    }

    /**
     * Sets Custom orb values per aspect type (e.g., { \"conjunction\": 8, \"opposition\": 6 })
     * @param {Object.<String, Number>} orbs Custom orb values per aspect type (e.g., { \"conjunction\": 8, \"opposition\": 6 })
     */
    setOrbs(orbs) {
        this['orbs'] = orbs;
    }

}

NatalRequest.RequiredProperties = ["dateTime", "location"];

/**
 * Birth date and time in YYYY-MM-DDTHH:mm format
 * @member {String} dateTime
 */
NatalRequest.prototype['dateTime'] = undefined;

/**
 * @member {module:model/Location} location
 */
NatalRequest.prototype['location'] = undefined;

/**
 * House system for calculations (default: \"placidus\")
 * @member {module:model/NatalRequest.HouseSystemEnum} houseSystem
 * @default 'placidus'
 */
NatalRequest.prototype['houseSystem'] = 'placidus';

/**
 * Language code for text content
 * @member {String} language
 * @default 'en'
 */
NatalRequest.prototype['language'] = 'en';

/**
 * Include interpretation text
 * @member {Boolean} includeText
 * @default true
 */
NatalRequest.prototype['includeText'] = true;

/**
 * Include human-readable entity titles
 * @member {Boolean} includeReadableEntities
 * @default false
 */
NatalRequest.prototype['includeReadableEntities'] = false;

/**
 * Celestial points to calculate (e.g., [\"sun\", \"moon\", \"mercury\"]). Defaults to all major planets.
 * @member {Array.<String>} points
 */
NatalRequest.prototype['points'] = undefined;

/**
 * Custom orb values per aspect type (e.g., { \"conjunction\": 8, \"opposition\": 6 })
 * @member {Object.<String, Number>} orbs
 */
NatalRequest.prototype['orbs'] = undefined;





/**
 * Allowed values for the <code>houseSystem</code> property.
 * @enum {String}
 * @readonly
 */
NatalRequest['HouseSystemEnum'] = {

    /**
     * value: "placidus"
     * @const
     */
    "placidus": "placidus",

    /**
     * value: "koch"
     * @const
     */
    "koch": "koch",

    /**
     * value: "equal"
     * @const
     */
    "equal": "equal",

    /**
     * value: "whole"
     * @const
     */
    "whole": "whole",

    /**
     * value: "campanus"
     * @const
     */
    "campanus": "campanus",

    /**
     * value: "regiomontanus"
     * @const
     */
    "regiomontanus": "regiomontanus",

    /**
     * value: "porphyry"
     * @const
     */
    "porphyry": "porphyry"
};



export default NatalRequest;

