/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The NumerologyBirthdayRequest model module.
 * @module model/NumerologyBirthdayRequest
 * @version 25.12.4
 */
class NumerologyBirthdayRequest {
    /**
     * Constructs a new <code>NumerologyBirthdayRequest</code>.
     * @alias module:model/NumerologyBirthdayRequest
     * @param dateTime {String} Birth date and time in YYYY-MM-DDTHH:mm format
     */
    constructor(dateTime) { 
        
        NumerologyBirthdayRequest.initialize(this, dateTime);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, dateTime) { 
        obj['dateTime'] = dateTime;
    }

    /**
     * Constructs a <code>NumerologyBirthdayRequest</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/NumerologyBirthdayRequest} obj Optional instance to populate.
     * @return {module:model/NumerologyBirthdayRequest} The populated <code>NumerologyBirthdayRequest</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new NumerologyBirthdayRequest();

            if (data.hasOwnProperty('dateTime')) {
                obj['dateTime'] = ApiClient.convertToType(data['dateTime'], 'String');
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>NumerologyBirthdayRequest</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>NumerologyBirthdayRequest</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of NumerologyBirthdayRequest.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['dateTime'] && !(typeof data['dateTime'] === 'string' || data['dateTime'] instanceof String)) {
            throw new Error("Expected the field `dateTime` to be a primitive type in the JSON string but got " + data['dateTime']);
        }

        return true;
    }

/**
     * Returns Birth date and time in YYYY-MM-DDTHH:mm format
     * @return {String}
     */
    getDateTime() {
        return this.dateTime;
    }

    /**
     * Sets Birth date and time in YYYY-MM-DDTHH:mm format
     * @param {String} dateTime Birth date and time in YYYY-MM-DDTHH:mm format
     */
    setDateTime(dateTime) {
        this['dateTime'] = dateTime;
    }

}

NumerologyBirthdayRequest.RequiredProperties = ["dateTime"];

/**
 * Birth date and time in YYYY-MM-DDTHH:mm format
 * @member {String} dateTime
 */
NumerologyBirthdayRequest.prototype['dateTime'] = undefined;






export default NumerologyBirthdayRequest;

