/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import NumerologyNumber1 from './NumerologyNumber1';

/**
 * The NumerologyCompatibility model module.
 * @module model/NumerologyCompatibility
 * @version 25.12.4
 */
class NumerologyCompatibility {
    /**
     * Constructs a new <code>NumerologyCompatibility</code>.
     * @alias module:model/NumerologyCompatibility
     * @param person1LifePath {module:model/NumerologyNumber1} 
     * @param person2LifePath {module:model/NumerologyNumber1} 
     * @param compatibilityScore {Number} 
     * @param relationship {module:model/NumerologyCompatibility.RelationshipEnum} 
     * @param description {String} 
     */
    constructor(person1LifePath, person2LifePath, compatibilityScore, relationship, description) { 
        
        NumerologyCompatibility.initialize(this, person1LifePath, person2LifePath, compatibilityScore, relationship, description);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, person1LifePath, person2LifePath, compatibilityScore, relationship, description) { 
        obj['person1LifePath'] = person1LifePath;
        obj['person2LifePath'] = person2LifePath;
        obj['compatibilityScore'] = compatibilityScore;
        obj['relationship'] = relationship;
        obj['description'] = description;
    }

    /**
     * Constructs a <code>NumerologyCompatibility</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/NumerologyCompatibility} obj Optional instance to populate.
     * @return {module:model/NumerologyCompatibility} The populated <code>NumerologyCompatibility</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new NumerologyCompatibility();

            if (data.hasOwnProperty('person1LifePath')) {
                obj['person1LifePath'] = NumerologyNumber1.constructFromObject(data['person1LifePath']);
            }
            if (data.hasOwnProperty('person2LifePath')) {
                obj['person2LifePath'] = NumerologyNumber1.constructFromObject(data['person2LifePath']);
            }
            if (data.hasOwnProperty('compatibilityScore')) {
                obj['compatibilityScore'] = ApiClient.convertToType(data['compatibilityScore'], 'Number');
            }
            if (data.hasOwnProperty('relationship')) {
                obj['relationship'] = ApiClient.convertToType(data['relationship'], 'String');
            }
            if (data.hasOwnProperty('description')) {
                obj['description'] = ApiClient.convertToType(data['description'], 'String');
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>NumerologyCompatibility</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>NumerologyCompatibility</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of NumerologyCompatibility.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // validate the optional field `person1LifePath`
        if (data['person1LifePath']) { // data not null
          NumerologyNumber1.validateJSON(data['person1LifePath']);
        }
        // validate the optional field `person2LifePath`
        if (data['person2LifePath']) { // data not null
          NumerologyNumber1.validateJSON(data['person2LifePath']);
        }
        // ensure the json data is a string
        if (data['relationship'] && !(typeof data['relationship'] === 'string' || data['relationship'] instanceof String)) {
            throw new Error("Expected the field `relationship` to be a primitive type in the JSON string but got " + data['relationship']);
        }
        // ensure the json data is a string
        if (data['description'] && !(typeof data['description'] === 'string' || data['description'] instanceof String)) {
            throw new Error("Expected the field `description` to be a primitive type in the JSON string but got " + data['description']);
        }

        return true;
    }

/**
     * @return {module:model/NumerologyNumber1}
     */
    getPerson1LifePath() {
        return this.person1LifePath;
    }

    /**
     * @param {module:model/NumerologyNumber1} person1LifePath
     */
    setPerson1LifePath(person1LifePath) {
        this['person1LifePath'] = person1LifePath;
    }
/**
     * @return {module:model/NumerologyNumber1}
     */
    getPerson2LifePath() {
        return this.person2LifePath;
    }

    /**
     * @param {module:model/NumerologyNumber1} person2LifePath
     */
    setPerson2LifePath(person2LifePath) {
        this['person2LifePath'] = person2LifePath;
    }
/**
     * @return {Number}
     */
    getCompatibilityScore() {
        return this.compatibilityScore;
    }

    /**
     * @param {Number} compatibilityScore
     */
    setCompatibilityScore(compatibilityScore) {
        this['compatibilityScore'] = compatibilityScore;
    }
/**
     * @return {module:model/NumerologyCompatibility.RelationshipEnum}
     */
    getRelationship() {
        return this.relationship;
    }

    /**
     * @param {module:model/NumerologyCompatibility.RelationshipEnum} relationship
     */
    setRelationship(relationship) {
        this['relationship'] = relationship;
    }
/**
     * @return {String}
     */
    getDescription() {
        return this.description;
    }

    /**
     * @param {String} description
     */
    setDescription(description) {
        this['description'] = description;
    }

}

NumerologyCompatibility.RequiredProperties = ["person1LifePath", "person2LifePath", "compatibilityScore", "relationship", "description"];

/**
 * @member {module:model/NumerologyNumber1} person1LifePath
 */
NumerologyCompatibility.prototype['person1LifePath'] = undefined;

/**
 * @member {module:model/NumerologyNumber1} person2LifePath
 */
NumerologyCompatibility.prototype['person2LifePath'] = undefined;

/**
 * @member {Number} compatibilityScore
 */
NumerologyCompatibility.prototype['compatibilityScore'] = undefined;

/**
 * @member {module:model/NumerologyCompatibility.RelationshipEnum} relationship
 */
NumerologyCompatibility.prototype['relationship'] = undefined;

/**
 * @member {String} description
 */
NumerologyCompatibility.prototype['description'] = undefined;





/**
 * Allowed values for the <code>relationship</code> property.
 * @enum {String}
 * @readonly
 */
NumerologyCompatibility['RelationshipEnum'] = {

    /**
     * value: "excellent"
     * @const
     */
    "excellent": "excellent",

    /**
     * value: "good"
     * @const
     */
    "good": "good",

    /**
     * value: "moderate"
     * @const
     */
    "moderate": "moderate",

    /**
     * value: "challenging"
     * @const
     */
    "challenging": "challenging"
};



export default NumerologyCompatibility;

