/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The NumerologyCompatibilityRequest model module.
 * @module model/NumerologyCompatibilityRequest
 * @version 25.12.4
 */
class NumerologyCompatibilityRequest {
    /**
     * Constructs a new <code>NumerologyCompatibilityRequest</code>.
     * @alias module:model/NumerologyCompatibilityRequest
     * @param dateTime1 {String} First person birth date/time in YYYY-MM-DDTHH:mm format
     * @param dateTime2 {String} Second person birth date/time in YYYY-MM-DDTHH:mm format
     */
    constructor(dateTime1, dateTime2) { 
        
        NumerologyCompatibilityRequest.initialize(this, dateTime1, dateTime2);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, dateTime1, dateTime2) { 
        obj['dateTime1'] = dateTime1;
        obj['dateTime2'] = dateTime2;
    }

    /**
     * Constructs a <code>NumerologyCompatibilityRequest</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/NumerologyCompatibilityRequest} obj Optional instance to populate.
     * @return {module:model/NumerologyCompatibilityRequest} The populated <code>NumerologyCompatibilityRequest</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new NumerologyCompatibilityRequest();

            if (data.hasOwnProperty('dateTime1')) {
                obj['dateTime1'] = ApiClient.convertToType(data['dateTime1'], 'String');
            }
            if (data.hasOwnProperty('dateTime2')) {
                obj['dateTime2'] = ApiClient.convertToType(data['dateTime2'], 'String');
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>NumerologyCompatibilityRequest</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>NumerologyCompatibilityRequest</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of NumerologyCompatibilityRequest.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['dateTime1'] && !(typeof data['dateTime1'] === 'string' || data['dateTime1'] instanceof String)) {
            throw new Error("Expected the field `dateTime1` to be a primitive type in the JSON string but got " + data['dateTime1']);
        }
        // ensure the json data is a string
        if (data['dateTime2'] && !(typeof data['dateTime2'] === 'string' || data['dateTime2'] instanceof String)) {
            throw new Error("Expected the field `dateTime2` to be a primitive type in the JSON string but got " + data['dateTime2']);
        }

        return true;
    }

/**
     * Returns First person birth date/time in YYYY-MM-DDTHH:mm format
     * @return {String}
     */
    getDateTime1() {
        return this.dateTime1;
    }

    /**
     * Sets First person birth date/time in YYYY-MM-DDTHH:mm format
     * @param {String} dateTime1 First person birth date/time in YYYY-MM-DDTHH:mm format
     */
    setDateTime1(dateTime1) {
        this['dateTime1'] = dateTime1;
    }
/**
     * Returns Second person birth date/time in YYYY-MM-DDTHH:mm format
     * @return {String}
     */
    getDateTime2() {
        return this.dateTime2;
    }

    /**
     * Sets Second person birth date/time in YYYY-MM-DDTHH:mm format
     * @param {String} dateTime2 Second person birth date/time in YYYY-MM-DDTHH:mm format
     */
    setDateTime2(dateTime2) {
        this['dateTime2'] = dateTime2;
    }

}

NumerologyCompatibilityRequest.RequiredProperties = ["dateTime1", "dateTime2"];

/**
 * First person birth date/time in YYYY-MM-DDTHH:mm format
 * @member {String} dateTime1
 */
NumerologyCompatibilityRequest.prototype['dateTime1'] = undefined;

/**
 * Second person birth date/time in YYYY-MM-DDTHH:mm format
 * @member {String} dateTime2
 */
NumerologyCompatibilityRequest.prototype['dateTime2'] = undefined;






export default NumerologyCompatibilityRequest;

