/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The NumerologyExpressionRequest model module.
 * @module model/NumerologyExpressionRequest
 * @version 25.12.4
 */
class NumerologyExpressionRequest {
    /**
     * Constructs a new <code>NumerologyExpressionRequest</code>.
     * @alias module:model/NumerologyExpressionRequest
     * @param fullName {String} Full name for expression number calculation
     */
    constructor(fullName) { 
        
        NumerologyExpressionRequest.initialize(this, fullName);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, fullName) { 
        obj['fullName'] = fullName;
    }

    /**
     * Constructs a <code>NumerologyExpressionRequest</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/NumerologyExpressionRequest} obj Optional instance to populate.
     * @return {module:model/NumerologyExpressionRequest} The populated <code>NumerologyExpressionRequest</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new NumerologyExpressionRequest();

            if (data.hasOwnProperty('fullName')) {
                obj['fullName'] = ApiClient.convertToType(data['fullName'], 'String');
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>NumerologyExpressionRequest</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>NumerologyExpressionRequest</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of NumerologyExpressionRequest.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['fullName'] && !(typeof data['fullName'] === 'string' || data['fullName'] instanceof String)) {
            throw new Error("Expected the field `fullName` to be a primitive type in the JSON string but got " + data['fullName']);
        }

        return true;
    }

/**
     * Returns Full name for expression number calculation
     * @return {String}
     */
    getFullName() {
        return this.fullName;
    }

    /**
     * Sets Full name for expression number calculation
     * @param {String} fullName Full name for expression number calculation
     */
    setFullName(fullName) {
        this['fullName'] = fullName;
    }

}

NumerologyExpressionRequest.RequiredProperties = ["fullName"];

/**
 * Full name for expression number calculation
 * @member {String} fullName
 */
NumerologyExpressionRequest.prototype['fullName'] = undefined;






export default NumerologyExpressionRequest;

