/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The NumerologyNumber1 model module.
 * @module model/NumerologyNumber1
 * @version 25.12.4
 */
class NumerologyNumber1 {
    /**
     * Constructs a new <code>NumerologyNumber1</code>.
     * @alias module:model/NumerologyNumber1
     * @param value {Number} 
     * @param isMasterNumber {Boolean} 
     * @param isKarmicDebt {Boolean} 
     * @param calculation {String} 
     */
    constructor(value, isMasterNumber, isKarmicDebt, calculation) { 
        
        NumerologyNumber1.initialize(this, value, isMasterNumber, isKarmicDebt, calculation);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, value, isMasterNumber, isKarmicDebt, calculation) { 
        obj['value'] = value;
        obj['isMasterNumber'] = isMasterNumber;
        obj['isKarmicDebt'] = isKarmicDebt;
        obj['calculation'] = calculation;
    }

    /**
     * Constructs a <code>NumerologyNumber1</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/NumerologyNumber1} obj Optional instance to populate.
     * @return {module:model/NumerologyNumber1} The populated <code>NumerologyNumber1</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new NumerologyNumber1();

            if (data.hasOwnProperty('value')) {
                obj['value'] = ApiClient.convertToType(data['value'], 'Number');
            }
            if (data.hasOwnProperty('isMasterNumber')) {
                obj['isMasterNumber'] = ApiClient.convertToType(data['isMasterNumber'], 'Boolean');
            }
            if (data.hasOwnProperty('isKarmicDebt')) {
                obj['isKarmicDebt'] = ApiClient.convertToType(data['isKarmicDebt'], 'Boolean');
            }
            if (data.hasOwnProperty('reducedFrom')) {
                obj['reducedFrom'] = ApiClient.convertToType(data['reducedFrom'], 'Number');
            }
            if (data.hasOwnProperty('calculation')) {
                obj['calculation'] = ApiClient.convertToType(data['calculation'], 'String');
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>NumerologyNumber1</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>NumerologyNumber1</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of NumerologyNumber1.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['calculation'] && !(typeof data['calculation'] === 'string' || data['calculation'] instanceof String)) {
            throw new Error("Expected the field `calculation` to be a primitive type in the JSON string but got " + data['calculation']);
        }

        return true;
    }

/**
     * @return {Number}
     */
    getValue() {
        return this.value;
    }

    /**
     * @param {Number} value
     */
    setValue(value) {
        this['value'] = value;
    }
/**
     * @return {Boolean}
     */
    getIsMasterNumber() {
        return this.isMasterNumber;
    }

    /**
     * @param {Boolean} isMasterNumber
     */
    setIsMasterNumber(isMasterNumber) {
        this['isMasterNumber'] = isMasterNumber;
    }
/**
     * @return {Boolean}
     */
    getIsKarmicDebt() {
        return this.isKarmicDebt;
    }

    /**
     * @param {Boolean} isKarmicDebt
     */
    setIsKarmicDebt(isKarmicDebt) {
        this['isKarmicDebt'] = isKarmicDebt;
    }
/**
     * @return {Number}
     */
    getReducedFrom() {
        return this.reducedFrom;
    }

    /**
     * @param {Number} reducedFrom
     */
    setReducedFrom(reducedFrom) {
        this['reducedFrom'] = reducedFrom;
    }
/**
     * @return {String}
     */
    getCalculation() {
        return this.calculation;
    }

    /**
     * @param {String} calculation
     */
    setCalculation(calculation) {
        this['calculation'] = calculation;
    }

}

NumerologyNumber1.RequiredProperties = ["value", "isMasterNumber", "isKarmicDebt", "calculation"];

/**
 * @member {Number} value
 */
NumerologyNumber1.prototype['value'] = undefined;

/**
 * @member {Boolean} isMasterNumber
 */
NumerologyNumber1.prototype['isMasterNumber'] = undefined;

/**
 * @member {Boolean} isKarmicDebt
 */
NumerologyNumber1.prototype['isKarmicDebt'] = undefined;

/**
 * @member {Number} reducedFrom
 */
NumerologyNumber1.prototype['reducedFrom'] = undefined;

/**
 * @member {String} calculation
 */
NumerologyNumber1.prototype['calculation'] = undefined;






export default NumerologyNumber1;

