/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import NumerologyNumber1 from './NumerologyNumber1';

/**
 * The NumerologyPersonalCycles model module.
 * @module model/NumerologyPersonalCycles
 * @version 25.12.4
 */
class NumerologyPersonalCycles {
    /**
     * Constructs a new <code>NumerologyPersonalCycles</code>.
     * @alias module:model/NumerologyPersonalCycles
     * @param personalYear {module:model/NumerologyNumber1} 
     * @param personalMonth {module:model/NumerologyNumber1} 
     * @param personalDay {module:model/NumerologyNumber1} 
     */
    constructor(personalYear, personalMonth, personalDay) { 
        
        NumerologyPersonalCycles.initialize(this, personalYear, personalMonth, personalDay);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, personalYear, personalMonth, personalDay) { 
        obj['personalYear'] = personalYear;
        obj['personalMonth'] = personalMonth;
        obj['personalDay'] = personalDay;
    }

    /**
     * Constructs a <code>NumerologyPersonalCycles</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/NumerologyPersonalCycles} obj Optional instance to populate.
     * @return {module:model/NumerologyPersonalCycles} The populated <code>NumerologyPersonalCycles</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new NumerologyPersonalCycles();

            if (data.hasOwnProperty('personalYear')) {
                obj['personalYear'] = NumerologyNumber1.constructFromObject(data['personalYear']);
            }
            if (data.hasOwnProperty('personalMonth')) {
                obj['personalMonth'] = NumerologyNumber1.constructFromObject(data['personalMonth']);
            }
            if (data.hasOwnProperty('personalDay')) {
                obj['personalDay'] = NumerologyNumber1.constructFromObject(data['personalDay']);
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>NumerologyPersonalCycles</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>NumerologyPersonalCycles</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of NumerologyPersonalCycles.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // validate the optional field `personalYear`
        if (data['personalYear']) { // data not null
          NumerologyNumber1.validateJSON(data['personalYear']);
        }
        // validate the optional field `personalMonth`
        if (data['personalMonth']) { // data not null
          NumerologyNumber1.validateJSON(data['personalMonth']);
        }
        // validate the optional field `personalDay`
        if (data['personalDay']) { // data not null
          NumerologyNumber1.validateJSON(data['personalDay']);
        }

        return true;
    }

/**
     * @return {module:model/NumerologyNumber1}
     */
    getPersonalYear() {
        return this.personalYear;
    }

    /**
     * @param {module:model/NumerologyNumber1} personalYear
     */
    setPersonalYear(personalYear) {
        this['personalYear'] = personalYear;
    }
/**
     * @return {module:model/NumerologyNumber1}
     */
    getPersonalMonth() {
        return this.personalMonth;
    }

    /**
     * @param {module:model/NumerologyNumber1} personalMonth
     */
    setPersonalMonth(personalMonth) {
        this['personalMonth'] = personalMonth;
    }
/**
     * @return {module:model/NumerologyNumber1}
     */
    getPersonalDay() {
        return this.personalDay;
    }

    /**
     * @param {module:model/NumerologyNumber1} personalDay
     */
    setPersonalDay(personalDay) {
        this['personalDay'] = personalDay;
    }

}

NumerologyPersonalCycles.RequiredProperties = ["personalYear", "personalMonth", "personalDay"];

/**
 * @member {module:model/NumerologyNumber1} personalYear
 */
NumerologyPersonalCycles.prototype['personalYear'] = undefined;

/**
 * @member {module:model/NumerologyNumber1} personalMonth
 */
NumerologyPersonalCycles.prototype['personalMonth'] = undefined;

/**
 * @member {module:model/NumerologyNumber1} personalDay
 */
NumerologyPersonalCycles.prototype['personalDay'] = undefined;






export default NumerologyPersonalCycles;

