/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The NumerologyPersonalCyclesRequest model module.
 * @module model/NumerologyPersonalCyclesRequest
 * @version 25.12.4
 */
class NumerologyPersonalCyclesRequest {
    /**
     * Constructs a new <code>NumerologyPersonalCyclesRequest</code>.
     * @alias module:model/NumerologyPersonalCyclesRequest
     * @param dateTime {String} Birth date and time in YYYY-MM-DDTHH:mm format
     */
    constructor(dateTime) { 
        
        NumerologyPersonalCyclesRequest.initialize(this, dateTime);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, dateTime) { 
        obj['dateTime'] = dateTime;
    }

    /**
     * Constructs a <code>NumerologyPersonalCyclesRequest</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/NumerologyPersonalCyclesRequest} obj Optional instance to populate.
     * @return {module:model/NumerologyPersonalCyclesRequest} The populated <code>NumerologyPersonalCyclesRequest</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new NumerologyPersonalCyclesRequest();

            if (data.hasOwnProperty('dateTime')) {
                obj['dateTime'] = ApiClient.convertToType(data['dateTime'], 'String');
            }
            if (data.hasOwnProperty('currentDate')) {
                obj['currentDate'] = ApiClient.convertToType(data['currentDate'], 'String');
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>NumerologyPersonalCyclesRequest</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>NumerologyPersonalCyclesRequest</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of NumerologyPersonalCyclesRequest.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['dateTime'] && !(typeof data['dateTime'] === 'string' || data['dateTime'] instanceof String)) {
            throw new Error("Expected the field `dateTime` to be a primitive type in the JSON string but got " + data['dateTime']);
        }
        // ensure the json data is a string
        if (data['currentDate'] && !(typeof data['currentDate'] === 'string' || data['currentDate'] instanceof String)) {
            throw new Error("Expected the field `currentDate` to be a primitive type in the JSON string but got " + data['currentDate']);
        }

        return true;
    }

/**
     * Returns Birth date and time in YYYY-MM-DDTHH:mm format
     * @return {String}
     */
    getDateTime() {
        return this.dateTime;
    }

    /**
     * Sets Birth date and time in YYYY-MM-DDTHH:mm format
     * @param {String} dateTime Birth date and time in YYYY-MM-DDTHH:mm format
     */
    setDateTime(dateTime) {
        this['dateTime'] = dateTime;
    }
/**
     * Returns Current date in YYYY-MM-DD format for personal cycles. Defaults to today.
     * @return {String}
     */
    getCurrentDate() {
        return this.currentDate;
    }

    /**
     * Sets Current date in YYYY-MM-DD format for personal cycles. Defaults to today.
     * @param {String} currentDate Current date in YYYY-MM-DD format for personal cycles. Defaults to today.
     */
    setCurrentDate(currentDate) {
        this['currentDate'] = currentDate;
    }

}

NumerologyPersonalCyclesRequest.RequiredProperties = ["dateTime"];

/**
 * Birth date and time in YYYY-MM-DDTHH:mm format
 * @member {String} dateTime
 */
NumerologyPersonalCyclesRequest.prototype['dateTime'] = undefined;

/**
 * Current date in YYYY-MM-DD format for personal cycles. Defaults to today.
 * @member {String} currentDate
 */
NumerologyPersonalCyclesRequest.prototype['currentDate'] = undefined;






export default NumerologyPersonalCyclesRequest;

