/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The NumerologyPersonalityRequest model module.
 * @module model/NumerologyPersonalityRequest
 * @version 25.12.4
 */
class NumerologyPersonalityRequest {
    /**
     * Constructs a new <code>NumerologyPersonalityRequest</code>.
     * @alias module:model/NumerologyPersonalityRequest
     * @param fullName {String} Full name for personality number calculation
     */
    constructor(fullName) { 
        
        NumerologyPersonalityRequest.initialize(this, fullName);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, fullName) { 
        obj['fullName'] = fullName;
    }

    /**
     * Constructs a <code>NumerologyPersonalityRequest</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/NumerologyPersonalityRequest} obj Optional instance to populate.
     * @return {module:model/NumerologyPersonalityRequest} The populated <code>NumerologyPersonalityRequest</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new NumerologyPersonalityRequest();

            if (data.hasOwnProperty('fullName')) {
                obj['fullName'] = ApiClient.convertToType(data['fullName'], 'String');
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>NumerologyPersonalityRequest</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>NumerologyPersonalityRequest</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of NumerologyPersonalityRequest.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['fullName'] && !(typeof data['fullName'] === 'string' || data['fullName'] instanceof String)) {
            throw new Error("Expected the field `fullName` to be a primitive type in the JSON string but got " + data['fullName']);
        }

        return true;
    }

/**
     * Returns Full name for personality number calculation
     * @return {String}
     */
    getFullName() {
        return this.fullName;
    }

    /**
     * Sets Full name for personality number calculation
     * @param {String} fullName Full name for personality number calculation
     */
    setFullName(fullName) {
        this['fullName'] = fullName;
    }

}

NumerologyPersonalityRequest.RequiredProperties = ["fullName"];

/**
 * Full name for personality number calculation
 * @member {String} fullName
 */
NumerologyPersonalityRequest.prototype['fullName'] = undefined;






export default NumerologyPersonalityRequest;

