/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import NumerologyNumber from './NumerologyNumber';
import NumerologyNumber1 from './NumerologyNumber1';

/**
 * The NumerologyProfile model module.
 * @module model/NumerologyProfile
 * @version 25.12.4
 */
class NumerologyProfile {
    /**
     * Constructs a new <code>NumerologyProfile</code>.
     * @alias module:model/NumerologyProfile
     * @param lifePathNumber {module:model/NumerologyNumber} 
     * @param expressionNumber {module:model/NumerologyNumber1} 
     * @param soulUrgeNumber {module:model/NumerologyNumber1} 
     * @param personalityNumber {module:model/NumerologyNumber1} 
     * @param birthdayNumber {module:model/NumerologyNumber1} 
     * @param personalYear {module:model/NumerologyNumber1} 
     * @param personalMonth {module:model/NumerologyNumber1} 
     * @param personalDay {module:model/NumerologyNumber1} 
     * @param karmicDebtNumbers {Array.<Number>} 
     * @param masterNumbers {Array.<Number>} 
     */
    constructor(lifePathNumber, expressionNumber, soulUrgeNumber, personalityNumber, birthdayNumber, personalYear, personalMonth, personalDay, karmicDebtNumbers, masterNumbers) { 
        
        NumerologyProfile.initialize(this, lifePathNumber, expressionNumber, soulUrgeNumber, personalityNumber, birthdayNumber, personalYear, personalMonth, personalDay, karmicDebtNumbers, masterNumbers);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, lifePathNumber, expressionNumber, soulUrgeNumber, personalityNumber, birthdayNumber, personalYear, personalMonth, personalDay, karmicDebtNumbers, masterNumbers) { 
        obj['lifePathNumber'] = lifePathNumber;
        obj['expressionNumber'] = expressionNumber;
        obj['soulUrgeNumber'] = soulUrgeNumber;
        obj['personalityNumber'] = personalityNumber;
        obj['birthdayNumber'] = birthdayNumber;
        obj['personalYear'] = personalYear;
        obj['personalMonth'] = personalMonth;
        obj['personalDay'] = personalDay;
        obj['karmicDebtNumbers'] = karmicDebtNumbers;
        obj['masterNumbers'] = masterNumbers;
    }

    /**
     * Constructs a <code>NumerologyProfile</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/NumerologyProfile} obj Optional instance to populate.
     * @return {module:model/NumerologyProfile} The populated <code>NumerologyProfile</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new NumerologyProfile();

            if (data.hasOwnProperty('lifePathNumber')) {
                obj['lifePathNumber'] = NumerologyNumber.constructFromObject(data['lifePathNumber']);
            }
            if (data.hasOwnProperty('expressionNumber')) {
                obj['expressionNumber'] = NumerologyNumber1.constructFromObject(data['expressionNumber']);
            }
            if (data.hasOwnProperty('soulUrgeNumber')) {
                obj['soulUrgeNumber'] = NumerologyNumber1.constructFromObject(data['soulUrgeNumber']);
            }
            if (data.hasOwnProperty('personalityNumber')) {
                obj['personalityNumber'] = NumerologyNumber1.constructFromObject(data['personalityNumber']);
            }
            if (data.hasOwnProperty('birthdayNumber')) {
                obj['birthdayNumber'] = NumerologyNumber1.constructFromObject(data['birthdayNumber']);
            }
            if (data.hasOwnProperty('personalYear')) {
                obj['personalYear'] = NumerologyNumber1.constructFromObject(data['personalYear']);
            }
            if (data.hasOwnProperty('personalMonth')) {
                obj['personalMonth'] = NumerologyNumber1.constructFromObject(data['personalMonth']);
            }
            if (data.hasOwnProperty('personalDay')) {
                obj['personalDay'] = NumerologyNumber1.constructFromObject(data['personalDay']);
            }
            if (data.hasOwnProperty('karmicDebtNumbers')) {
                obj['karmicDebtNumbers'] = ApiClient.convertToType(data['karmicDebtNumbers'], ['Number']);
            }
            if (data.hasOwnProperty('masterNumbers')) {
                obj['masterNumbers'] = ApiClient.convertToType(data['masterNumbers'], ['Number']);
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>NumerologyProfile</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>NumerologyProfile</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of NumerologyProfile.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // validate the optional field `lifePathNumber`
        if (data['lifePathNumber']) { // data not null
          NumerologyNumber.validateJSON(data['lifePathNumber']);
        }
        // validate the optional field `expressionNumber`
        if (data['expressionNumber']) { // data not null
          NumerologyNumber1.validateJSON(data['expressionNumber']);
        }
        // validate the optional field `soulUrgeNumber`
        if (data['soulUrgeNumber']) { // data not null
          NumerologyNumber1.validateJSON(data['soulUrgeNumber']);
        }
        // validate the optional field `personalityNumber`
        if (data['personalityNumber']) { // data not null
          NumerologyNumber1.validateJSON(data['personalityNumber']);
        }
        // validate the optional field `birthdayNumber`
        if (data['birthdayNumber']) { // data not null
          NumerologyNumber1.validateJSON(data['birthdayNumber']);
        }
        // validate the optional field `personalYear`
        if (data['personalYear']) { // data not null
          NumerologyNumber1.validateJSON(data['personalYear']);
        }
        // validate the optional field `personalMonth`
        if (data['personalMonth']) { // data not null
          NumerologyNumber1.validateJSON(data['personalMonth']);
        }
        // validate the optional field `personalDay`
        if (data['personalDay']) { // data not null
          NumerologyNumber1.validateJSON(data['personalDay']);
        }
        // ensure the json data is an array
        if (!Array.isArray(data['karmicDebtNumbers'])) {
            throw new Error("Expected the field `karmicDebtNumbers` to be an array in the JSON data but got " + data['karmicDebtNumbers']);
        }
        // ensure the json data is an array
        if (!Array.isArray(data['masterNumbers'])) {
            throw new Error("Expected the field `masterNumbers` to be an array in the JSON data but got " + data['masterNumbers']);
        }

        return true;
    }

/**
     * @return {module:model/NumerologyNumber}
     */
    getLifePathNumber() {
        return this.lifePathNumber;
    }

    /**
     * @param {module:model/NumerologyNumber} lifePathNumber
     */
    setLifePathNumber(lifePathNumber) {
        this['lifePathNumber'] = lifePathNumber;
    }
/**
     * @return {module:model/NumerologyNumber1}
     */
    getExpressionNumber() {
        return this.expressionNumber;
    }

    /**
     * @param {module:model/NumerologyNumber1} expressionNumber
     */
    setExpressionNumber(expressionNumber) {
        this['expressionNumber'] = expressionNumber;
    }
/**
     * @return {module:model/NumerologyNumber1}
     */
    getSoulUrgeNumber() {
        return this.soulUrgeNumber;
    }

    /**
     * @param {module:model/NumerologyNumber1} soulUrgeNumber
     */
    setSoulUrgeNumber(soulUrgeNumber) {
        this['soulUrgeNumber'] = soulUrgeNumber;
    }
/**
     * @return {module:model/NumerologyNumber1}
     */
    getPersonalityNumber() {
        return this.personalityNumber;
    }

    /**
     * @param {module:model/NumerologyNumber1} personalityNumber
     */
    setPersonalityNumber(personalityNumber) {
        this['personalityNumber'] = personalityNumber;
    }
/**
     * @return {module:model/NumerologyNumber1}
     */
    getBirthdayNumber() {
        return this.birthdayNumber;
    }

    /**
     * @param {module:model/NumerologyNumber1} birthdayNumber
     */
    setBirthdayNumber(birthdayNumber) {
        this['birthdayNumber'] = birthdayNumber;
    }
/**
     * @return {module:model/NumerologyNumber1}
     */
    getPersonalYear() {
        return this.personalYear;
    }

    /**
     * @param {module:model/NumerologyNumber1} personalYear
     */
    setPersonalYear(personalYear) {
        this['personalYear'] = personalYear;
    }
/**
     * @return {module:model/NumerologyNumber1}
     */
    getPersonalMonth() {
        return this.personalMonth;
    }

    /**
     * @param {module:model/NumerologyNumber1} personalMonth
     */
    setPersonalMonth(personalMonth) {
        this['personalMonth'] = personalMonth;
    }
/**
     * @return {module:model/NumerologyNumber1}
     */
    getPersonalDay() {
        return this.personalDay;
    }

    /**
     * @param {module:model/NumerologyNumber1} personalDay
     */
    setPersonalDay(personalDay) {
        this['personalDay'] = personalDay;
    }
/**
     * @return {Array.<Number>}
     */
    getKarmicDebtNumbers() {
        return this.karmicDebtNumbers;
    }

    /**
     * @param {Array.<Number>} karmicDebtNumbers
     */
    setKarmicDebtNumbers(karmicDebtNumbers) {
        this['karmicDebtNumbers'] = karmicDebtNumbers;
    }
/**
     * @return {Array.<Number>}
     */
    getMasterNumbers() {
        return this.masterNumbers;
    }

    /**
     * @param {Array.<Number>} masterNumbers
     */
    setMasterNumbers(masterNumbers) {
        this['masterNumbers'] = masterNumbers;
    }

}

NumerologyProfile.RequiredProperties = ["lifePathNumber", "expressionNumber", "soulUrgeNumber", "personalityNumber", "birthdayNumber", "personalYear", "personalMonth", "personalDay", "karmicDebtNumbers", "masterNumbers"];

/**
 * @member {module:model/NumerologyNumber} lifePathNumber
 */
NumerologyProfile.prototype['lifePathNumber'] = undefined;

/**
 * @member {module:model/NumerologyNumber1} expressionNumber
 */
NumerologyProfile.prototype['expressionNumber'] = undefined;

/**
 * @member {module:model/NumerologyNumber1} soulUrgeNumber
 */
NumerologyProfile.prototype['soulUrgeNumber'] = undefined;

/**
 * @member {module:model/NumerologyNumber1} personalityNumber
 */
NumerologyProfile.prototype['personalityNumber'] = undefined;

/**
 * @member {module:model/NumerologyNumber1} birthdayNumber
 */
NumerologyProfile.prototype['birthdayNumber'] = undefined;

/**
 * @member {module:model/NumerologyNumber1} personalYear
 */
NumerologyProfile.prototype['personalYear'] = undefined;

/**
 * @member {module:model/NumerologyNumber1} personalMonth
 */
NumerologyProfile.prototype['personalMonth'] = undefined;

/**
 * @member {module:model/NumerologyNumber1} personalDay
 */
NumerologyProfile.prototype['personalDay'] = undefined;

/**
 * @member {Array.<Number>} karmicDebtNumbers
 */
NumerologyProfile.prototype['karmicDebtNumbers'] = undefined;

/**
 * @member {Array.<Number>} masterNumbers
 */
NumerologyProfile.prototype['masterNumbers'] = undefined;






export default NumerologyProfile;

