/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The NumerologyProfileRequest model module.
 * @module model/NumerologyProfileRequest
 * @version 25.12.4
 */
class NumerologyProfileRequest {
    /**
     * Constructs a new <code>NumerologyProfileRequest</code>.
     * @alias module:model/NumerologyProfileRequest
     * @param dateTime {String} Birth date and time in YYYY-MM-DDTHH:mm format
     * @param fullName {String} Full name for name-based calculations
     */
    constructor(dateTime, fullName) { 
        
        NumerologyProfileRequest.initialize(this, dateTime, fullName);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, dateTime, fullName) { 
        obj['dateTime'] = dateTime;
        obj['fullName'] = fullName;
    }

    /**
     * Constructs a <code>NumerologyProfileRequest</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/NumerologyProfileRequest} obj Optional instance to populate.
     * @return {module:model/NumerologyProfileRequest} The populated <code>NumerologyProfileRequest</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new NumerologyProfileRequest();

            if (data.hasOwnProperty('dateTime')) {
                obj['dateTime'] = ApiClient.convertToType(data['dateTime'], 'String');
            }
            if (data.hasOwnProperty('fullName')) {
                obj['fullName'] = ApiClient.convertToType(data['fullName'], 'String');
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>NumerologyProfileRequest</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>NumerologyProfileRequest</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of NumerologyProfileRequest.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['dateTime'] && !(typeof data['dateTime'] === 'string' || data['dateTime'] instanceof String)) {
            throw new Error("Expected the field `dateTime` to be a primitive type in the JSON string but got " + data['dateTime']);
        }
        // ensure the json data is a string
        if (data['fullName'] && !(typeof data['fullName'] === 'string' || data['fullName'] instanceof String)) {
            throw new Error("Expected the field `fullName` to be a primitive type in the JSON string but got " + data['fullName']);
        }

        return true;
    }

/**
     * Returns Birth date and time in YYYY-MM-DDTHH:mm format
     * @return {String}
     */
    getDateTime() {
        return this.dateTime;
    }

    /**
     * Sets Birth date and time in YYYY-MM-DDTHH:mm format
     * @param {String} dateTime Birth date and time in YYYY-MM-DDTHH:mm format
     */
    setDateTime(dateTime) {
        this['dateTime'] = dateTime;
    }
/**
     * Returns Full name for name-based calculations
     * @return {String}
     */
    getFullName() {
        return this.fullName;
    }

    /**
     * Sets Full name for name-based calculations
     * @param {String} fullName Full name for name-based calculations
     */
    setFullName(fullName) {
        this['fullName'] = fullName;
    }

}

NumerologyProfileRequest.RequiredProperties = ["dateTime", "fullName"];

/**
 * Birth date and time in YYYY-MM-DDTHH:mm format
 * @member {String} dateTime
 */
NumerologyProfileRequest.prototype['dateTime'] = undefined;

/**
 * Full name for name-based calculations
 * @member {String} fullName
 */
NumerologyProfileRequest.prototype['fullName'] = undefined;






export default NumerologyProfileRequest;

