/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The PostApiOrgUsers201ResponseData model module.
 * @module model/PostApiOrgUsers201ResponseData
 * @version 25.12.4
 */
class PostApiOrgUsers201ResponseData {
    /**
     * Constructs a new <code>PostApiOrgUsers201ResponseData</code>.
     * @alias module:model/PostApiOrgUsers201ResponseData
     * @param memberId {String} 
     * @param role {String} 
     */
    constructor(memberId, role) { 
        
        PostApiOrgUsers201ResponseData.initialize(this, memberId, role);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, memberId, role) { 
        obj['memberId'] = memberId;
        obj['role'] = role;
    }

    /**
     * Constructs a <code>PostApiOrgUsers201ResponseData</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/PostApiOrgUsers201ResponseData} obj Optional instance to populate.
     * @return {module:model/PostApiOrgUsers201ResponseData} The populated <code>PostApiOrgUsers201ResponseData</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new PostApiOrgUsers201ResponseData();

            if (data.hasOwnProperty('memberId')) {
                obj['memberId'] = ApiClient.convertToType(data['memberId'], 'String');
            }
            if (data.hasOwnProperty('userId')) {
                obj['userId'] = ApiClient.convertToType(data['userId'], 'String');
            }
            if (data.hasOwnProperty('role')) {
                obj['role'] = ApiClient.convertToType(data['role'], 'String');
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>PostApiOrgUsers201ResponseData</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>PostApiOrgUsers201ResponseData</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of PostApiOrgUsers201ResponseData.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['memberId'] && !(typeof data['memberId'] === 'string' || data['memberId'] instanceof String)) {
            throw new Error("Expected the field `memberId` to be a primitive type in the JSON string but got " + data['memberId']);
        }
        // ensure the json data is a string
        if (data['userId'] && !(typeof data['userId'] === 'string' || data['userId'] instanceof String)) {
            throw new Error("Expected the field `userId` to be a primitive type in the JSON string but got " + data['userId']);
        }
        // ensure the json data is a string
        if (data['role'] && !(typeof data['role'] === 'string' || data['role'] instanceof String)) {
            throw new Error("Expected the field `role` to be a primitive type in the JSON string but got " + data['role']);
        }

        return true;
    }

/**
     * @return {String}
     */
    getMemberId() {
        return this.memberId;
    }

    /**
     * @param {String} memberId
     */
    setMemberId(memberId) {
        this['memberId'] = memberId;
    }
/**
     * @return {String}
     */
    getUserId() {
        return this.userId;
    }

    /**
     * @param {String} userId
     */
    setUserId(userId) {
        this['userId'] = userId;
    }
/**
     * @return {String}
     */
    getRole() {
        return this.role;
    }

    /**
     * @param {String} role
     */
    setRole(role) {
        this['role'] = role;
    }

}

PostApiOrgUsers201ResponseData.RequiredProperties = ["memberId", "role"];

/**
 * @member {String} memberId
 */
PostApiOrgUsers201ResponseData.prototype['memberId'] = undefined;

/**
 * @member {String} userId
 */
PostApiOrgUsers201ResponseData.prototype['userId'] = undefined;

/**
 * @member {String} role
 */
PostApiOrgUsers201ResponseData.prototype['role'] = undefined;






export default PostApiOrgUsers201ResponseData;

