/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The PostApiOrgUsersRequest model module.
 * @module model/PostApiOrgUsersRequest
 * @version 25.12.4
 */
class PostApiOrgUsersRequest {
    /**
     * Constructs a new <code>PostApiOrgUsersRequest</code>.
     * @alias module:model/PostApiOrgUsersRequest
     * @param email {String} 
     * @param role {String} 
     */
    constructor(email, role) { 
        
        PostApiOrgUsersRequest.initialize(this, email, role);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, email, role) { 
        obj['email'] = email;
        obj['role'] = role;
    }

    /**
     * Constructs a <code>PostApiOrgUsersRequest</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/PostApiOrgUsersRequest} obj Optional instance to populate.
     * @return {module:model/PostApiOrgUsersRequest} The populated <code>PostApiOrgUsersRequest</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new PostApiOrgUsersRequest();

            if (data.hasOwnProperty('email')) {
                obj['email'] = ApiClient.convertToType(data['email'], 'String');
            }
            if (data.hasOwnProperty('name')) {
                obj['name'] = ApiClient.convertToType(data['name'], 'String');
            }
            if (data.hasOwnProperty('role')) {
                obj['role'] = ApiClient.convertToType(data['role'], 'String');
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>PostApiOrgUsersRequest</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>PostApiOrgUsersRequest</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of PostApiOrgUsersRequest.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['email'] && !(typeof data['email'] === 'string' || data['email'] instanceof String)) {
            throw new Error("Expected the field `email` to be a primitive type in the JSON string but got " + data['email']);
        }
        // ensure the json data is a string
        if (data['name'] && !(typeof data['name'] === 'string' || data['name'] instanceof String)) {
            throw new Error("Expected the field `name` to be a primitive type in the JSON string but got " + data['name']);
        }
        // ensure the json data is a string
        if (data['role'] && !(typeof data['role'] === 'string' || data['role'] instanceof String)) {
            throw new Error("Expected the field `role` to be a primitive type in the JSON string but got " + data['role']);
        }

        return true;
    }

/**
     * @return {String}
     */
    getEmail() {
        return this.email;
    }

    /**
     * @param {String} email
     */
    setEmail(email) {
        this['email'] = email;
    }
/**
     * @return {String}
     */
    getName() {
        return this.name;
    }

    /**
     * @param {String} name
     */
    setName(name) {
        this['name'] = name;
    }
/**
     * @return {String}
     */
    getRole() {
        return this.role;
    }

    /**
     * @param {String} role
     */
    setRole(role) {
        this['role'] = role;
    }

}

PostApiOrgUsersRequest.RequiredProperties = ["email", "role"];

/**
 * @member {String} email
 */
PostApiOrgUsersRequest.prototype['email'] = undefined;

/**
 * @member {String} name
 */
PostApiOrgUsersRequest.prototype['name'] = undefined;

/**
 * @member {String} role
 */
PostApiOrgUsersRequest.prototype['role'] = undefined;






export default PostApiOrgUsersRequest;

