/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import Aspect1 from './Aspect1';
import CelestialPoint1 from './CelestialPoint1';
import ChartEntry1 from './ChartEntry1';
import Houses from './Houses';

/**
 * The ProgressionsData model module.
 * @module model/ProgressionsData
 * @version 25.12.4
 */
class ProgressionsData {
    /**
     * Constructs a new <code>ProgressionsData</code>.
     * @alias module:model/ProgressionsData
     * @param progressedDate {String} 
     * @param natalDate {String} 
     * @param targetDate {String} 
     * @param aspects {Array.<module:model/Aspect1>} 
     * @param aspectsToNatal {Array.<module:model/Aspect1>} 
     * @param points {Object.<String, module:model/CelestialPoint1>} 
     * @param natalPoints {Object.<String, module:model/CelestialPoint1>} 
     * @param houses {module:model/Houses} 
     * @param charts {Object.<String, module:model/ChartEntry1>} 
     */
    constructor(progressedDate, natalDate, targetDate, aspects, aspectsToNatal, points, natalPoints, houses, charts) { 
        
        ProgressionsData.initialize(this, progressedDate, natalDate, targetDate, aspects, aspectsToNatal, points, natalPoints, houses, charts);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, progressedDate, natalDate, targetDate, aspects, aspectsToNatal, points, natalPoints, houses, charts) { 
        obj['progressedDate'] = progressedDate;
        obj['natalDate'] = natalDate;
        obj['targetDate'] = targetDate;
        obj['aspects'] = aspects;
        obj['aspectsToNatal'] = aspectsToNatal;
        obj['points'] = points;
        obj['natalPoints'] = natalPoints;
        obj['houses'] = houses;
        obj['charts'] = charts;
    }

    /**
     * Constructs a <code>ProgressionsData</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/ProgressionsData} obj Optional instance to populate.
     * @return {module:model/ProgressionsData} The populated <code>ProgressionsData</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new ProgressionsData();

            if (data.hasOwnProperty('progressedDate')) {
                obj['progressedDate'] = ApiClient.convertToType(data['progressedDate'], 'String');
            }
            if (data.hasOwnProperty('natalDate')) {
                obj['natalDate'] = ApiClient.convertToType(data['natalDate'], 'String');
            }
            if (data.hasOwnProperty('targetDate')) {
                obj['targetDate'] = ApiClient.convertToType(data['targetDate'], 'String');
            }
            if (data.hasOwnProperty('aspects')) {
                obj['aspects'] = ApiClient.convertToType(data['aspects'], [Aspect1]);
            }
            if (data.hasOwnProperty('aspectsToNatal')) {
                obj['aspectsToNatal'] = ApiClient.convertToType(data['aspectsToNatal'], [Aspect1]);
            }
            if (data.hasOwnProperty('points')) {
                obj['points'] = ApiClient.convertToType(data['points'], {'String': CelestialPoint1});
            }
            if (data.hasOwnProperty('natalPoints')) {
                obj['natalPoints'] = ApiClient.convertToType(data['natalPoints'], {'String': CelestialPoint1});
            }
            if (data.hasOwnProperty('houses')) {
                obj['houses'] = Houses.constructFromObject(data['houses']);
            }
            if (data.hasOwnProperty('charts')) {
                obj['charts'] = ApiClient.convertToType(data['charts'], {'String': ChartEntry1});
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>ProgressionsData</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>ProgressionsData</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of ProgressionsData.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['progressedDate'] && !(typeof data['progressedDate'] === 'string' || data['progressedDate'] instanceof String)) {
            throw new Error("Expected the field `progressedDate` to be a primitive type in the JSON string but got " + data['progressedDate']);
        }
        // ensure the json data is a string
        if (data['natalDate'] && !(typeof data['natalDate'] === 'string' || data['natalDate'] instanceof String)) {
            throw new Error("Expected the field `natalDate` to be a primitive type in the JSON string but got " + data['natalDate']);
        }
        // ensure the json data is a string
        if (data['targetDate'] && !(typeof data['targetDate'] === 'string' || data['targetDate'] instanceof String)) {
            throw new Error("Expected the field `targetDate` to be a primitive type in the JSON string but got " + data['targetDate']);
        }
        if (data['aspects']) { // data not null
            // ensure the json data is an array
            if (!Array.isArray(data['aspects'])) {
                throw new Error("Expected the field `aspects` to be an array in the JSON data but got " + data['aspects']);
            }
            // validate the optional field `aspects` (array)
            for (const item of data['aspects']) {
                Aspect1.validateJSON(item);
            };
        }
        if (data['aspectsToNatal']) { // data not null
            // ensure the json data is an array
            if (!Array.isArray(data['aspectsToNatal'])) {
                throw new Error("Expected the field `aspectsToNatal` to be an array in the JSON data but got " + data['aspectsToNatal']);
            }
            // validate the optional field `aspectsToNatal` (array)
            for (const item of data['aspectsToNatal']) {
                Aspect1.validateJSON(item);
            };
        }
        // validate the optional field `houses`
        if (data['houses']) { // data not null
          Houses.validateJSON(data['houses']);
        }

        return true;
    }

/**
     * @return {String}
     */
    getProgressedDate() {
        return this.progressedDate;
    }

    /**
     * @param {String} progressedDate
     */
    setProgressedDate(progressedDate) {
        this['progressedDate'] = progressedDate;
    }
/**
     * @return {String}
     */
    getNatalDate() {
        return this.natalDate;
    }

    /**
     * @param {String} natalDate
     */
    setNatalDate(natalDate) {
        this['natalDate'] = natalDate;
    }
/**
     * @return {String}
     */
    getTargetDate() {
        return this.targetDate;
    }

    /**
     * @param {String} targetDate
     */
    setTargetDate(targetDate) {
        this['targetDate'] = targetDate;
    }
/**
     * @return {Array.<module:model/Aspect1>}
     */
    getAspects() {
        return this.aspects;
    }

    /**
     * @param {Array.<module:model/Aspect1>} aspects
     */
    setAspects(aspects) {
        this['aspects'] = aspects;
    }
/**
     * @return {Array.<module:model/Aspect1>}
     */
    getAspectsToNatal() {
        return this.aspectsToNatal;
    }

    /**
     * @param {Array.<module:model/Aspect1>} aspectsToNatal
     */
    setAspectsToNatal(aspectsToNatal) {
        this['aspectsToNatal'] = aspectsToNatal;
    }
/**
     * @return {Object.<String, module:model/CelestialPoint1>}
     */
    getPoints() {
        return this.points;
    }

    /**
     * @param {Object.<String, module:model/CelestialPoint1>} points
     */
    setPoints(points) {
        this['points'] = points;
    }
/**
     * @return {Object.<String, module:model/CelestialPoint1>}
     */
    getNatalPoints() {
        return this.natalPoints;
    }

    /**
     * @param {Object.<String, module:model/CelestialPoint1>} natalPoints
     */
    setNatalPoints(natalPoints) {
        this['natalPoints'] = natalPoints;
    }
/**
     * @return {module:model/Houses}
     */
    getHouses() {
        return this.houses;
    }

    /**
     * @param {module:model/Houses} houses
     */
    setHouses(houses) {
        this['houses'] = houses;
    }
/**
     * @return {Object.<String, module:model/ChartEntry1>}
     */
    getCharts() {
        return this.charts;
    }

    /**
     * @param {Object.<String, module:model/ChartEntry1>} charts
     */
    setCharts(charts) {
        this['charts'] = charts;
    }

}

ProgressionsData.RequiredProperties = ["progressedDate", "natalDate", "targetDate", "aspects", "aspectsToNatal", "points", "natalPoints", "houses", "charts"];

/**
 * @member {String} progressedDate
 */
ProgressionsData.prototype['progressedDate'] = undefined;

/**
 * @member {String} natalDate
 */
ProgressionsData.prototype['natalDate'] = undefined;

/**
 * @member {String} targetDate
 */
ProgressionsData.prototype['targetDate'] = undefined;

/**
 * @member {Array.<module:model/Aspect1>} aspects
 */
ProgressionsData.prototype['aspects'] = undefined;

/**
 * @member {Array.<module:model/Aspect1>} aspectsToNatal
 */
ProgressionsData.prototype['aspectsToNatal'] = undefined;

/**
 * @member {Object.<String, module:model/CelestialPoint1>} points
 */
ProgressionsData.prototype['points'] = undefined;

/**
 * @member {Object.<String, module:model/CelestialPoint1>} natalPoints
 */
ProgressionsData.prototype['natalPoints'] = undefined;

/**
 * @member {module:model/Houses} houses
 */
ProgressionsData.prototype['houses'] = undefined;

/**
 * @member {Object.<String, module:model/ChartEntry1>} charts
 */
ProgressionsData.prototype['charts'] = undefined;






export default ProgressionsData;

