/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The ReportPeriod model module.
 * @module model/ReportPeriod
 * @version 25.12.4
 */
class ReportPeriod {
    /**
     * Constructs a new <code>ReportPeriod</code>.
     * @alias module:model/ReportPeriod
     * @param year {String} 
     */
    constructor(year) { 
        
        ReportPeriod.initialize(this, year);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, year) { 
        obj['year'] = year;
    }

    /**
     * Constructs a <code>ReportPeriod</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/ReportPeriod} obj Optional instance to populate.
     * @return {module:model/ReportPeriod} The populated <code>ReportPeriod</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new ReportPeriod();

            if (data.hasOwnProperty('year')) {
                obj['year'] = ApiClient.convertToType(data['year'], 'String');
            }
            if (data.hasOwnProperty('week')) {
                obj['week'] = ApiClient.convertToType(data['week'], 'String');
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>ReportPeriod</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>ReportPeriod</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of ReportPeriod.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['year'] && !(typeof data['year'] === 'string' || data['year'] instanceof String)) {
            throw new Error("Expected the field `year` to be a primitive type in the JSON string but got " + data['year']);
        }
        // ensure the json data is a string
        if (data['week'] && !(typeof data['week'] === 'string' || data['week'] instanceof String)) {
            throw new Error("Expected the field `week` to be a primitive type in the JSON string but got " + data['week']);
        }

        return true;
    }

/**
     * @return {String}
     */
    getYear() {
        return this.year;
    }

    /**
     * @param {String} year
     */
    setYear(year) {
        this['year'] = year;
    }
/**
     * @return {String}
     */
    getWeek() {
        return this.week;
    }

    /**
     * @param {String} week
     */
    setWeek(week) {
        this['week'] = week;
    }

}

ReportPeriod.RequiredProperties = ["year"];

/**
 * @member {String} year
 */
ReportPeriod.prototype['year'] = undefined;

/**
 * @member {String} week
 */
ReportPeriod.prototype['week'] = undefined;






export default ReportPeriod;

