/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import Location from './Location';

/**
 * The SolarReturnRequest model module.
 * @module model/SolarReturnRequest
 * @version 25.12.4
 */
class SolarReturnRequest {
    /**
     * Constructs a new <code>SolarReturnRequest</code>.
     * @alias module:model/SolarReturnRequest
     * @param birthDateTime {String} Birth date and time in YYYY-MM-DDTHH:mm format
     * @param birthLocation {module:model/Location} 
     */
    constructor(birthDateTime, birthLocation) { 
        
        SolarReturnRequest.initialize(this, birthDateTime, birthLocation);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, birthDateTime, birthLocation) { 
        obj['birthDateTime'] = birthDateTime;
        obj['birthLocation'] = birthLocation;
        obj['houseSystem'] = 'placidus';
        obj['language'] = 'en';
        obj['includeText'] = true;
        obj['includeReadableEntities'] = false;
    }

    /**
     * Constructs a <code>SolarReturnRequest</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/SolarReturnRequest} obj Optional instance to populate.
     * @return {module:model/SolarReturnRequest} The populated <code>SolarReturnRequest</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new SolarReturnRequest();

            if (data.hasOwnProperty('birthDateTime')) {
                obj['birthDateTime'] = ApiClient.convertToType(data['birthDateTime'], 'String');
            }
            if (data.hasOwnProperty('birthLocation')) {
                obj['birthLocation'] = Location.constructFromObject(data['birthLocation']);
            }
            if (data.hasOwnProperty('returnYear')) {
                obj['returnYear'] = ApiClient.convertToType(data['returnYear'], 'Number');
            }
            if (data.hasOwnProperty('houseSystem')) {
                obj['houseSystem'] = ApiClient.convertToType(data['houseSystem'], 'String');
            }
            if (data.hasOwnProperty('language')) {
                obj['language'] = ApiClient.convertToType(data['language'], 'String');
            }
            if (data.hasOwnProperty('includeText')) {
                obj['includeText'] = ApiClient.convertToType(data['includeText'], 'Boolean');
            }
            if (data.hasOwnProperty('includeReadableEntities')) {
                obj['includeReadableEntities'] = ApiClient.convertToType(data['includeReadableEntities'], 'Boolean');
            }
            if (data.hasOwnProperty('points')) {
                obj['points'] = ApiClient.convertToType(data['points'], ['String']);
            }
            if (data.hasOwnProperty('orbs')) {
                obj['orbs'] = ApiClient.convertToType(data['orbs'], {'String': 'Number'});
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>SolarReturnRequest</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>SolarReturnRequest</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of SolarReturnRequest.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['birthDateTime'] && !(typeof data['birthDateTime'] === 'string' || data['birthDateTime'] instanceof String)) {
            throw new Error("Expected the field `birthDateTime` to be a primitive type in the JSON string but got " + data['birthDateTime']);
        }
        // validate the optional field `birthLocation`
        if (data['birthLocation']) { // data not null
          Location.validateJSON(data['birthLocation']);
        }
        // ensure the json data is a string
        if (data['houseSystem'] && !(typeof data['houseSystem'] === 'string' || data['houseSystem'] instanceof String)) {
            throw new Error("Expected the field `houseSystem` to be a primitive type in the JSON string but got " + data['houseSystem']);
        }
        // ensure the json data is a string
        if (data['language'] && !(typeof data['language'] === 'string' || data['language'] instanceof String)) {
            throw new Error("Expected the field `language` to be a primitive type in the JSON string but got " + data['language']);
        }
        // ensure the json data is an array
        if (!Array.isArray(data['points'])) {
            throw new Error("Expected the field `points` to be an array in the JSON data but got " + data['points']);
        }

        return true;
    }

/**
     * Returns Birth date and time in YYYY-MM-DDTHH:mm format
     * @return {String}
     */
    getBirthDateTime() {
        return this.birthDateTime;
    }

    /**
     * Sets Birth date and time in YYYY-MM-DDTHH:mm format
     * @param {String} birthDateTime Birth date and time in YYYY-MM-DDTHH:mm format
     */
    setBirthDateTime(birthDateTime) {
        this['birthDateTime'] = birthDateTime;
    }
/**
     * @return {module:model/Location}
     */
    getBirthLocation() {
        return this.birthLocation;
    }

    /**
     * @param {module:model/Location} birthLocation
     */
    setBirthLocation(birthLocation) {
        this['birthLocation'] = birthLocation;
    }
/**
     * Returns Year for solar return calculation. Defaults to current year.
     * @return {Number}
     */
    getReturnYear() {
        return this.returnYear;
    }

    /**
     * Sets Year for solar return calculation. Defaults to current year.
     * @param {Number} returnYear Year for solar return calculation. Defaults to current year.
     */
    setReturnYear(returnYear) {
        this['returnYear'] = returnYear;
    }
/**
     * Returns House system for calculations (default: \"placidus\")
     * @return {module:model/SolarReturnRequest.HouseSystemEnum}
     */
    getHouseSystem() {
        return this.houseSystem;
    }

    /**
     * Sets House system for calculations (default: \"placidus\")
     * @param {module:model/SolarReturnRequest.HouseSystemEnum} houseSystem House system for calculations (default: \"placidus\")
     */
    setHouseSystem(houseSystem) {
        this['houseSystem'] = houseSystem;
    }
/**
     * Returns Language code for text content
     * @return {String}
     */
    getLanguage() {
        return this.language;
    }

    /**
     * Sets Language code for text content
     * @param {String} language Language code for text content
     */
    setLanguage(language) {
        this['language'] = language;
    }
/**
     * Returns Include interpretation text
     * @return {Boolean}
     */
    getIncludeText() {
        return this.includeText;
    }

    /**
     * Sets Include interpretation text
     * @param {Boolean} includeText Include interpretation text
     */
    setIncludeText(includeText) {
        this['includeText'] = includeText;
    }
/**
     * Returns Include human-readable entity titles
     * @return {Boolean}
     */
    getIncludeReadableEntities() {
        return this.includeReadableEntities;
    }

    /**
     * Sets Include human-readable entity titles
     * @param {Boolean} includeReadableEntities Include human-readable entity titles
     */
    setIncludeReadableEntities(includeReadableEntities) {
        this['includeReadableEntities'] = includeReadableEntities;
    }
/**
     * Returns Celestial points to calculate (e.g., [\"sun\", \"moon\", \"mercury\"]). Defaults to all major planets.
     * @return {Array.<String>}
     */
    getPoints() {
        return this.points;
    }

    /**
     * Sets Celestial points to calculate (e.g., [\"sun\", \"moon\", \"mercury\"]). Defaults to all major planets.
     * @param {Array.<String>} points Celestial points to calculate (e.g., [\"sun\", \"moon\", \"mercury\"]). Defaults to all major planets.
     */
    setPoints(points) {
        this['points'] = points;
    }
/**
     * Returns Custom orb values per aspect type (e.g., { \"conjunction\": 8, \"opposition\": 6 })
     * @return {Object.<String, Number>}
     */
    getOrbs() {
        return this.orbs;
    }

    /**
     * Sets Custom orb values per aspect type (e.g., { \"conjunction\": 8, \"opposition\": 6 })
     * @param {Object.<String, Number>} orbs Custom orb values per aspect type (e.g., { \"conjunction\": 8, \"opposition\": 6 })
     */
    setOrbs(orbs) {
        this['orbs'] = orbs;
    }

}

SolarReturnRequest.RequiredProperties = ["birthDateTime", "birthLocation"];

/**
 * Birth date and time in YYYY-MM-DDTHH:mm format
 * @member {String} birthDateTime
 */
SolarReturnRequest.prototype['birthDateTime'] = undefined;

/**
 * @member {module:model/Location} birthLocation
 */
SolarReturnRequest.prototype['birthLocation'] = undefined;

/**
 * Year for solar return calculation. Defaults to current year.
 * @member {Number} returnYear
 */
SolarReturnRequest.prototype['returnYear'] = undefined;

/**
 * House system for calculations (default: \"placidus\")
 * @member {module:model/SolarReturnRequest.HouseSystemEnum} houseSystem
 * @default 'placidus'
 */
SolarReturnRequest.prototype['houseSystem'] = 'placidus';

/**
 * Language code for text content
 * @member {String} language
 * @default 'en'
 */
SolarReturnRequest.prototype['language'] = 'en';

/**
 * Include interpretation text
 * @member {Boolean} includeText
 * @default true
 */
SolarReturnRequest.prototype['includeText'] = true;

/**
 * Include human-readable entity titles
 * @member {Boolean} includeReadableEntities
 * @default false
 */
SolarReturnRequest.prototype['includeReadableEntities'] = false;

/**
 * Celestial points to calculate (e.g., [\"sun\", \"moon\", \"mercury\"]). Defaults to all major planets.
 * @member {Array.<String>} points
 */
SolarReturnRequest.prototype['points'] = undefined;

/**
 * Custom orb values per aspect type (e.g., { \"conjunction\": 8, \"opposition\": 6 })
 * @member {Object.<String, Number>} orbs
 */
SolarReturnRequest.prototype['orbs'] = undefined;





/**
 * Allowed values for the <code>houseSystem</code> property.
 * @enum {String}
 * @readonly
 */
SolarReturnRequest['HouseSystemEnum'] = {

    /**
     * value: "placidus"
     * @const
     */
    "placidus": "placidus",

    /**
     * value: "koch"
     * @const
     */
    "koch": "koch",

    /**
     * value: "equal"
     * @const
     */
    "equal": "equal",

    /**
     * value: "whole"
     * @const
     */
    "whole": "whole",

    /**
     * value: "campanus"
     * @const
     */
    "campanus": "campanus",

    /**
     * value: "regiomontanus"
     * @const
     */
    "regiomontanus": "regiomontanus",

    /**
     * value: "porphyry"
     * @const
     */
    "porphyry": "porphyry"
};



export default SolarReturnRequest;

