/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The SubscriptionPlan model module.
 * @module model/SubscriptionPlan
 * @version 25.12.4
 */
class SubscriptionPlan {
    /**
     * Constructs a new <code>SubscriptionPlan</code>.
     * @alias module:model/SubscriptionPlan
     * @param id {String} 
     * @param name {String} 
     * @param modules {Array.<String>} 
     * @param discountPercentage {Number} 
     * @param priceCents {Number} 
     */
    constructor(id, name, modules, discountPercentage, priceCents) { 
        
        SubscriptionPlan.initialize(this, id, name, modules, discountPercentage, priceCents);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, id, name, modules, discountPercentage, priceCents) { 
        obj['id'] = id;
        obj['name'] = name;
        obj['modules'] = modules;
        obj['discountPercentage'] = discountPercentage;
        obj['priceCents'] = priceCents;
    }

    /**
     * Constructs a <code>SubscriptionPlan</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/SubscriptionPlan} obj Optional instance to populate.
     * @return {module:model/SubscriptionPlan} The populated <code>SubscriptionPlan</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new SubscriptionPlan();

            if (data.hasOwnProperty('id')) {
                obj['id'] = ApiClient.convertToType(data['id'], 'String');
            }
            if (data.hasOwnProperty('name')) {
                obj['name'] = ApiClient.convertToType(data['name'], 'String');
            }
            if (data.hasOwnProperty('description')) {
                obj['description'] = ApiClient.convertToType(data['description'], 'String');
            }
            if (data.hasOwnProperty('modules')) {
                obj['modules'] = ApiClient.convertToType(data['modules'], ['String']);
            }
            if (data.hasOwnProperty('discountPercentage')) {
                obj['discountPercentage'] = ApiClient.convertToType(data['discountPercentage'], 'Number');
            }
            if (data.hasOwnProperty('priceCents')) {
                obj['priceCents'] = ApiClient.convertToType(data['priceCents'], 'Number');
            }
            if (data.hasOwnProperty('stripePriceId')) {
                obj['stripePriceId'] = ApiClient.convertToType(data['stripePriceId'], 'String');
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>SubscriptionPlan</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>SubscriptionPlan</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of SubscriptionPlan.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['id'] && !(typeof data['id'] === 'string' || data['id'] instanceof String)) {
            throw new Error("Expected the field `id` to be a primitive type in the JSON string but got " + data['id']);
        }
        // ensure the json data is a string
        if (data['name'] && !(typeof data['name'] === 'string' || data['name'] instanceof String)) {
            throw new Error("Expected the field `name` to be a primitive type in the JSON string but got " + data['name']);
        }
        // ensure the json data is a string
        if (data['description'] && !(typeof data['description'] === 'string' || data['description'] instanceof String)) {
            throw new Error("Expected the field `description` to be a primitive type in the JSON string but got " + data['description']);
        }
        // ensure the json data is an array
        if (!Array.isArray(data['modules'])) {
            throw new Error("Expected the field `modules` to be an array in the JSON data but got " + data['modules']);
        }
        // ensure the json data is a string
        if (data['stripePriceId'] && !(typeof data['stripePriceId'] === 'string' || data['stripePriceId'] instanceof String)) {
            throw new Error("Expected the field `stripePriceId` to be a primitive type in the JSON string but got " + data['stripePriceId']);
        }

        return true;
    }

/**
     * @return {String}
     */
    getId() {
        return this.id;
    }

    /**
     * @param {String} id
     */
    setId(id) {
        this['id'] = id;
    }
/**
     * @return {String}
     */
    getName() {
        return this.name;
    }

    /**
     * @param {String} name
     */
    setName(name) {
        this['name'] = name;
    }
/**
     * @return {String}
     */
    getDescription() {
        return this.description;
    }

    /**
     * @param {String} description
     */
    setDescription(description) {
        this['description'] = description;
    }
/**
     * @return {Array.<String>}
     */
    getModules() {
        return this.modules;
    }

    /**
     * @param {Array.<String>} modules
     */
    setModules(modules) {
        this['modules'] = modules;
    }
/**
     * @return {Number}
     */
    getDiscountPercentage() {
        return this.discountPercentage;
    }

    /**
     * @param {Number} discountPercentage
     */
    setDiscountPercentage(discountPercentage) {
        this['discountPercentage'] = discountPercentage;
    }
/**
     * @return {Number}
     */
    getPriceCents() {
        return this.priceCents;
    }

    /**
     * @param {Number} priceCents
     */
    setPriceCents(priceCents) {
        this['priceCents'] = priceCents;
    }
/**
     * @return {String}
     */
    getStripePriceId() {
        return this.stripePriceId;
    }

    /**
     * @param {String} stripePriceId
     */
    setStripePriceId(stripePriceId) {
        this['stripePriceId'] = stripePriceId;
    }

}

SubscriptionPlan.RequiredProperties = ["id", "name", "modules", "discountPercentage", "priceCents"];

/**
 * @member {String} id
 */
SubscriptionPlan.prototype['id'] = undefined;

/**
 * @member {String} name
 */
SubscriptionPlan.prototype['name'] = undefined;

/**
 * @member {String} description
 */
SubscriptionPlan.prototype['description'] = undefined;

/**
 * @member {Array.<String>} modules
 */
SubscriptionPlan.prototype['modules'] = undefined;

/**
 * @member {Number} discountPercentage
 */
SubscriptionPlan.prototype['discountPercentage'] = undefined;

/**
 * @member {Number} priceCents
 */
SubscriptionPlan.prototype['priceCents'] = undefined;

/**
 * @member {String} stripePriceId
 */
SubscriptionPlan.prototype['stripePriceId'] = undefined;






export default SubscriptionPlan;

