/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import Twilight from './Twilight';

/**
 * The SunInfo model module.
 * @module model/SunInfo
 * @version 25.12.4
 */
class SunInfo {
    /**
     * Constructs a new <code>SunInfo</code>.
     * @alias module:model/SunInfo
     * @param rise {String} 
     * @param set {String} 
     * @param transit {String} 
     * @param distance {Number} 
     * @param diameterDegrees {Number} 
     * @param twilight {module:model/Twilight} 
     */
    constructor(rise, set, transit, distance, diameterDegrees, twilight) { 
        
        SunInfo.initialize(this, rise, set, transit, distance, diameterDegrees, twilight);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, rise, set, transit, distance, diameterDegrees, twilight) { 
        obj['rise'] = rise;
        obj['set'] = set;
        obj['transit'] = transit;
        obj['distance'] = distance;
        obj['diameterDegrees'] = diameterDegrees;
        obj['twilight'] = twilight;
    }

    /**
     * Constructs a <code>SunInfo</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/SunInfo} obj Optional instance to populate.
     * @return {module:model/SunInfo} The populated <code>SunInfo</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new SunInfo();

            if (data.hasOwnProperty('rise')) {
                obj['rise'] = ApiClient.convertToType(data['rise'], 'String');
            }
            if (data.hasOwnProperty('set')) {
                obj['set'] = ApiClient.convertToType(data['set'], 'String');
            }
            if (data.hasOwnProperty('transit')) {
                obj['transit'] = ApiClient.convertToType(data['transit'], 'String');
            }
            if (data.hasOwnProperty('distance')) {
                obj['distance'] = ApiClient.convertToType(data['distance'], 'Number');
            }
            if (data.hasOwnProperty('diameterDegrees')) {
                obj['diameterDegrees'] = ApiClient.convertToType(data['diameterDegrees'], 'Number');
            }
            if (data.hasOwnProperty('twilight')) {
                obj['twilight'] = Twilight.constructFromObject(data['twilight']);
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>SunInfo</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>SunInfo</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of SunInfo.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['rise'] && !(typeof data['rise'] === 'string' || data['rise'] instanceof String)) {
            throw new Error("Expected the field `rise` to be a primitive type in the JSON string but got " + data['rise']);
        }
        // ensure the json data is a string
        if (data['set'] && !(typeof data['set'] === 'string' || data['set'] instanceof String)) {
            throw new Error("Expected the field `set` to be a primitive type in the JSON string but got " + data['set']);
        }
        // ensure the json data is a string
        if (data['transit'] && !(typeof data['transit'] === 'string' || data['transit'] instanceof String)) {
            throw new Error("Expected the field `transit` to be a primitive type in the JSON string but got " + data['transit']);
        }
        // validate the optional field `twilight`
        if (data['twilight']) { // data not null
          Twilight.validateJSON(data['twilight']);
        }

        return true;
    }

/**
     * @return {String}
     */
    getRise() {
        return this.rise;
    }

    /**
     * @param {String} rise
     */
    setRise(rise) {
        this['rise'] = rise;
    }
/**
     * @return {String}
     */
    getSet() {
        return this.set;
    }

    /**
     * @param {String} set
     */
    setSet(set) {
        this['set'] = set;
    }
/**
     * @return {String}
     */
    getTransit() {
        return this.transit;
    }

    /**
     * @param {String} transit
     */
    setTransit(transit) {
        this['transit'] = transit;
    }
/**
     * @return {Number}
     */
    getDistance() {
        return this.distance;
    }

    /**
     * @param {Number} distance
     */
    setDistance(distance) {
        this['distance'] = distance;
    }
/**
     * @return {Number}
     */
    getDiameterDegrees() {
        return this.diameterDegrees;
    }

    /**
     * @param {Number} diameterDegrees
     */
    setDiameterDegrees(diameterDegrees) {
        this['diameterDegrees'] = diameterDegrees;
    }
/**
     * @return {module:model/Twilight}
     */
    getTwilight() {
        return this.twilight;
    }

    /**
     * @param {module:model/Twilight} twilight
     */
    setTwilight(twilight) {
        this['twilight'] = twilight;
    }

}

SunInfo.RequiredProperties = ["rise", "set", "transit", "distance", "diameterDegrees", "twilight"];

/**
 * @member {String} rise
 */
SunInfo.prototype['rise'] = undefined;

/**
 * @member {String} set
 */
SunInfo.prototype['set'] = undefined;

/**
 * @member {String} transit
 */
SunInfo.prototype['transit'] = undefined;

/**
 * @member {Number} distance
 */
SunInfo.prototype['distance'] = undefined;

/**
 * @member {Number} diameterDegrees
 */
SunInfo.prototype['diameterDegrees'] = undefined;

/**
 * @member {module:model/Twilight} twilight
 */
SunInfo.prototype['twilight'] = undefined;






export default SunInfo;

