/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import Aspect1 from './Aspect1';
import ChartEntry from './ChartEntry';

/**
 * The SynastryData model module.
 * @module model/SynastryData
 * @version 25.12.4
 */
class SynastryData {
    /**
     * Constructs a new <code>SynastryData</code>.
     * @alias module:model/SynastryData
     * @param aspects1to2 {Array.<module:model/Aspect1>} 
     * @param aspects2to1 {Array.<module:model/Aspect1>} 
     * @param charts {Object.<String, module:model/ChartEntry>} 
     */
    constructor(aspects1to2, aspects2to1, charts) { 
        
        SynastryData.initialize(this, aspects1to2, aspects2to1, charts);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, aspects1to2, aspects2to1, charts) { 
        obj['aspects1to2'] = aspects1to2;
        obj['aspects2to1'] = aspects2to1;
        obj['charts'] = charts;
    }

    /**
     * Constructs a <code>SynastryData</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/SynastryData} obj Optional instance to populate.
     * @return {module:model/SynastryData} The populated <code>SynastryData</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new SynastryData();

            if (data.hasOwnProperty('aspects1to2')) {
                obj['aspects1to2'] = ApiClient.convertToType(data['aspects1to2'], [Aspect1]);
            }
            if (data.hasOwnProperty('aspects2to1')) {
                obj['aspects2to1'] = ApiClient.convertToType(data['aspects2to1'], [Aspect1]);
            }
            if (data.hasOwnProperty('charts')) {
                obj['charts'] = ApiClient.convertToType(data['charts'], {'String': ChartEntry});
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>SynastryData</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>SynastryData</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of SynastryData.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        if (data['aspects1to2']) { // data not null
            // ensure the json data is an array
            if (!Array.isArray(data['aspects1to2'])) {
                throw new Error("Expected the field `aspects1to2` to be an array in the JSON data but got " + data['aspects1to2']);
            }
            // validate the optional field `aspects1to2` (array)
            for (const item of data['aspects1to2']) {
                Aspect1.validateJSON(item);
            };
        }
        if (data['aspects2to1']) { // data not null
            // ensure the json data is an array
            if (!Array.isArray(data['aspects2to1'])) {
                throw new Error("Expected the field `aspects2to1` to be an array in the JSON data but got " + data['aspects2to1']);
            }
            // validate the optional field `aspects2to1` (array)
            for (const item of data['aspects2to1']) {
                Aspect1.validateJSON(item);
            };
        }

        return true;
    }

/**
     * @return {Array.<module:model/Aspect1>}
     */
    getAspects1to2() {
        return this.aspects1to2;
    }

    /**
     * @param {Array.<module:model/Aspect1>} aspects1to2
     */
    setAspects1to2(aspects1to2) {
        this['aspects1to2'] = aspects1to2;
    }
/**
     * @return {Array.<module:model/Aspect1>}
     */
    getAspects2to1() {
        return this.aspects2to1;
    }

    /**
     * @param {Array.<module:model/Aspect1>} aspects2to1
     */
    setAspects2to1(aspects2to1) {
        this['aspects2to1'] = aspects2to1;
    }
/**
     * @return {Object.<String, module:model/ChartEntry>}
     */
    getCharts() {
        return this.charts;
    }

    /**
     * @param {Object.<String, module:model/ChartEntry>} charts
     */
    setCharts(charts) {
        this['charts'] = charts;
    }

}

SynastryData.RequiredProperties = ["aspects1to2", "aspects2to1", "charts"];

/**
 * @member {Array.<module:model/Aspect1>} aspects1to2
 */
SynastryData.prototype['aspects1to2'] = undefined;

/**
 * @member {Array.<module:model/Aspect1>} aspects2to1
 */
SynastryData.prototype['aspects2to1'] = undefined;

/**
 * @member {Object.<String, module:model/ChartEntry>} charts
 */
SynastryData.prototype['charts'] = undefined;






export default SynastryData;

