/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The TransitData model module.
 * @module model/TransitData
 * @version 25.12.4
 */
class TransitData {
    /**
     * Constructs a new <code>TransitData</code>.
     * @alias module:model/TransitData
     * @param crossings {Object.<String, Array.<Object>>} 
     * @param aspects {Array.<Object>} 
     */
    constructor(crossings, aspects) { 
        
        TransitData.initialize(this, crossings, aspects);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, crossings, aspects) { 
        obj['crossings'] = crossings;
        obj['aspects'] = aspects;
    }

    /**
     * Constructs a <code>TransitData</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/TransitData} obj Optional instance to populate.
     * @return {module:model/TransitData} The populated <code>TransitData</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new TransitData();

            if (data.hasOwnProperty('crossings')) {
                obj['crossings'] = ApiClient.convertToType(data['crossings'], {'String': [Object]});
            }
            if (data.hasOwnProperty('aspects')) {
                obj['aspects'] = ApiClient.convertToType(data['aspects'], [Object]);
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>TransitData</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>TransitData</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of TransitData.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is an array
        if (!Array.isArray(data['aspects'])) {
            throw new Error("Expected the field `aspects` to be an array in the JSON data but got " + data['aspects']);
        }

        return true;
    }

/**
     * @return {Object.<String, Array.<Object>>}
     */
    getCrossings() {
        return this.crossings;
    }

    /**
     * @param {Object.<String, Array.<Object>>} crossings
     */
    setCrossings(crossings) {
        this['crossings'] = crossings;
    }
/**
     * @return {Array.<Object>}
     */
    getAspects() {
        return this.aspects;
    }

    /**
     * @param {Array.<Object>} aspects
     */
    setAspects(aspects) {
        this['aspects'] = aspects;
    }

}

TransitData.RequiredProperties = ["crossings", "aspects"];

/**
 * @member {Object.<String, Array.<Object>>} crossings
 */
TransitData.prototype['crossings'] = undefined;

/**
 * @member {Array.<Object>} aspects
 */
TransitData.prototype['aspects'] = undefined;






export default TransitData;

