/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import Location from './Location';

/**
 * The TransitRequest model module.
 * @module model/TransitRequest
 * @version 25.12.4
 */
class TransitRequest {
    /**
     * Constructs a new <code>TransitRequest</code>.
     * @alias module:model/TransitRequest
     * @param birthDate {String} Birth date and time in YYYY-MM-DDTHH:mm format
     * @param birthLocation {module:model/Location} 
     * @param transitDateStart {String} Transit period start date in YYYY-MM-DDTHH:mm format
     * @param transitDateEnd {String} Transit period end date in YYYY-MM-DDTHH:mm format
     * @param transitLocation {module:model/Location} 
     */
    constructor(birthDate, birthLocation, transitDateStart, transitDateEnd, transitLocation) { 
        
        TransitRequest.initialize(this, birthDate, birthLocation, transitDateStart, transitDateEnd, transitLocation);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, birthDate, birthLocation, transitDateStart, transitDateEnd, transitLocation) { 
        obj['birthDate'] = birthDate;
        obj['birthLocation'] = birthLocation;
        obj['transitDateStart'] = transitDateStart;
        obj['transitDateEnd'] = transitDateEnd;
        obj['transitLocation'] = transitLocation;
        obj['houseSystem'] = 'placidus';
        obj['language'] = 'en';
        obj['includeText'] = true;
        obj['includeReadableEntities'] = false;
    }

    /**
     * Constructs a <code>TransitRequest</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/TransitRequest} obj Optional instance to populate.
     * @return {module:model/TransitRequest} The populated <code>TransitRequest</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new TransitRequest();

            if (data.hasOwnProperty('birthDate')) {
                obj['birthDate'] = ApiClient.convertToType(data['birthDate'], 'String');
            }
            if (data.hasOwnProperty('birthLocation')) {
                obj['birthLocation'] = Location.constructFromObject(data['birthLocation']);
            }
            if (data.hasOwnProperty('transitDateStart')) {
                obj['transitDateStart'] = ApiClient.convertToType(data['transitDateStart'], 'String');
            }
            if (data.hasOwnProperty('transitDateEnd')) {
                obj['transitDateEnd'] = ApiClient.convertToType(data['transitDateEnd'], 'String');
            }
            if (data.hasOwnProperty('transitLocation')) {
                obj['transitLocation'] = Location.constructFromObject(data['transitLocation']);
            }
            if (data.hasOwnProperty('houseSystem')) {
                obj['houseSystem'] = ApiClient.convertToType(data['houseSystem'], 'String');
            }
            if (data.hasOwnProperty('language')) {
                obj['language'] = ApiClient.convertToType(data['language'], 'String');
            }
            if (data.hasOwnProperty('includeText')) {
                obj['includeText'] = ApiClient.convertToType(data['includeText'], 'Boolean');
            }
            if (data.hasOwnProperty('includeReadableEntities')) {
                obj['includeReadableEntities'] = ApiClient.convertToType(data['includeReadableEntities'], 'Boolean');
            }
            if (data.hasOwnProperty('points')) {
                obj['points'] = ApiClient.convertToType(data['points'], ['String']);
            }
            if (data.hasOwnProperty('orbs')) {
                obj['orbs'] = ApiClient.convertToType(data['orbs'], {'String': 'Number'});
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>TransitRequest</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>TransitRequest</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of TransitRequest.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['birthDate'] && !(typeof data['birthDate'] === 'string' || data['birthDate'] instanceof String)) {
            throw new Error("Expected the field `birthDate` to be a primitive type in the JSON string but got " + data['birthDate']);
        }
        // validate the optional field `birthLocation`
        if (data['birthLocation']) { // data not null
          Location.validateJSON(data['birthLocation']);
        }
        // ensure the json data is a string
        if (data['transitDateStart'] && !(typeof data['transitDateStart'] === 'string' || data['transitDateStart'] instanceof String)) {
            throw new Error("Expected the field `transitDateStart` to be a primitive type in the JSON string but got " + data['transitDateStart']);
        }
        // ensure the json data is a string
        if (data['transitDateEnd'] && !(typeof data['transitDateEnd'] === 'string' || data['transitDateEnd'] instanceof String)) {
            throw new Error("Expected the field `transitDateEnd` to be a primitive type in the JSON string but got " + data['transitDateEnd']);
        }
        // validate the optional field `transitLocation`
        if (data['transitLocation']) { // data not null
          Location.validateJSON(data['transitLocation']);
        }
        // ensure the json data is a string
        if (data['houseSystem'] && !(typeof data['houseSystem'] === 'string' || data['houseSystem'] instanceof String)) {
            throw new Error("Expected the field `houseSystem` to be a primitive type in the JSON string but got " + data['houseSystem']);
        }
        // ensure the json data is a string
        if (data['language'] && !(typeof data['language'] === 'string' || data['language'] instanceof String)) {
            throw new Error("Expected the field `language` to be a primitive type in the JSON string but got " + data['language']);
        }
        // ensure the json data is an array
        if (!Array.isArray(data['points'])) {
            throw new Error("Expected the field `points` to be an array in the JSON data but got " + data['points']);
        }

        return true;
    }

/**
     * Returns Birth date and time in YYYY-MM-DDTHH:mm format
     * @return {String}
     */
    getBirthDate() {
        return this.birthDate;
    }

    /**
     * Sets Birth date and time in YYYY-MM-DDTHH:mm format
     * @param {String} birthDate Birth date and time in YYYY-MM-DDTHH:mm format
     */
    setBirthDate(birthDate) {
        this['birthDate'] = birthDate;
    }
/**
     * @return {module:model/Location}
     */
    getBirthLocation() {
        return this.birthLocation;
    }

    /**
     * @param {module:model/Location} birthLocation
     */
    setBirthLocation(birthLocation) {
        this['birthLocation'] = birthLocation;
    }
/**
     * Returns Transit period start date in YYYY-MM-DDTHH:mm format
     * @return {String}
     */
    getTransitDateStart() {
        return this.transitDateStart;
    }

    /**
     * Sets Transit period start date in YYYY-MM-DDTHH:mm format
     * @param {String} transitDateStart Transit period start date in YYYY-MM-DDTHH:mm format
     */
    setTransitDateStart(transitDateStart) {
        this['transitDateStart'] = transitDateStart;
    }
/**
     * Returns Transit period end date in YYYY-MM-DDTHH:mm format
     * @return {String}
     */
    getTransitDateEnd() {
        return this.transitDateEnd;
    }

    /**
     * Sets Transit period end date in YYYY-MM-DDTHH:mm format
     * @param {String} transitDateEnd Transit period end date in YYYY-MM-DDTHH:mm format
     */
    setTransitDateEnd(transitDateEnd) {
        this['transitDateEnd'] = transitDateEnd;
    }
/**
     * @return {module:model/Location}
     */
    getTransitLocation() {
        return this.transitLocation;
    }

    /**
     * @param {module:model/Location} transitLocation
     */
    setTransitLocation(transitLocation) {
        this['transitLocation'] = transitLocation;
    }
/**
     * Returns House system for calculations (default: \"placidus\")
     * @return {module:model/TransitRequest.HouseSystemEnum}
     */
    getHouseSystem() {
        return this.houseSystem;
    }

    /**
     * Sets House system for calculations (default: \"placidus\")
     * @param {module:model/TransitRequest.HouseSystemEnum} houseSystem House system for calculations (default: \"placidus\")
     */
    setHouseSystem(houseSystem) {
        this['houseSystem'] = houseSystem;
    }
/**
     * Returns Language code for text content
     * @return {String}
     */
    getLanguage() {
        return this.language;
    }

    /**
     * Sets Language code for text content
     * @param {String} language Language code for text content
     */
    setLanguage(language) {
        this['language'] = language;
    }
/**
     * Returns Include interpretation text
     * @return {Boolean}
     */
    getIncludeText() {
        return this.includeText;
    }

    /**
     * Sets Include interpretation text
     * @param {Boolean} includeText Include interpretation text
     */
    setIncludeText(includeText) {
        this['includeText'] = includeText;
    }
/**
     * Returns Include human-readable entity titles
     * @return {Boolean}
     */
    getIncludeReadableEntities() {
        return this.includeReadableEntities;
    }

    /**
     * Sets Include human-readable entity titles
     * @param {Boolean} includeReadableEntities Include human-readable entity titles
     */
    setIncludeReadableEntities(includeReadableEntities) {
        this['includeReadableEntities'] = includeReadableEntities;
    }
/**
     * Returns Celestial points to calculate (e.g., [\"sun\", \"moon\", \"mercury\"]). Defaults to all major planets.
     * @return {Array.<String>}
     */
    getPoints() {
        return this.points;
    }

    /**
     * Sets Celestial points to calculate (e.g., [\"sun\", \"moon\", \"mercury\"]). Defaults to all major planets.
     * @param {Array.<String>} points Celestial points to calculate (e.g., [\"sun\", \"moon\", \"mercury\"]). Defaults to all major planets.
     */
    setPoints(points) {
        this['points'] = points;
    }
/**
     * Returns Custom orb values per aspect type (e.g., { \"conjunction\": 8, \"opposition\": 6 })
     * @return {Object.<String, Number>}
     */
    getOrbs() {
        return this.orbs;
    }

    /**
     * Sets Custom orb values per aspect type (e.g., { \"conjunction\": 8, \"opposition\": 6 })
     * @param {Object.<String, Number>} orbs Custom orb values per aspect type (e.g., { \"conjunction\": 8, \"opposition\": 6 })
     */
    setOrbs(orbs) {
        this['orbs'] = orbs;
    }

}

TransitRequest.RequiredProperties = ["birthDate", "birthLocation", "transitDateStart", "transitDateEnd", "transitLocation"];

/**
 * Birth date and time in YYYY-MM-DDTHH:mm format
 * @member {String} birthDate
 */
TransitRequest.prototype['birthDate'] = undefined;

/**
 * @member {module:model/Location} birthLocation
 */
TransitRequest.prototype['birthLocation'] = undefined;

/**
 * Transit period start date in YYYY-MM-DDTHH:mm format
 * @member {String} transitDateStart
 */
TransitRequest.prototype['transitDateStart'] = undefined;

/**
 * Transit period end date in YYYY-MM-DDTHH:mm format
 * @member {String} transitDateEnd
 */
TransitRequest.prototype['transitDateEnd'] = undefined;

/**
 * @member {module:model/Location} transitLocation
 */
TransitRequest.prototype['transitLocation'] = undefined;

/**
 * House system for calculations (default: \"placidus\")
 * @member {module:model/TransitRequest.HouseSystemEnum} houseSystem
 * @default 'placidus'
 */
TransitRequest.prototype['houseSystem'] = 'placidus';

/**
 * Language code for text content
 * @member {String} language
 * @default 'en'
 */
TransitRequest.prototype['language'] = 'en';

/**
 * Include interpretation text
 * @member {Boolean} includeText
 * @default true
 */
TransitRequest.prototype['includeText'] = true;

/**
 * Include human-readable entity titles
 * @member {Boolean} includeReadableEntities
 * @default false
 */
TransitRequest.prototype['includeReadableEntities'] = false;

/**
 * Celestial points to calculate (e.g., [\"sun\", \"moon\", \"mercury\"]). Defaults to all major planets.
 * @member {Array.<String>} points
 */
TransitRequest.prototype['points'] = undefined;

/**
 * Custom orb values per aspect type (e.g., { \"conjunction\": 8, \"opposition\": 6 })
 * @member {Object.<String, Number>} orbs
 */
TransitRequest.prototype['orbs'] = undefined;





/**
 * Allowed values for the <code>houseSystem</code> property.
 * @enum {String}
 * @readonly
 */
TransitRequest['HouseSystemEnum'] = {

    /**
     * value: "placidus"
     * @const
     */
    "placidus": "placidus",

    /**
     * value: "koch"
     * @const
     */
    "koch": "koch",

    /**
     * value: "equal"
     * @const
     */
    "equal": "equal",

    /**
     * value: "whole"
     * @const
     */
    "whole": "whole",

    /**
     * value: "campanus"
     * @const
     */
    "campanus": "campanus",

    /**
     * value: "regiomontanus"
     * @const
     */
    "regiomontanus": "regiomontanus",

    /**
     * value: "porphyry"
     * @const
     */
    "porphyry": "porphyry"
};



export default TransitRequest;

