/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import TwilightTimes from './TwilightTimes';

/**
 * The Twilight model module.
 * @module model/Twilight
 * @version 25.12.4
 */
class Twilight {
    /**
     * Constructs a new <code>Twilight</code>.
     * @alias module:model/Twilight
     * @param civil {module:model/TwilightTimes} 
     * @param nautical {module:model/TwilightTimes} 
     * @param astronomical {module:model/TwilightTimes} 
     */
    constructor(civil, nautical, astronomical) { 
        
        Twilight.initialize(this, civil, nautical, astronomical);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, civil, nautical, astronomical) { 
        obj['civil'] = civil;
        obj['nautical'] = nautical;
        obj['astronomical'] = astronomical;
    }

    /**
     * Constructs a <code>Twilight</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/Twilight} obj Optional instance to populate.
     * @return {module:model/Twilight} The populated <code>Twilight</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new Twilight();

            if (data.hasOwnProperty('civil')) {
                obj['civil'] = TwilightTimes.constructFromObject(data['civil']);
            }
            if (data.hasOwnProperty('nautical')) {
                obj['nautical'] = TwilightTimes.constructFromObject(data['nautical']);
            }
            if (data.hasOwnProperty('astronomical')) {
                obj['astronomical'] = TwilightTimes.constructFromObject(data['astronomical']);
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>Twilight</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>Twilight</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of Twilight.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // validate the optional field `civil`
        if (data['civil']) { // data not null
          TwilightTimes.validateJSON(data['civil']);
        }
        // validate the optional field `nautical`
        if (data['nautical']) { // data not null
          TwilightTimes.validateJSON(data['nautical']);
        }
        // validate the optional field `astronomical`
        if (data['astronomical']) { // data not null
          TwilightTimes.validateJSON(data['astronomical']);
        }

        return true;
    }

/**
     * @return {module:model/TwilightTimes}
     */
    getCivil() {
        return this.civil;
    }

    /**
     * @param {module:model/TwilightTimes} civil
     */
    setCivil(civil) {
        this['civil'] = civil;
    }
/**
     * @return {module:model/TwilightTimes}
     */
    getNautical() {
        return this.nautical;
    }

    /**
     * @param {module:model/TwilightTimes} nautical
     */
    setNautical(nautical) {
        this['nautical'] = nautical;
    }
/**
     * @return {module:model/TwilightTimes}
     */
    getAstronomical() {
        return this.astronomical;
    }

    /**
     * @param {module:model/TwilightTimes} astronomical
     */
    setAstronomical(astronomical) {
        this['astronomical'] = astronomical;
    }

}

Twilight.RequiredProperties = ["civil", "nautical", "astronomical"];

/**
 * @member {module:model/TwilightTimes} civil
 */
Twilight.prototype['civil'] = undefined;

/**
 * @member {module:model/TwilightTimes} nautical
 */
Twilight.prototype['nautical'] = undefined;

/**
 * @member {module:model/TwilightTimes} astronomical
 */
Twilight.prototype['astronomical'] = undefined;






export default Twilight;

