/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The UpdateApiKeyRequest model module.
 * @module model/UpdateApiKeyRequest
 * @version 25.12.4
 */
class UpdateApiKeyRequest {
    /**
     * Constructs a new <code>UpdateApiKeyRequest</code>.
     * @alias module:model/UpdateApiKeyRequest
     */
    constructor() { 
        
        UpdateApiKeyRequest.initialize(this);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj) { 
    }

    /**
     * Constructs a <code>UpdateApiKeyRequest</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/UpdateApiKeyRequest} obj Optional instance to populate.
     * @return {module:model/UpdateApiKeyRequest} The populated <code>UpdateApiKeyRequest</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new UpdateApiKeyRequest();

            if (data.hasOwnProperty('name')) {
                obj['name'] = ApiClient.convertToType(data['name'], 'String');
            }
            if (data.hasOwnProperty('enabled')) {
                obj['enabled'] = ApiClient.convertToType(data['enabled'], 'Boolean');
            }
            if (data.hasOwnProperty('permissions')) {
                obj['permissions'] = ApiClient.convertToType(data['permissions'], ['String']);
            }
            if (data.hasOwnProperty('modules')) {
                obj['modules'] = ApiClient.convertToType(data['modules'], ['String']);
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>UpdateApiKeyRequest</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>UpdateApiKeyRequest</code>.
     */
    static validateJSON(data) {
        // ensure the json data is a string
        if (data['name'] && !(typeof data['name'] === 'string' || data['name'] instanceof String)) {
            throw new Error("Expected the field `name` to be a primitive type in the JSON string but got " + data['name']);
        }
        // ensure the json data is an array
        if (!Array.isArray(data['permissions'])) {
            throw new Error("Expected the field `permissions` to be an array in the JSON data but got " + data['permissions']);
        }
        // ensure the json data is an array
        if (!Array.isArray(data['modules'])) {
            throw new Error("Expected the field `modules` to be an array in the JSON data but got " + data['modules']);
        }

        return true;
    }

/**
     * @return {String}
     */
    getName() {
        return this.name;
    }

    /**
     * @param {String} name
     */
    setName(name) {
        this['name'] = name;
    }
/**
     * @return {Boolean}
     */
    getEnabled() {
        return this.enabled;
    }

    /**
     * @param {Boolean} enabled
     */
    setEnabled(enabled) {
        this['enabled'] = enabled;
    }
/**
     * @return {Array.<String>}
     */
    getPermissions() {
        return this.permissions;
    }

    /**
     * @param {Array.<String>} permissions
     */
    setPermissions(permissions) {
        this['permissions'] = permissions;
    }
/**
     * @return {Array.<String>}
     */
    getModules() {
        return this.modules;
    }

    /**
     * @param {Array.<String>} modules
     */
    setModules(modules) {
        this['modules'] = modules;
    }

}



/**
 * @member {String} name
 */
UpdateApiKeyRequest.prototype['name'] = undefined;

/**
 * @member {Boolean} enabled
 */
UpdateApiKeyRequest.prototype['enabled'] = undefined;

/**
 * @member {Array.<String>} permissions
 */
UpdateApiKeyRequest.prototype['permissions'] = undefined;

/**
 * @member {Array.<String>} modules
 */
UpdateApiKeyRequest.prototype['modules'] = undefined;






export default UpdateApiKeyRequest;

