# AstroAPI

Professional astrology API for natal charts, transits, synastry, and interpretations


## Installation & Usage

### Requirements

PHP 8.1 and later.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/GIT_USER_ID/GIT_REPO_ID.git"
    }
  ],
  "require": {
    "GIT_USER_ID/GIT_REPO_ID": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/AstroAPI/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\APIKeysApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 'id_example'; // string

try {
    $apiInstance->deleteApiKey($id);
} catch (Exception $e) {
    echo 'Exception when calling APIKeysApi->deleteApiKey: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *https://api.astroapi.cloud*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*APIKeysApi* | [**deleteApiKey**](docs/Api/APIKeysApi.md#deleteapikey) | **DELETE** /api/api-keys/{id} | Delete API Key
*APIKeysApi* | [**getApiApiKeys**](docs/Api/APIKeysApi.md#getapiapikeys) | **GET** /api/api-keys | List API Keys
*APIKeysApi* | [**getApiApiKeysAvailableOptions**](docs/Api/APIKeysApi.md#getapiapikeysavailableoptions) | **GET** /api/api-keys/available-options | Available Options
*APIKeysApi* | [**getApiKey**](docs/Api/APIKeysApi.md#getapikey) | **GET** /api/api-keys/{id} | Get API Key
*APIKeysApi* | [**postApiApiKeys**](docs/Api/APIKeysApi.md#postapiapikeys) | **POST** /api/api-keys | Create API Key
*APIKeysApi* | [**updateApiKey**](docs/Api/APIKeysApi.md#updateapikey) | **PATCH** /api/api-keys/{id} | Update API Key
*CalculationsApi* | [**postApiCalcChineseForecast**](docs/Api/CalculationsApi.md#postapicalcchineseforecast) | **POST** /api/calc/chinese-forecast | Chinese Zodiac Forecast
*CalculationsApi* | [**postApiCalcChineseHoroscope**](docs/Api/CalculationsApi.md#postapicalcchinesehoroscope) | **POST** /api/calc/chinese-horoscope | Chinese Zodiac Sign
*CalculationsApi* | [**postApiCalcCompatibility**](docs/Api/CalculationsApi.md#postapicalccompatibility) | **POST** /api/calc/compatibility | Compatibility Analysis
*CalculationsApi* | [**postApiCalcComposite**](docs/Api/CalculationsApi.md#postapicalccomposite) | **POST** /api/calc/composite | Composite Chart
*CalculationsApi* | [**postApiCalcLunarReturn**](docs/Api/CalculationsApi.md#postapicalclunarreturn) | **POST** /api/calc/lunar-return | Lunar Return
*CalculationsApi* | [**postApiCalcMoonSun**](docs/Api/CalculationsApi.md#postapicalcmoonsun) | **POST** /api/calc/moon-sun | Moon &amp; Sun Info
*CalculationsApi* | [**postApiCalcNatal**](docs/Api/CalculationsApi.md#postapicalcnatal) | **POST** /api/calc/natal | Natal Chart
*CalculationsApi* | [**postApiCalcProgressions**](docs/Api/CalculationsApi.md#postapicalcprogressions) | **POST** /api/calc/progressions | Secondary Progressions
*CalculationsApi* | [**postApiCalcSolarReturn**](docs/Api/CalculationsApi.md#postapicalcsolarreturn) | **POST** /api/calc/solar-return | Solar Return
*CalculationsApi* | [**postApiCalcSynastry**](docs/Api/CalculationsApi.md#postapicalcsynastry) | **POST** /api/calc/synastry | Synastry Chart
*CalculationsApi* | [**postApiCalcTransit**](docs/Api/CalculationsApi.md#postapicalctransit) | **POST** /api/calc/transit | Transit Chart
*ChatApi* | [**chat**](docs/Api/ChatApi.md#chat) | **POST** /api/chat/{chatbotId} | Chat with Chatbot
*ChatApi* | [**chatDirect**](docs/Api/ChatApi.md#chatdirect) | **POST** /api/chat/{chatbotId}/direct | Chat with Birth Data
*ChatApi* | [**chatWithProfile**](docs/Api/ChatApi.md#chatwithprofile) | **POST** /api/chat/{chatbotId}/profile/{profileId} | Chat with Profile
*ChatApi* | [**deleteConversation**](docs/Api/ChatApi.md#deleteconversation) | **DELETE** /api/chat/{chatbotId}/conversation/{conversationId} | Delete Conversation
*ChatApi* | [**getConversation**](docs/Api/ChatApi.md#getconversation) | **GET** /api/chat/{chatbotId}/conversation/{conversationId} | Get Conversation
*ChatbotApi* | [**createChatProfile**](docs/Api/ChatbotApi.md#createchatprofile) | **POST** /api/chatbots/{id}/profiles | Create Chat Profile
*ChatbotApi* | [**createChatbot**](docs/Api/ChatbotApi.md#createchatbot) | **POST** /api/chatbots | Create Chatbot
*ChatbotApi* | [**deleteChatProfile**](docs/Api/ChatbotApi.md#deletechatprofile) | **DELETE** /api/chatbots/{id}/profiles/{profileId} | Delete Chat Profile
*ChatbotApi* | [**deleteChatbot**](docs/Api/ChatbotApi.md#deletechatbot) | **DELETE** /api/chatbots/{id} | Delete Chatbot
*ChatbotApi* | [**getChatbot**](docs/Api/ChatbotApi.md#getchatbot) | **GET** /api/chatbots/{id} | Get Chatbot
*ChatbotApi* | [**getChatbotUsage**](docs/Api/ChatbotApi.md#getchatbotusage) | **GET** /api/chatbots/usage | Get Chatbot Usage
*ChatbotApi* | [**listChatProfiles**](docs/Api/ChatbotApi.md#listchatprofiles) | **GET** /api/chatbots/{id}/profiles | List Chat Profiles
*ChatbotApi* | [**listChatbotPlugins**](docs/Api/ChatbotApi.md#listchatbotplugins) | **GET** /api/chatbots/plugins | List Available Plugins
*ChatbotApi* | [**listChatbots**](docs/Api/ChatbotApi.md#listchatbots) | **GET** /api/chatbots | List Chatbots
*ChatbotApi* | [**updateChatbot**](docs/Api/ChatbotApi.md#updatechatbot) | **PATCH** /api/chatbots/{id} | Update Chatbot
*ContentApi* | [**createContent**](docs/Api/ContentApi.md#createcontent) | **POST** /api/content/{horoscopeType}/{contentType} | Create Content
*ContentApi* | [**createContentCustomCopy**](docs/Api/ContentApi.md#createcontentcustomcopy) | **POST** /api/content/{id}/create-custom-copy | Create Custom Copy
*ContentApi* | [**deleteContent**](docs/Api/ContentApi.md#deletecontent) | **DELETE** /api/content/{horoscopeType}/{contentType}/{id} | Delete Content
*ContentApi* | [**deleteContentById**](docs/Api/ContentApi.md#deletecontentbyid) | **DELETE** /api/content/{id} | Delete Content by ID
*ContentApi* | [**getContent**](docs/Api/ContentApi.md#getcontent) | **GET** /api/content/{horoscopeType}/{contentType}/{id} | Get Content
*ContentApi* | [**listContent**](docs/Api/ContentApi.md#listcontent) | **GET** /api/content/{horoscopeType}/{contentType} | List Content
*ContentApi* | [**restoreContent**](docs/Api/ContentApi.md#restorecontent) | **POST** /api/content/{id}/restore | Restore Content
*HoroscopeApi* | [**getDailyHoroscopes**](docs/Api/HoroscopeApi.md#getdailyhoroscopes) | **GET** /api/horoscope/daily/{date} | Get Daily Horoscopes
*HoroscopeApi* | [**getWeeklyHoroscope**](docs/Api/HoroscopeApi.md#getweeklyhoroscope) | **GET** /api/horoscope/weekly/{year}/{week}/{zodiacSign} | Get Weekly Horoscope Report
*HoroscopeApi* | [**getYearlyAscendantHoroscope**](docs/Api/HoroscopeApi.md#getyearlyascendanthoroscope) | **GET** /api/horoscope/yearly-ascendant/{year}/{zodiacSign} | Get Yearly Ascendant Horoscope Report
*HoroscopeApi* | [**getYearlyHoroscope**](docs/Api/HoroscopeApi.md#getyearlyhoroscope) | **GET** /api/horoscope/yearly/{year}/{zodiacSign} | Get Yearly Horoscope Report
*ModulesApi* | [**getApiModules**](docs/Api/ModulesApi.md#getapimodules) | **GET** /api/modules | List Modules
*ModulesApi* | [**getApiModulesCheckModuleId**](docs/Api/ModulesApi.md#getapimodulescheckmoduleid) | **GET** /api/modules/check/{moduleId} | Check Module Access
*ModulesApi* | [**getApiModulesOrganization**](docs/Api/ModulesApi.md#getapimodulesorganization) | **GET** /api/modules/organization | Organization Modules
*ModulesApi* | [**getApiModulesPlans**](docs/Api/ModulesApi.md#getapimodulesplans) | **GET** /api/modules/plans | Subscription Plans
*NumerologyApi* | [**postApiNumerologyBirthday**](docs/Api/NumerologyApi.md#postapinumerologybirthday) | **POST** /api/numerology/birthday | Birthday Number
*NumerologyApi* | [**postApiNumerologyCompatibility**](docs/Api/NumerologyApi.md#postapinumerologycompatibility) | **POST** /api/numerology/compatibility | Numerology Compatibility
*NumerologyApi* | [**postApiNumerologyExpression**](docs/Api/NumerologyApi.md#postapinumerologyexpression) | **POST** /api/numerology/expression | Expression Number
*NumerologyApi* | [**postApiNumerologyLifePath**](docs/Api/NumerologyApi.md#postapinumerologylifepath) | **POST** /api/numerology/life-path | Life Path Number
*NumerologyApi* | [**postApiNumerologyPersonalCycles**](docs/Api/NumerologyApi.md#postapinumerologypersonalcycles) | **POST** /api/numerology/personal-cycles | Personal Cycles
*NumerologyApi* | [**postApiNumerologyPersonality**](docs/Api/NumerologyApi.md#postapinumerologypersonality) | **POST** /api/numerology/personality | Personality Number
*NumerologyApi* | [**postApiNumerologyProfile**](docs/Api/NumerologyApi.md#postapinumerologyprofile) | **POST** /api/numerology/profile | Full Numerology Profile
*NumerologyApi* | [**postApiNumerologySoulUrge**](docs/Api/NumerologyApi.md#postapinumerologysoulurge) | **POST** /api/numerology/soul-urge | Soul Urge Number
*OrganizationsApi* | [**deleteApiOrgUsersMemberId**](docs/Api/OrganizationsApi.md#deleteapiorgusersmemberid) | **DELETE** /api/org/users/{memberId} | Remove Member
*OrganizationsApi* | [**getApiOrgUsers**](docs/Api/OrganizationsApi.md#getapiorgusers) | **GET** /api/org/users | List Members
*OrganizationsApi* | [**patchApiOrgUsersMemberId**](docs/Api/OrganizationsApi.md#patchapiorgusersmemberid) | **PATCH** /api/org/users/{memberId} | Update Member
*OrganizationsApi* | [**postApiOrg**](docs/Api/OrganizationsApi.md#postapiorg) | **POST** /api/org | Create Organization
*OrganizationsApi* | [**postApiOrgUsers**](docs/Api/OrganizationsApi.md#postapiorgusers) | **POST** /api/org/users | Add Member
*WidgetApi* | [**getWidgetConfig**](docs/Api/WidgetApi.md#getwidgetconfig) | **GET** /widget/config/{chatbotId} | Get Widget Configuration
*WidgetApi* | [**widgetChat**](docs/Api/WidgetApi.md#widgetchat) | **POST** /widget/chat/{chatbotId} | Widget Chat
*WidgetApi* | [**widgetChatWithUser**](docs/Api/WidgetApi.md#widgetchatwithuser) | **POST** /widget/chat/{chatbotId}/user/{externalUserId} | Widget Chat with User Profile

## Models

- [ApiKey](docs/Model/ApiKey.md)
- [ApiKey1](docs/Model/ApiKey1.md)
- [ApiKeyCreated](docs/Model/ApiKeyCreated.md)
- [ApiKeyModule](docs/Model/ApiKeyModule.md)
- [ApiKeyOptions](docs/Model/ApiKeyOptions.md)
- [Aspect](docs/Model/Aspect.md)
- [Aspect1](docs/Model/Aspect1.md)
- [CelestialPoint](docs/Model/CelestialPoint.md)
- [CelestialPoint1](docs/Model/CelestialPoint1.md)
- [Chart](docs/Model/Chart.md)
- [ChartEntry](docs/Model/ChartEntry.md)
- [ChartEntry1](docs/Model/ChartEntry1.md)
- [ChatDirectRequest](docs/Model/ChatDirectRequest.md)
- [ChatDirectRequestBirthData](docs/Model/ChatDirectRequestBirthData.md)
- [ChatRequest](docs/Model/ChatRequest.md)
- [ChineseForecastData](docs/Model/ChineseForecastData.md)
- [ChineseForecastRequest](docs/Model/ChineseForecastRequest.md)
- [ChineseForecastResponse](docs/Model/ChineseForecastResponse.md)
- [ChineseHoroscopeData](docs/Model/ChineseHoroscopeData.md)
- [ChineseHoroscopeRequest](docs/Model/ChineseHoroscopeRequest.md)
- [ChineseHoroscopeResponse](docs/Model/ChineseHoroscopeResponse.md)
- [CompatibilityData](docs/Model/CompatibilityData.md)
- [CompatibilityRequest](docs/Model/CompatibilityRequest.md)
- [CompatibilityResponse](docs/Model/CompatibilityResponse.md)
- [CompositeData](docs/Model/CompositeData.md)
- [CompositeRequest](docs/Model/CompositeRequest.md)
- [CompositeResponse](docs/Model/CompositeResponse.md)
- [Content](docs/Model/Content.md)
- [ContentAttributes](docs/Model/ContentAttributes.md)
- [ContentLinks](docs/Model/ContentLinks.md)
- [ContentResponse](docs/Model/ContentResponse.md)
- [CreateApiKeyRequest](docs/Model/CreateApiKeyRequest.md)
- [CreateChatProfileRequest](docs/Model/CreateChatProfileRequest.md)
- [CreateChatProfileRequestData](docs/Model/CreateChatProfileRequestData.md)
- [CreateChatProfileRequestDataAttributes](docs/Model/CreateChatProfileRequestDataAttributes.md)
- [CreateChatbotRequest](docs/Model/CreateChatbotRequest.md)
- [CreateChatbotRequestData](docs/Model/CreateChatbotRequestData.md)
- [CreateChatbotRequestDataAttributes](docs/Model/CreateChatbotRequestDataAttributes.md)
- [DailyHoroscopeAttributes](docs/Model/DailyHoroscopeAttributes.md)
- [DailyHoroscopeItem](docs/Model/DailyHoroscopeItem.md)
- [DailyHoroscopeResponse](docs/Model/DailyHoroscopeResponse.md)
- [DailyHoroscopeResponseData](docs/Model/DailyHoroscopeResponseData.md)
- [GetApiApiKeys200Response](docs/Model/GetApiApiKeys200Response.md)
- [GetApiKey200Response](docs/Model/GetApiKey200Response.md)
- [GetApiModules200Response](docs/Model/GetApiModules200Response.md)
- [GetApiModulesOrganization200Response](docs/Model/GetApiModulesOrganization200Response.md)
- [GetApiModulesPlans200Response](docs/Model/GetApiModulesPlans200Response.md)
- [GetApiOrgUsers200Response](docs/Model/GetApiOrgUsers200Response.md)
- [GetApiOrgUsers200ResponseDataInner](docs/Model/GetApiOrgUsers200ResponseDataInner.md)
- [GetApiOrgUsers200ResponseDataInnerAttributes](docs/Model/GetApiOrgUsers200ResponseDataInnerAttributes.md)
- [GetApiOrgUsers200ResponseLinks](docs/Model/GetApiOrgUsers200ResponseLinks.md)
- [GetApiOrgUsers200ResponseMeta](docs/Model/GetApiOrgUsers200ResponseMeta.md)
- [HoroscopeReportAttributes](docs/Model/HoroscopeReportAttributes.md)
- [HoroscopeReportResponse](docs/Model/HoroscopeReportResponse.md)
- [HoroscopeReportResponseData](docs/Model/HoroscopeReportResponseData.md)
- [Houses](docs/Model/Houses.md)
- [Location](docs/Model/Location.md)
- [LunarReturnData](docs/Model/LunarReturnData.md)
- [LunarReturnRequest](docs/Model/LunarReturnRequest.md)
- [LunarReturnResponse](docs/Model/LunarReturnResponse.md)
- [Module](docs/Model/Module.md)
- [ModuleAccessCheck](docs/Model/ModuleAccessCheck.md)
- [MoonInfo](docs/Model/MoonInfo.md)
- [MoonSunData](docs/Model/MoonSunData.md)
- [MoonSunRequest](docs/Model/MoonSunRequest.md)
- [MoonSunResponse](docs/Model/MoonSunResponse.md)
- [NatalData](docs/Model/NatalData.md)
- [NatalRequest](docs/Model/NatalRequest.md)
- [NatalResponse](docs/Model/NatalResponse.md)
- [NumerologyBirthdayRequest](docs/Model/NumerologyBirthdayRequest.md)
- [NumerologyBirthdayResponse](docs/Model/NumerologyBirthdayResponse.md)
- [NumerologyCompatibility](docs/Model/NumerologyCompatibility.md)
- [NumerologyCompatibilityRequest](docs/Model/NumerologyCompatibilityRequest.md)
- [NumerologyCompatibilityResponse](docs/Model/NumerologyCompatibilityResponse.md)
- [NumerologyExpressionRequest](docs/Model/NumerologyExpressionRequest.md)
- [NumerologyExpressionResponse](docs/Model/NumerologyExpressionResponse.md)
- [NumerologyLifePathRequest](docs/Model/NumerologyLifePathRequest.md)
- [NumerologyLifePathResponse](docs/Model/NumerologyLifePathResponse.md)
- [NumerologyNumber](docs/Model/NumerologyNumber.md)
- [NumerologyNumber1](docs/Model/NumerologyNumber1.md)
- [NumerologyPersonalCycles](docs/Model/NumerologyPersonalCycles.md)
- [NumerologyPersonalCyclesRequest](docs/Model/NumerologyPersonalCyclesRequest.md)
- [NumerologyPersonalCyclesResponse](docs/Model/NumerologyPersonalCyclesResponse.md)
- [NumerologyPersonalityRequest](docs/Model/NumerologyPersonalityRequest.md)
- [NumerologyPersonalityResponse](docs/Model/NumerologyPersonalityResponse.md)
- [NumerologyProfile](docs/Model/NumerologyProfile.md)
- [NumerologyProfileRequest](docs/Model/NumerologyProfileRequest.md)
- [NumerologyProfileResponse](docs/Model/NumerologyProfileResponse.md)
- [NumerologySoulUrgeRequest](docs/Model/NumerologySoulUrgeRequest.md)
- [NumerologySoulUrgeResponse](docs/Model/NumerologySoulUrgeResponse.md)
- [PatchApiOrgUsersMemberId200Response](docs/Model/PatchApiOrgUsersMemberId200Response.md)
- [PatchApiOrgUsersMemberId200ResponseData](docs/Model/PatchApiOrgUsersMemberId200ResponseData.md)
- [PatchApiOrgUsersMemberIdRequest](docs/Model/PatchApiOrgUsersMemberIdRequest.md)
- [Permission](docs/Model/Permission.md)
- [PostApiApiKeys201Response](docs/Model/PostApiApiKeys201Response.md)
- [PostApiOrgUsers201Response](docs/Model/PostApiOrgUsers201Response.md)
- [PostApiOrgUsers201ResponseData](docs/Model/PostApiOrgUsers201ResponseData.md)
- [PostApiOrgUsersRequest](docs/Model/PostApiOrgUsersRequest.md)
- [ProgressionsData](docs/Model/ProgressionsData.md)
- [ProgressionsRequest](docs/Model/ProgressionsRequest.md)
- [ProgressionsResponse](docs/Model/ProgressionsResponse.md)
- [ReportPeriod](docs/Model/ReportPeriod.md)
- [SolarReturnData](docs/Model/SolarReturnData.md)
- [SolarReturnRequest](docs/Model/SolarReturnRequest.md)
- [SolarReturnResponse](docs/Model/SolarReturnResponse.md)
- [SubscriptionPlan](docs/Model/SubscriptionPlan.md)
- [SunInfo](docs/Model/SunInfo.md)
- [SynastryData](docs/Model/SynastryData.md)
- [SynastryRequest](docs/Model/SynastryRequest.md)
- [SynastryResponse](docs/Model/SynastryResponse.md)
- [TransitData](docs/Model/TransitData.md)
- [TransitRequest](docs/Model/TransitRequest.md)
- [TransitResponse](docs/Model/TransitResponse.md)
- [Twilight](docs/Model/Twilight.md)
- [TwilightTimes](docs/Model/TwilightTimes.md)
- [UpdateApiKeyRequest](docs/Model/UpdateApiKeyRequest.md)
- [UpdateChatbotRequest](docs/Model/UpdateChatbotRequest.md)
- [UpdateChatbotRequestData](docs/Model/UpdateChatbotRequestData.md)
- [UpdateChatbotRequestDataAttributes](docs/Model/UpdateChatbotRequestDataAttributes.md)
- [WidgetChatRequest](docs/Model/WidgetChatRequest.md)
- [WidgetChatRequestBirthData](docs/Model/WidgetChatRequestBirthData.md)
- [WidgetChatWithUserRequest](docs/Model/WidgetChatWithUserRequest.md)

## Authorization

Authentication schemes defined for the API:
### ApiKeyAuth

- **Type**: API key
- **API key parameter name**: X-Api-Key
- **Location**: HTTP header


## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author



## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: `25.12.4`
    - Generator version: `7.17.0`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
