# AstroAPI\CalculationsApi

Astrological calculations including natal charts, transits, synastry, and more

All URIs are relative to https://api.astroapi.cloud, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**postApiCalcChineseForecast()**](CalculationsApi.md#postApiCalcChineseForecast) | **POST** /api/calc/chinese-forecast | Chinese Zodiac Forecast |
| [**postApiCalcChineseHoroscope()**](CalculationsApi.md#postApiCalcChineseHoroscope) | **POST** /api/calc/chinese-horoscope | Chinese Zodiac Sign |
| [**postApiCalcCompatibility()**](CalculationsApi.md#postApiCalcCompatibility) | **POST** /api/calc/compatibility | Compatibility Analysis |
| [**postApiCalcComposite()**](CalculationsApi.md#postApiCalcComposite) | **POST** /api/calc/composite | Composite Chart |
| [**postApiCalcLunarReturn()**](CalculationsApi.md#postApiCalcLunarReturn) | **POST** /api/calc/lunar-return | Lunar Return |
| [**postApiCalcMoonSun()**](CalculationsApi.md#postApiCalcMoonSun) | **POST** /api/calc/moon-sun | Moon &amp; Sun Info |
| [**postApiCalcNatal()**](CalculationsApi.md#postApiCalcNatal) | **POST** /api/calc/natal | Natal Chart |
| [**postApiCalcProgressions()**](CalculationsApi.md#postApiCalcProgressions) | **POST** /api/calc/progressions | Secondary Progressions |
| [**postApiCalcSolarReturn()**](CalculationsApi.md#postApiCalcSolarReturn) | **POST** /api/calc/solar-return | Solar Return |
| [**postApiCalcSynastry()**](CalculationsApi.md#postApiCalcSynastry) | **POST** /api/calc/synastry | Synastry Chart |
| [**postApiCalcTransit()**](CalculationsApi.md#postApiCalcTransit) | **POST** /api/calc/transit | Transit Chart |


## `postApiCalcChineseForecast()`

```php
postApiCalcChineseForecast($chinese_forecast_request): \AstroAPI\Model\ChineseForecastResponse
```

Chinese Zodiac Forecast

Get Chinese zodiac forecast for a specific year with category breakdowns.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\CalculationsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$chinese_forecast_request = new \AstroAPI\Model\ChineseForecastRequest(); // \AstroAPI\Model\ChineseForecastRequest

try {
    $result = $apiInstance->postApiCalcChineseForecast($chinese_forecast_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CalculationsApi->postApiCalcChineseForecast: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **chinese_forecast_request** | [**\AstroAPI\Model\ChineseForecastRequest**](../Model/ChineseForecastRequest.md)|  | [optional] |

### Return type

[**\AstroAPI\Model\ChineseForecastResponse**](../Model/ChineseForecastResponse.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postApiCalcChineseHoroscope()`

```php
postApiCalcChineseHoroscope($chinese_horoscope_request): \AstroAPI\Model\ChineseHoroscopeResponse
```

Chinese Zodiac Sign

Calculate the Chinese zodiac sign and element based on birth year.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\CalculationsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$chinese_horoscope_request = new \AstroAPI\Model\ChineseHoroscopeRequest(); // \AstroAPI\Model\ChineseHoroscopeRequest

try {
    $result = $apiInstance->postApiCalcChineseHoroscope($chinese_horoscope_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CalculationsApi->postApiCalcChineseHoroscope: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **chinese_horoscope_request** | [**\AstroAPI\Model\ChineseHoroscopeRequest**](../Model/ChineseHoroscopeRequest.md)|  | [optional] |

### Return type

[**\AstroAPI\Model\ChineseHoroscopeResponse**](../Model/ChineseHoroscopeResponse.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postApiCalcCompatibility()`

```php
postApiCalcCompatibility($compatibility_request): \AstroAPI\Model\CompatibilityResponse
```

Compatibility Analysis

Calculate sun sign compatibility between two people with interpretation text.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\CalculationsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$compatibility_request = new \AstroAPI\Model\CompatibilityRequest(); // \AstroAPI\Model\CompatibilityRequest

try {
    $result = $apiInstance->postApiCalcCompatibility($compatibility_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CalculationsApi->postApiCalcCompatibility: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **compatibility_request** | [**\AstroAPI\Model\CompatibilityRequest**](../Model/CompatibilityRequest.md)|  | [optional] |

### Return type

[**\AstroAPI\Model\CompatibilityResponse**](../Model/CompatibilityResponse.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postApiCalcComposite()`

```php
postApiCalcComposite($composite_request): \AstroAPI\Model\CompositeResponse
```

Composite Chart

Calculate a composite chart by combining midpoints of two birth charts.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\CalculationsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$composite_request = new \AstroAPI\Model\CompositeRequest(); // \AstroAPI\Model\CompositeRequest

try {
    $result = $apiInstance->postApiCalcComposite($composite_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CalculationsApi->postApiCalcComposite: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **composite_request** | [**\AstroAPI\Model\CompositeRequest**](../Model/CompositeRequest.md)|  | [optional] |

### Return type

[**\AstroAPI\Model\CompositeResponse**](../Model/CompositeResponse.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postApiCalcLunarReturn()`

```php
postApiCalcLunarReturn($lunar_return_request): \AstroAPI\Model\LunarReturnResponse
```

Lunar Return

Calculate the lunar return chart when the Moon returns to its natal position.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\CalculationsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$lunar_return_request = new \AstroAPI\Model\LunarReturnRequest(); // \AstroAPI\Model\LunarReturnRequest

try {
    $result = $apiInstance->postApiCalcLunarReturn($lunar_return_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CalculationsApi->postApiCalcLunarReturn: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **lunar_return_request** | [**\AstroAPI\Model\LunarReturnRequest**](../Model/LunarReturnRequest.md)|  | [optional] |

### Return type

[**\AstroAPI\Model\LunarReturnResponse**](../Model/LunarReturnResponse.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postApiCalcMoonSun()`

```php
postApiCalcMoonSun($moon_sun_request): \AstroAPI\Model\MoonSunResponse
```

Moon & Sun Info

Get Moon and Sun information for a specific place and time. Includes moon phase, illumination, distance, and sun rise/set/twilight times.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\CalculationsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$moon_sun_request = new \AstroAPI\Model\MoonSunRequest(); // \AstroAPI\Model\MoonSunRequest

try {
    $result = $apiInstance->postApiCalcMoonSun($moon_sun_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CalculationsApi->postApiCalcMoonSun: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **moon_sun_request** | [**\AstroAPI\Model\MoonSunRequest**](../Model/MoonSunRequest.md)|  | [optional] |

### Return type

[**\AstroAPI\Model\MoonSunResponse**](../Model/MoonSunResponse.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postApiCalcNatal()`

```php
postApiCalcNatal($natal_request): \AstroAPI\Model\NatalResponse
```

Natal Chart

Calculate a natal (birth) chart with planetary positions, house cusps, and aspects.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\CalculationsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$natal_request = new \AstroAPI\Model\NatalRequest(); // \AstroAPI\Model\NatalRequest

try {
    $result = $apiInstance->postApiCalcNatal($natal_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CalculationsApi->postApiCalcNatal: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **natal_request** | [**\AstroAPI\Model\NatalRequest**](../Model/NatalRequest.md)|  | [optional] |

### Return type

[**\AstroAPI\Model\NatalResponse**](../Model/NatalResponse.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postApiCalcProgressions()`

```php
postApiCalcProgressions($progressions_request): \AstroAPI\Model\ProgressionsResponse
```

Secondary Progressions

Calculate secondary progressions chart using the day-for-a-year method. Returns progressed planet positions and aspects to both progressed and natal planets.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\CalculationsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$progressions_request = new \AstroAPI\Model\ProgressionsRequest(); // \AstroAPI\Model\ProgressionsRequest

try {
    $result = $apiInstance->postApiCalcProgressions($progressions_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CalculationsApi->postApiCalcProgressions: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **progressions_request** | [**\AstroAPI\Model\ProgressionsRequest**](../Model/ProgressionsRequest.md)|  | [optional] |

### Return type

[**\AstroAPI\Model\ProgressionsResponse**](../Model/ProgressionsResponse.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postApiCalcSolarReturn()`

```php
postApiCalcSolarReturn($solar_return_request): \AstroAPI\Model\SolarReturnResponse
```

Solar Return

Calculate the solar return chart for a specific year (birthday chart).

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\CalculationsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$solar_return_request = new \AstroAPI\Model\SolarReturnRequest(); // \AstroAPI\Model\SolarReturnRequest

try {
    $result = $apiInstance->postApiCalcSolarReturn($solar_return_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CalculationsApi->postApiCalcSolarReturn: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **solar_return_request** | [**\AstroAPI\Model\SolarReturnRequest**](../Model/SolarReturnRequest.md)|  | [optional] |

### Return type

[**\AstroAPI\Model\SolarReturnResponse**](../Model/SolarReturnResponse.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postApiCalcSynastry()`

```php
postApiCalcSynastry($synastry_request): \AstroAPI\Model\SynastryResponse
```

Synastry Chart

Calculate synastry aspects between two birth charts for relationship analysis.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\CalculationsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$synastry_request = new \AstroAPI\Model\SynastryRequest(); // \AstroAPI\Model\SynastryRequest

try {
    $result = $apiInstance->postApiCalcSynastry($synastry_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CalculationsApi->postApiCalcSynastry: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **synastry_request** | [**\AstroAPI\Model\SynastryRequest**](../Model/SynastryRequest.md)|  | [optional] |

### Return type

[**\AstroAPI\Model\SynastryResponse**](../Model/SynastryResponse.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postApiCalcTransit()`

```php
postApiCalcTransit($transit_request): \AstroAPI\Model\TransitResponse
```

Transit Chart

Calculate planetary transits over a natal chart for a specified time period.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\CalculationsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$transit_request = new \AstroAPI\Model\TransitRequest(); // \AstroAPI\Model\TransitRequest

try {
    $result = $apiInstance->postApiCalcTransit($transit_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CalculationsApi->postApiCalcTransit: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **transit_request** | [**\AstroAPI\Model\TransitRequest**](../Model/TransitRequest.md)|  | [optional] |

### Return type

[**\AstroAPI\Model\TransitResponse**](../Model/TransitResponse.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
