# AstroAPI\ChatApi



All URIs are relative to https://api.astroapi.cloud, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**chat()**](ChatApi.md#chat) | **POST** /api/chat/{chatbotId} | Chat with Chatbot |
| [**chatDirect()**](ChatApi.md#chatDirect) | **POST** /api/chat/{chatbotId}/direct | Chat with Birth Data |
| [**chatWithProfile()**](ChatApi.md#chatWithProfile) | **POST** /api/chat/{chatbotId}/profile/{profileId} | Chat with Profile |
| [**deleteConversation()**](ChatApi.md#deleteConversation) | **DELETE** /api/chat/{chatbotId}/conversation/{conversationId} | Delete Conversation |
| [**getConversation()**](ChatApi.md#getConversation) | **GET** /api/chat/{chatbotId}/conversation/{conversationId} | Get Conversation |


## `chat()`

```php
chat($chatbot_id, $chat_request): mixed
```

Chat with Chatbot

Send a message to a chatbot and receive a streaming response via SSE

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\ChatApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$chatbot_id = 'chatbot_id_example'; // string
$chat_request = new \AstroAPI\Model\ChatRequest(); // \AstroAPI\Model\ChatRequest

try {
    $result = $apiInstance->chat($chatbot_id, $chat_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ChatApi->chat: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **chatbot_id** | **string**|  | |
| **chat_request** | [**\AstroAPI\Model\ChatRequest**](../Model/ChatRequest.md)|  | [optional] |

### Return type

**mixed**

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `text/event-stream`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `chatDirect()`

```php
chatDirect($chatbot_id, $chat_direct_request): mixed
```

Chat with Birth Data

Send a message with inline birth data (no profile needed)

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\ChatApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$chatbot_id = 'chatbot_id_example'; // string
$chat_direct_request = new \AstroAPI\Model\ChatDirectRequest(); // \AstroAPI\Model\ChatDirectRequest

try {
    $result = $apiInstance->chatDirect($chatbot_id, $chat_direct_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ChatApi->chatDirect: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **chatbot_id** | **string**|  | |
| **chat_direct_request** | [**\AstroAPI\Model\ChatDirectRequest**](../Model/ChatDirectRequest.md)|  | [optional] |

### Return type

**mixed**

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `text/event-stream`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `chatWithProfile()`

```php
chatWithProfile($chatbot_id, $profile_id, $chat_request): mixed
```

Chat with Profile

Send a message using a pre-configured user profile

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\ChatApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$chatbot_id = 'chatbot_id_example'; // string
$profile_id = 'profile_id_example'; // string
$chat_request = new \AstroAPI\Model\ChatRequest(); // \AstroAPI\Model\ChatRequest

try {
    $result = $apiInstance->chatWithProfile($chatbot_id, $profile_id, $chat_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ChatApi->chatWithProfile: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **chatbot_id** | **string**|  | |
| **profile_id** | **string**|  | |
| **chat_request** | [**\AstroAPI\Model\ChatRequest**](../Model/ChatRequest.md)|  | [optional] |

### Return type

**mixed**

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `text/event-stream`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteConversation()`

```php
deleteConversation($chatbot_id, $conversation_id)
```

Delete Conversation

Delete a conversation and its history

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\ChatApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$chatbot_id = 'chatbot_id_example'; // string
$conversation_id = 'conversation_id_example'; // string

try {
    $apiInstance->deleteConversation($chatbot_id, $conversation_id);
} catch (Exception $e) {
    echo 'Exception when calling ChatApi->deleteConversation: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **chatbot_id** | **string**|  | |
| **conversation_id** | **string**|  | |

### Return type

void (empty response body)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getConversation()`

```php
getConversation($chatbot_id, $conversation_id)
```

Get Conversation

Retrieve conversation history

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\ChatApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$chatbot_id = 'chatbot_id_example'; // string
$conversation_id = 'conversation_id_example'; // string

try {
    $apiInstance->getConversation($chatbot_id, $conversation_id);
} catch (Exception $e) {
    echo 'Exception when calling ChatApi->getConversation: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **chatbot_id** | **string**|  | |
| **conversation_id** | **string**|  | |

### Return type

void (empty response body)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
