# AstroAPI\ContentApi

Content management and interpretation texts

All URIs are relative to https://api.astroapi.cloud, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**createContent()**](ContentApi.md#createContent) | **POST** /api/content/{horoscopeType}/{contentType} | Create Content |
| [**createContentCustomCopy()**](ContentApi.md#createContentCustomCopy) | **POST** /api/content/{id}/create-custom-copy | Create Custom Copy |
| [**deleteContent()**](ContentApi.md#deleteContent) | **DELETE** /api/content/{horoscopeType}/{contentType}/{id} | Delete Content |
| [**deleteContentById()**](ContentApi.md#deleteContentById) | **DELETE** /api/content/{id} | Delete Content by ID |
| [**getContent()**](ContentApi.md#getContent) | **GET** /api/content/{horoscopeType}/{contentType}/{id} | Get Content |
| [**listContent()**](ContentApi.md#listContent) | **GET** /api/content/{horoscopeType}/{contentType} | List Content |
| [**restoreContent()**](ContentApi.md#restoreContent) | **POST** /api/content/{id}/restore | Restore Content |


## `createContent()`

```php
createContent($horoscope_type, $content_type): \AstroAPI\Model\ContentResponse
```

Create Content

Create a new content item for a specific horoscope and content type.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\ContentApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$horoscope_type = 'horoscope_type_example'; // string
$content_type = 'content_type_example'; // string

try {
    $result = $apiInstance->createContent($horoscope_type, $content_type);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentApi->createContent: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **horoscope_type** | **string**|  | |
| **content_type** | **string**|  | |

### Return type

[**\AstroAPI\Model\ContentResponse**](../Model/ContentResponse.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/vnd.api+json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createContentCustomCopy()`

```php
createContentCustomCopy($id): \AstroAPI\Model\ContentResponse
```

Create Custom Copy

Create an organization-specific copy of system content for customization.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\ContentApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 'id_example'; // string

try {
    $result = $apiInstance->createContentCustomCopy($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentApi->createContentCustomCopy: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**|  | |

### Return type

[**\AstroAPI\Model\ContentResponse**](../Model/ContentResponse.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/vnd.api+json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteContent()`

```php
deleteContent($id, $horoscope_type, $content_type)
```

Delete Content

Delete a content item by horoscope type, content type, and ID.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\ContentApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 'id_example'; // string
$horoscope_type = 'horoscope_type_example'; // string
$content_type = 'content_type_example'; // string

try {
    $apiInstance->deleteContent($id, $horoscope_type, $content_type);
} catch (Exception $e) {
    echo 'Exception when calling ContentApi->deleteContent: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**|  | |
| **horoscope_type** | **string**|  | |
| **content_type** | **string**|  | |

### Return type

void (empty response body)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteContentById()`

```php
deleteContentById($id): \AstroAPI\Model\ContentResponse
```

Delete Content by ID

Delete a content item by its ID.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\ContentApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 'id_example'; // string

try {
    $result = $apiInstance->deleteContentById($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentApi->deleteContentById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**|  | |

### Return type

[**\AstroAPI\Model\ContentResponse**](../Model/ContentResponse.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/vnd.api+json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getContent()`

```php
getContent($id, $horoscope_type, $content_type): \AstroAPI\Model\ContentResponse
```

Get Content

Retrieve a single content item by its ID.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\ContentApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 'id_example'; // string
$horoscope_type = 'horoscope_type_example'; // string
$content_type = 'content_type_example'; // string

try {
    $result = $apiInstance->getContent($id, $horoscope_type, $content_type);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentApi->getContent: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**|  | |
| **horoscope_type** | **string**|  | |
| **content_type** | **string**|  | |

### Return type

[**\AstroAPI\Model\ContentResponse**](../Model/ContentResponse.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/vnd.api+json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `listContent()`

```php
listContent($horoscope_type, $content_type): \AstroAPI\Model\ContentResponse
```

List Content

Retrieve a paginated list of content items filtered by horoscope and content type.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\ContentApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$horoscope_type = 'horoscope_type_example'; // string
$content_type = 'content_type_example'; // string

try {
    $result = $apiInstance->listContent($horoscope_type, $content_type);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentApi->listContent: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **horoscope_type** | **string**|  | |
| **content_type** | **string**|  | |

### Return type

[**\AstroAPI\Model\ContentResponse**](../Model/ContentResponse.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/vnd.api+json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `restoreContent()`

```php
restoreContent($id): \AstroAPI\Model\ContentResponse
```

Restore Content

Restore custom content to match the original system content.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\ContentApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 'id_example'; // string

try {
    $result = $apiInstance->restoreContent($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentApi->restoreContent: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**|  | |

### Return type

[**\AstroAPI\Model\ContentResponse**](../Model/ContentResponse.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/vnd.api+json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
