# AstroAPI\HoroscopeApi



All URIs are relative to https://api.astroapi.cloud, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**getDailyHoroscopes()**](HoroscopeApi.md#getDailyHoroscopes) | **GET** /api/horoscope/daily/{date} | Get Daily Horoscopes |
| [**getWeeklyHoroscope()**](HoroscopeApi.md#getWeeklyHoroscope) | **GET** /api/horoscope/weekly/{year}/{week}/{zodiacSign} | Get Weekly Horoscope Report |
| [**getYearlyAscendantHoroscope()**](HoroscopeApi.md#getYearlyAscendantHoroscope) | **GET** /api/horoscope/yearly-ascendant/{year}/{zodiacSign} | Get Yearly Ascendant Horoscope Report |
| [**getYearlyHoroscope()**](HoroscopeApi.md#getYearlyHoroscope) | **GET** /api/horoscope/yearly/{year}/{zodiacSign} | Get Yearly Horoscope Report |


## `getDailyHoroscopes()`

```php
getDailyHoroscopes($date): \AstroAPI\Model\DailyHoroscopeResponse
```

Get Daily Horoscopes

Retrieve daily horoscopes for all zodiac signs for a specific date.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\HoroscopeApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$date = 'date_example'; // string

try {
    $result = $apiInstance->getDailyHoroscopes($date);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling HoroscopeApi->getDailyHoroscopes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **date** | **string**|  | |

### Return type

[**\AstroAPI\Model\DailyHoroscopeResponse**](../Model/DailyHoroscopeResponse.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/vnd.api+json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getWeeklyHoroscope()`

```php
getWeeklyHoroscope($year, $week, $zodiac_sign): \AstroAPI\Model\HoroscopeReportResponse
```

Get Weekly Horoscope Report

Retrieve weekly horoscope report for a specific zodiac sign and week.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\HoroscopeApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$year = 'year_example'; // string
$week = 'week_example'; // string
$zodiac_sign = 'zodiac_sign_example'; // string

try {
    $result = $apiInstance->getWeeklyHoroscope($year, $week, $zodiac_sign);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling HoroscopeApi->getWeeklyHoroscope: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **year** | **string**|  | |
| **week** | **string**|  | |
| **zodiac_sign** | **string**|  | |

### Return type

[**\AstroAPI\Model\HoroscopeReportResponse**](../Model/HoroscopeReportResponse.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/vnd.api+json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getYearlyAscendantHoroscope()`

```php
getYearlyAscendantHoroscope($year, $zodiac_sign): \AstroAPI\Model\HoroscopeReportResponse
```

Get Yearly Ascendant Horoscope Report

Retrieve yearly horoscope report for a specific ascendant sign and year.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\HoroscopeApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$year = 'year_example'; // string
$zodiac_sign = 'zodiac_sign_example'; // string

try {
    $result = $apiInstance->getYearlyAscendantHoroscope($year, $zodiac_sign);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling HoroscopeApi->getYearlyAscendantHoroscope: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **year** | **string**|  | |
| **zodiac_sign** | **string**|  | |

### Return type

[**\AstroAPI\Model\HoroscopeReportResponse**](../Model/HoroscopeReportResponse.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/vnd.api+json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getYearlyHoroscope()`

```php
getYearlyHoroscope($year, $zodiac_sign): \AstroAPI\Model\HoroscopeReportResponse
```

Get Yearly Horoscope Report

Retrieve yearly horoscope report for a specific zodiac sign and year.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\HoroscopeApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$year = 'year_example'; // string
$zodiac_sign = 'zodiac_sign_example'; // string

try {
    $result = $apiInstance->getYearlyHoroscope($year, $zodiac_sign);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling HoroscopeApi->getYearlyHoroscope: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **year** | **string**|  | |
| **zodiac_sign** | **string**|  | |

### Return type

[**\AstroAPI\Model\HoroscopeReportResponse**](../Model/HoroscopeReportResponse.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/vnd.api+json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
