# AstroAPI\ModulesApi

Module access and subscription management

All URIs are relative to https://api.astroapi.cloud, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**getApiModules()**](ModulesApi.md#getApiModules) | **GET** /api/modules | List Modules |
| [**getApiModulesCheckModuleId()**](ModulesApi.md#getApiModulesCheckModuleId) | **GET** /api/modules/check/{moduleId} | Check Module Access |
| [**getApiModulesOrganization()**](ModulesApi.md#getApiModulesOrganization) | **GET** /api/modules/organization | Organization Modules |
| [**getApiModulesPlans()**](ModulesApi.md#getApiModulesPlans) | **GET** /api/modules/plans | Subscription Plans |


## `getApiModules()`

```php
getApiModules(): \AstroAPI\Model\GetApiModules200Response
```

List Modules

Get all available modules with pricing information.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\ModulesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getApiModules();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ModulesApi->getApiModules: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\AstroAPI\Model\GetApiModules200Response**](../Model/GetApiModules200Response.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getApiModulesCheckModuleId()`

```php
getApiModulesCheckModuleId($module_id): \AstroAPI\Model\ModuleAccessCheck
```

Check Module Access

Check if the current organization has access to a specific module.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\ModulesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$module_id = 'module_id_example'; // string

try {
    $result = $apiInstance->getApiModulesCheckModuleId($module_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ModulesApi->getApiModulesCheckModuleId: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **module_id** | **string**|  | |

### Return type

[**\AstroAPI\Model\ModuleAccessCheck**](../Model/ModuleAccessCheck.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getApiModulesOrganization()`

```php
getApiModulesOrganization(): \AstroAPI\Model\GetApiModulesOrganization200Response
```

Organization Modules

Get the list of modules the current organization has access to.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\ModulesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getApiModulesOrganization();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ModulesApi->getApiModulesOrganization: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\AstroAPI\Model\GetApiModulesOrganization200Response**](../Model/GetApiModulesOrganization200Response.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getApiModulesPlans()`

```php
getApiModulesPlans(): \AstroAPI\Model\GetApiModulesPlans200Response
```

Subscription Plans

Get all available subscription plans with included modules and pricing.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\ModulesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getApiModulesPlans();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ModulesApi->getApiModulesPlans: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\AstroAPI\Model\GetApiModulesPlans200Response**](../Model/GetApiModulesPlans200Response.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
