# AstroAPI\NumerologyApi



All URIs are relative to https://api.astroapi.cloud, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**postApiNumerologyBirthday()**](NumerologyApi.md#postApiNumerologyBirthday) | **POST** /api/numerology/birthday | Birthday Number |
| [**postApiNumerologyCompatibility()**](NumerologyApi.md#postApiNumerologyCompatibility) | **POST** /api/numerology/compatibility | Numerology Compatibility |
| [**postApiNumerologyExpression()**](NumerologyApi.md#postApiNumerologyExpression) | **POST** /api/numerology/expression | Expression Number |
| [**postApiNumerologyLifePath()**](NumerologyApi.md#postApiNumerologyLifePath) | **POST** /api/numerology/life-path | Life Path Number |
| [**postApiNumerologyPersonalCycles()**](NumerologyApi.md#postApiNumerologyPersonalCycles) | **POST** /api/numerology/personal-cycles | Personal Cycles |
| [**postApiNumerologyPersonality()**](NumerologyApi.md#postApiNumerologyPersonality) | **POST** /api/numerology/personality | Personality Number |
| [**postApiNumerologyProfile()**](NumerologyApi.md#postApiNumerologyProfile) | **POST** /api/numerology/profile | Full Numerology Profile |
| [**postApiNumerologySoulUrge()**](NumerologyApi.md#postApiNumerologySoulUrge) | **POST** /api/numerology/soul-urge | Soul Urge Number |


## `postApiNumerologyBirthday()`

```php
postApiNumerologyBirthday($numerology_birthday_request): \AstroAPI\Model\NumerologyBirthdayResponse
```

Birthday Number

Calculate the Birthday Number from the day of birth. This number represents a special talent you possess.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\NumerologyApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$numerology_birthday_request = new \AstroAPI\Model\NumerologyBirthdayRequest(); // \AstroAPI\Model\NumerologyBirthdayRequest

try {
    $result = $apiInstance->postApiNumerologyBirthday($numerology_birthday_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling NumerologyApi->postApiNumerologyBirthday: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **numerology_birthday_request** | [**\AstroAPI\Model\NumerologyBirthdayRequest**](../Model/NumerologyBirthdayRequest.md)|  | [optional] |

### Return type

[**\AstroAPI\Model\NumerologyBirthdayResponse**](../Model/NumerologyBirthdayResponse.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postApiNumerologyCompatibility()`

```php
postApiNumerologyCompatibility($numerology_compatibility_request): \AstroAPI\Model\NumerologyCompatibilityResponse
```

Numerology Compatibility

Calculate compatibility between two people based on their Life Path numbers.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\NumerologyApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$numerology_compatibility_request = new \AstroAPI\Model\NumerologyCompatibilityRequest(); // \AstroAPI\Model\NumerologyCompatibilityRequest

try {
    $result = $apiInstance->postApiNumerologyCompatibility($numerology_compatibility_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling NumerologyApi->postApiNumerologyCompatibility: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **numerology_compatibility_request** | [**\AstroAPI\Model\NumerologyCompatibilityRequest**](../Model/NumerologyCompatibilityRequest.md)|  | [optional] |

### Return type

[**\AstroAPI\Model\NumerologyCompatibilityResponse**](../Model/NumerologyCompatibilityResponse.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postApiNumerologyExpression()`

```php
postApiNumerologyExpression($numerology_expression_request): \AstroAPI\Model\NumerologyExpressionResponse
```

Expression Number

Calculate the Expression (Destiny) Number from full name. This number reveals your natural talents and abilities.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\NumerologyApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$numerology_expression_request = new \AstroAPI\Model\NumerologyExpressionRequest(); // \AstroAPI\Model\NumerologyExpressionRequest

try {
    $result = $apiInstance->postApiNumerologyExpression($numerology_expression_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling NumerologyApi->postApiNumerologyExpression: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **numerology_expression_request** | [**\AstroAPI\Model\NumerologyExpressionRequest**](../Model/NumerologyExpressionRequest.md)|  | [optional] |

### Return type

[**\AstroAPI\Model\NumerologyExpressionResponse**](../Model/NumerologyExpressionResponse.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postApiNumerologyLifePath()`

```php
postApiNumerologyLifePath($numerology_life_path_request): \AstroAPI\Model\NumerologyLifePathResponse
```

Life Path Number

Calculate the Life Path Number from birth date. This is the most important number in numerology, representing your life's purpose.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\NumerologyApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$numerology_life_path_request = new \AstroAPI\Model\NumerologyLifePathRequest(); // \AstroAPI\Model\NumerologyLifePathRequest

try {
    $result = $apiInstance->postApiNumerologyLifePath($numerology_life_path_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling NumerologyApi->postApiNumerologyLifePath: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **numerology_life_path_request** | [**\AstroAPI\Model\NumerologyLifePathRequest**](../Model/NumerologyLifePathRequest.md)|  | [optional] |

### Return type

[**\AstroAPI\Model\NumerologyLifePathResponse**](../Model/NumerologyLifePathResponse.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postApiNumerologyPersonalCycles()`

```php
postApiNumerologyPersonalCycles($numerology_personal_cycles_request): \AstroAPI\Model\NumerologyPersonalCyclesResponse
```

Personal Cycles

Calculate Personal Year, Month, and Day numbers. These reveal the current energetic influences in your life.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\NumerologyApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$numerology_personal_cycles_request = new \AstroAPI\Model\NumerologyPersonalCyclesRequest(); // \AstroAPI\Model\NumerologyPersonalCyclesRequest

try {
    $result = $apiInstance->postApiNumerologyPersonalCycles($numerology_personal_cycles_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling NumerologyApi->postApiNumerologyPersonalCycles: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **numerology_personal_cycles_request** | [**\AstroAPI\Model\NumerologyPersonalCyclesRequest**](../Model/NumerologyPersonalCyclesRequest.md)|  | [optional] |

### Return type

[**\AstroAPI\Model\NumerologyPersonalCyclesResponse**](../Model/NumerologyPersonalCyclesResponse.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postApiNumerologyPersonality()`

```php
postApiNumerologyPersonality($numerology_personality_request): \AstroAPI\Model\NumerologyPersonalityResponse
```

Personality Number

Calculate the Personality Number from consonants in the name. This number reveals how others perceive you.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\NumerologyApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$numerology_personality_request = new \AstroAPI\Model\NumerologyPersonalityRequest(); // \AstroAPI\Model\NumerologyPersonalityRequest

try {
    $result = $apiInstance->postApiNumerologyPersonality($numerology_personality_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling NumerologyApi->postApiNumerologyPersonality: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **numerology_personality_request** | [**\AstroAPI\Model\NumerologyPersonalityRequest**](../Model/NumerologyPersonalityRequest.md)|  | [optional] |

### Return type

[**\AstroAPI\Model\NumerologyPersonalityResponse**](../Model/NumerologyPersonalityResponse.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postApiNumerologyProfile()`

```php
postApiNumerologyProfile($numerology_profile_request): \AstroAPI\Model\NumerologyProfileResponse
```

Full Numerology Profile

Calculate a complete numerology profile including Life Path, Expression, Soul Urge, Personality, Birthday numbers, Personal Cycles, and identify Master/Karmic numbers.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\NumerologyApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$numerology_profile_request = new \AstroAPI\Model\NumerologyProfileRequest(); // \AstroAPI\Model\NumerologyProfileRequest

try {
    $result = $apiInstance->postApiNumerologyProfile($numerology_profile_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling NumerologyApi->postApiNumerologyProfile: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **numerology_profile_request** | [**\AstroAPI\Model\NumerologyProfileRequest**](../Model/NumerologyProfileRequest.md)|  | [optional] |

### Return type

[**\AstroAPI\Model\NumerologyProfileResponse**](../Model/NumerologyProfileResponse.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postApiNumerologySoulUrge()`

```php
postApiNumerologySoulUrge($numerology_soul_urge_request): \AstroAPI\Model\NumerologySoulUrgeResponse
```

Soul Urge Number

Calculate the Soul Urge (Heart's Desire) Number from vowels in the name. This number reveals your inner motivations.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\NumerologyApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$numerology_soul_urge_request = new \AstroAPI\Model\NumerologySoulUrgeRequest(); // \AstroAPI\Model\NumerologySoulUrgeRequest

try {
    $result = $apiInstance->postApiNumerologySoulUrge($numerology_soul_urge_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling NumerologyApi->postApiNumerologySoulUrge: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **numerology_soul_urge_request** | [**\AstroAPI\Model\NumerologySoulUrgeRequest**](../Model/NumerologySoulUrgeRequest.md)|  | [optional] |

### Return type

[**\AstroAPI\Model\NumerologySoulUrgeResponse**](../Model/NumerologySoulUrgeResponse.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
