# AstroAPI\OrganizationsApi

Organization and team management

All URIs are relative to https://api.astroapi.cloud, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**deleteApiOrgUsersMemberId()**](OrganizationsApi.md#deleteApiOrgUsersMemberId) | **DELETE** /api/org/users/{memberId} | Remove Member |
| [**getApiOrgUsers()**](OrganizationsApi.md#getApiOrgUsers) | **GET** /api/org/users | List Members |
| [**patchApiOrgUsersMemberId()**](OrganizationsApi.md#patchApiOrgUsersMemberId) | **PATCH** /api/org/users/{memberId} | Update Member |
| [**postApiOrg()**](OrganizationsApi.md#postApiOrg) | **POST** /api/org | Create Organization |
| [**postApiOrgUsers()**](OrganizationsApi.md#postApiOrgUsers) | **POST** /api/org/users | Add Member |


## `deleteApiOrgUsersMemberId()`

```php
deleteApiOrgUsersMemberId($member_id)
```

Remove Member

Remove a member from the organization.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\OrganizationsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$member_id = 'member_id_example'; // string

try {
    $apiInstance->deleteApiOrgUsersMemberId($member_id);
} catch (Exception $e) {
    echo 'Exception when calling OrganizationsApi->deleteApiOrgUsersMemberId: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **member_id** | **string**|  | |

### Return type

void (empty response body)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getApiOrgUsers()`

```php
getApiOrgUsers(): \AstroAPI\Model\GetApiOrgUsers200Response
```

List Members

Get a paginated list of organization members.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\OrganizationsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getApiOrgUsers();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrganizationsApi->getApiOrgUsers: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\AstroAPI\Model\GetApiOrgUsers200Response**](../Model/GetApiOrgUsers200Response.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/vnd.api+json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `patchApiOrgUsersMemberId()`

```php
patchApiOrgUsersMemberId($member_id, $patch_api_org_users_member_id_request): \AstroAPI\Model\PatchApiOrgUsersMemberId200Response
```

Update Member

Update an organization member's role.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\OrganizationsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$member_id = 'member_id_example'; // string
$patch_api_org_users_member_id_request = new \AstroAPI\Model\PatchApiOrgUsersMemberIdRequest(); // \AstroAPI\Model\PatchApiOrgUsersMemberIdRequest

try {
    $result = $apiInstance->patchApiOrgUsersMemberId($member_id, $patch_api_org_users_member_id_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrganizationsApi->patchApiOrgUsersMemberId: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **member_id** | **string**|  | |
| **patch_api_org_users_member_id_request** | [**\AstroAPI\Model\PatchApiOrgUsersMemberIdRequest**](../Model/PatchApiOrgUsersMemberIdRequest.md)|  | [optional] |

### Return type

[**\AstroAPI\Model\PatchApiOrgUsersMemberId200Response**](../Model/PatchApiOrgUsersMemberId200Response.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postApiOrg()`

```php
postApiOrg(): mixed
```

Create Organization

Create a new organization with Stripe billing setup.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\OrganizationsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->postApiOrg();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrganizationsApi->postApiOrg: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

**mixed**

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/vnd.api+json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postApiOrgUsers()`

```php
postApiOrgUsers($post_api_org_users_request): \AstroAPI\Model\PostApiOrgUsers201Response
```

Add Member

Add or invite a new member to the organization.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\OrganizationsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$post_api_org_users_request = new \AstroAPI\Model\PostApiOrgUsersRequest(); // \AstroAPI\Model\PostApiOrgUsersRequest

try {
    $result = $apiInstance->postApiOrgUsers($post_api_org_users_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrganizationsApi->postApiOrgUsers: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **post_api_org_users_request** | [**\AstroAPI\Model\PostApiOrgUsersRequest**](../Model/PostApiOrgUsersRequest.md)|  | [optional] |

### Return type

[**\AstroAPI\Model\PostApiOrgUsers201Response**](../Model/PostApiOrgUsers201Response.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
