# AstroAPI\WidgetApi



All URIs are relative to https://api.astroapi.cloud, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**getWidgetConfig()**](WidgetApi.md#getWidgetConfig) | **GET** /widget/config/{chatbotId} | Get Widget Configuration |
| [**widgetChat()**](WidgetApi.md#widgetChat) | **POST** /widget/chat/{chatbotId} | Widget Chat |
| [**widgetChatWithUser()**](WidgetApi.md#widgetChatWithUser) | **POST** /widget/chat/{chatbotId}/user/{externalUserId} | Widget Chat with User Profile |


## `getWidgetConfig()`

```php
getWidgetConfig($chatbot_id)
```

Get Widget Configuration

Get the widget configuration for embedding

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\WidgetApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$chatbot_id = 'chatbot_id_example'; // string

try {
    $apiInstance->getWidgetConfig($chatbot_id);
} catch (Exception $e) {
    echo 'Exception when calling WidgetApi->getWidgetConfig: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **chatbot_id** | **string**|  | |

### Return type

void (empty response body)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `widgetChat()`

```php
widgetChat($chatbot_id, $widget_chat_request): mixed
```

Widget Chat

Send a message via widget (SSE streaming response)

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\WidgetApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$chatbot_id = 'chatbot_id_example'; // string
$widget_chat_request = new \AstroAPI\Model\WidgetChatRequest(); // \AstroAPI\Model\WidgetChatRequest

try {
    $result = $apiInstance->widgetChat($chatbot_id, $widget_chat_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WidgetApi->widgetChat: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **chatbot_id** | **string**|  | |
| **widget_chat_request** | [**\AstroAPI\Model\WidgetChatRequest**](../Model/WidgetChatRequest.md)|  | [optional] |

### Return type

**mixed**

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `text/event-stream`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `widgetChatWithUser()`

```php
widgetChatWithUser($chatbot_id, $external_user_id, $widget_chat_with_user_request): mixed
```

Widget Chat with User Profile

Chat using an external user ID (creates profile on first use)

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: ApiKeyAuth
$config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKey('X-Api-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = AstroAPI\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Api-Key', 'Bearer');


$apiInstance = new AstroAPI\Api\WidgetApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$chatbot_id = 'chatbot_id_example'; // string
$external_user_id = 'external_user_id_example'; // string
$widget_chat_with_user_request = new \AstroAPI\Model\WidgetChatWithUserRequest(); // \AstroAPI\Model\WidgetChatWithUserRequest

try {
    $result = $apiInstance->widgetChatWithUser($chatbot_id, $external_user_id, $widget_chat_with_user_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WidgetApi->widgetChatWithUser: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **chatbot_id** | **string**|  | |
| **external_user_id** | **string**|  | |
| **widget_chat_with_user_request** | [**\AstroAPI\Model\WidgetChatWithUserRequest**](../Model/WidgetChatWithUserRequest.md)|  | [optional] |

### Return type

**mixed**

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `text/event-stream`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
