<?php
/**
 * CalculationsApi
 * PHP version 8.1
 *
 * @category Class
 * @package  AstroAPI
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * AstroAPI
 *
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.17.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace AstroAPI\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use AstroAPI\ApiException;
use AstroAPI\Configuration;
use AstroAPI\FormDataProcessor;
use AstroAPI\HeaderSelector;
use AstroAPI\ObjectSerializer;

/**
 * CalculationsApi Class Doc Comment
 *
 * @category Class
 * @package  AstroAPI
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class CalculationsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'postApiCalcChineseForecast' => [
            'application/json',
        ],
        'postApiCalcChineseHoroscope' => [
            'application/json',
        ],
        'postApiCalcCompatibility' => [
            'application/json',
        ],
        'postApiCalcComposite' => [
            'application/json',
        ],
        'postApiCalcLunarReturn' => [
            'application/json',
        ],
        'postApiCalcMoonSun' => [
            'application/json',
        ],
        'postApiCalcNatal' => [
            'application/json',
        ],
        'postApiCalcProgressions' => [
            'application/json',
        ],
        'postApiCalcSolarReturn' => [
            'application/json',
        ],
        'postApiCalcSynastry' => [
            'application/json',
        ],
        'postApiCalcTransit' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation postApiCalcChineseForecast
     *
     * Chinese Zodiac Forecast
     *
     * @param  \AstroAPI\Model\ChineseForecastRequest|null $chinese_forecast_request chinese_forecast_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcChineseForecast'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \AstroAPI\Model\ChineseForecastResponse
     */
    public function postApiCalcChineseForecast($chinese_forecast_request = null, string $contentType = self::contentTypes['postApiCalcChineseForecast'][0])
    {
        list($response) = $this->postApiCalcChineseForecastWithHttpInfo($chinese_forecast_request, $contentType);
        return $response;
    }

    /**
     * Operation postApiCalcChineseForecastWithHttpInfo
     *
     * Chinese Zodiac Forecast
     *
     * @param  \AstroAPI\Model\ChineseForecastRequest|null $chinese_forecast_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcChineseForecast'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \AstroAPI\Model\ChineseForecastResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function postApiCalcChineseForecastWithHttpInfo($chinese_forecast_request = null, string $contentType = self::contentTypes['postApiCalcChineseForecast'][0])
    {
        $request = $this->postApiCalcChineseForecastRequest($chinese_forecast_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\AstroAPI\Model\ChineseForecastResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\AstroAPI\Model\ChineseForecastResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\AstroAPI\Model\ChineseForecastResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation postApiCalcChineseForecastAsync
     *
     * Chinese Zodiac Forecast
     *
     * @param  \AstroAPI\Model\ChineseForecastRequest|null $chinese_forecast_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcChineseForecast'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiCalcChineseForecastAsync($chinese_forecast_request = null, string $contentType = self::contentTypes['postApiCalcChineseForecast'][0])
    {
        return $this->postApiCalcChineseForecastAsyncWithHttpInfo($chinese_forecast_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postApiCalcChineseForecastAsyncWithHttpInfo
     *
     * Chinese Zodiac Forecast
     *
     * @param  \AstroAPI\Model\ChineseForecastRequest|null $chinese_forecast_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcChineseForecast'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiCalcChineseForecastAsyncWithHttpInfo($chinese_forecast_request = null, string $contentType = self::contentTypes['postApiCalcChineseForecast'][0])
    {
        $returnType = '\AstroAPI\Model\ChineseForecastResponse';
        $request = $this->postApiCalcChineseForecastRequest($chinese_forecast_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postApiCalcChineseForecast'
     *
     * @param  \AstroAPI\Model\ChineseForecastRequest|null $chinese_forecast_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcChineseForecast'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postApiCalcChineseForecastRequest($chinese_forecast_request = null, string $contentType = self::contentTypes['postApiCalcChineseForecast'][0])
    {



        $resourcePath = '/api/calc/chinese-forecast';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/vnd.api+json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($chinese_forecast_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($chinese_forecast_request));
            } else {
                $httpBody = $chinese_forecast_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Api-Key');
        if ($apiKey !== null) {
            $headers['X-Api-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postApiCalcChineseHoroscope
     *
     * Chinese Zodiac Sign
     *
     * @param  \AstroAPI\Model\ChineseHoroscopeRequest|null $chinese_horoscope_request chinese_horoscope_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcChineseHoroscope'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \AstroAPI\Model\ChineseHoroscopeResponse
     */
    public function postApiCalcChineseHoroscope($chinese_horoscope_request = null, string $contentType = self::contentTypes['postApiCalcChineseHoroscope'][0])
    {
        list($response) = $this->postApiCalcChineseHoroscopeWithHttpInfo($chinese_horoscope_request, $contentType);
        return $response;
    }

    /**
     * Operation postApiCalcChineseHoroscopeWithHttpInfo
     *
     * Chinese Zodiac Sign
     *
     * @param  \AstroAPI\Model\ChineseHoroscopeRequest|null $chinese_horoscope_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcChineseHoroscope'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \AstroAPI\Model\ChineseHoroscopeResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function postApiCalcChineseHoroscopeWithHttpInfo($chinese_horoscope_request = null, string $contentType = self::contentTypes['postApiCalcChineseHoroscope'][0])
    {
        $request = $this->postApiCalcChineseHoroscopeRequest($chinese_horoscope_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\AstroAPI\Model\ChineseHoroscopeResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\AstroAPI\Model\ChineseHoroscopeResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\AstroAPI\Model\ChineseHoroscopeResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation postApiCalcChineseHoroscopeAsync
     *
     * Chinese Zodiac Sign
     *
     * @param  \AstroAPI\Model\ChineseHoroscopeRequest|null $chinese_horoscope_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcChineseHoroscope'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiCalcChineseHoroscopeAsync($chinese_horoscope_request = null, string $contentType = self::contentTypes['postApiCalcChineseHoroscope'][0])
    {
        return $this->postApiCalcChineseHoroscopeAsyncWithHttpInfo($chinese_horoscope_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postApiCalcChineseHoroscopeAsyncWithHttpInfo
     *
     * Chinese Zodiac Sign
     *
     * @param  \AstroAPI\Model\ChineseHoroscopeRequest|null $chinese_horoscope_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcChineseHoroscope'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiCalcChineseHoroscopeAsyncWithHttpInfo($chinese_horoscope_request = null, string $contentType = self::contentTypes['postApiCalcChineseHoroscope'][0])
    {
        $returnType = '\AstroAPI\Model\ChineseHoroscopeResponse';
        $request = $this->postApiCalcChineseHoroscopeRequest($chinese_horoscope_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postApiCalcChineseHoroscope'
     *
     * @param  \AstroAPI\Model\ChineseHoroscopeRequest|null $chinese_horoscope_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcChineseHoroscope'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postApiCalcChineseHoroscopeRequest($chinese_horoscope_request = null, string $contentType = self::contentTypes['postApiCalcChineseHoroscope'][0])
    {



        $resourcePath = '/api/calc/chinese-horoscope';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/vnd.api+json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($chinese_horoscope_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($chinese_horoscope_request));
            } else {
                $httpBody = $chinese_horoscope_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Api-Key');
        if ($apiKey !== null) {
            $headers['X-Api-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postApiCalcCompatibility
     *
     * Compatibility Analysis
     *
     * @param  \AstroAPI\Model\CompatibilityRequest|null $compatibility_request compatibility_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcCompatibility'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \AstroAPI\Model\CompatibilityResponse
     */
    public function postApiCalcCompatibility($compatibility_request = null, string $contentType = self::contentTypes['postApiCalcCompatibility'][0])
    {
        list($response) = $this->postApiCalcCompatibilityWithHttpInfo($compatibility_request, $contentType);
        return $response;
    }

    /**
     * Operation postApiCalcCompatibilityWithHttpInfo
     *
     * Compatibility Analysis
     *
     * @param  \AstroAPI\Model\CompatibilityRequest|null $compatibility_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcCompatibility'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \AstroAPI\Model\CompatibilityResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function postApiCalcCompatibilityWithHttpInfo($compatibility_request = null, string $contentType = self::contentTypes['postApiCalcCompatibility'][0])
    {
        $request = $this->postApiCalcCompatibilityRequest($compatibility_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\AstroAPI\Model\CompatibilityResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\AstroAPI\Model\CompatibilityResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\AstroAPI\Model\CompatibilityResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation postApiCalcCompatibilityAsync
     *
     * Compatibility Analysis
     *
     * @param  \AstroAPI\Model\CompatibilityRequest|null $compatibility_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcCompatibility'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiCalcCompatibilityAsync($compatibility_request = null, string $contentType = self::contentTypes['postApiCalcCompatibility'][0])
    {
        return $this->postApiCalcCompatibilityAsyncWithHttpInfo($compatibility_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postApiCalcCompatibilityAsyncWithHttpInfo
     *
     * Compatibility Analysis
     *
     * @param  \AstroAPI\Model\CompatibilityRequest|null $compatibility_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcCompatibility'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiCalcCompatibilityAsyncWithHttpInfo($compatibility_request = null, string $contentType = self::contentTypes['postApiCalcCompatibility'][0])
    {
        $returnType = '\AstroAPI\Model\CompatibilityResponse';
        $request = $this->postApiCalcCompatibilityRequest($compatibility_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postApiCalcCompatibility'
     *
     * @param  \AstroAPI\Model\CompatibilityRequest|null $compatibility_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcCompatibility'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postApiCalcCompatibilityRequest($compatibility_request = null, string $contentType = self::contentTypes['postApiCalcCompatibility'][0])
    {



        $resourcePath = '/api/calc/compatibility';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/vnd.api+json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($compatibility_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($compatibility_request));
            } else {
                $httpBody = $compatibility_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Api-Key');
        if ($apiKey !== null) {
            $headers['X-Api-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postApiCalcComposite
     *
     * Composite Chart
     *
     * @param  \AstroAPI\Model\CompositeRequest|null $composite_request composite_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcComposite'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \AstroAPI\Model\CompositeResponse
     */
    public function postApiCalcComposite($composite_request = null, string $contentType = self::contentTypes['postApiCalcComposite'][0])
    {
        list($response) = $this->postApiCalcCompositeWithHttpInfo($composite_request, $contentType);
        return $response;
    }

    /**
     * Operation postApiCalcCompositeWithHttpInfo
     *
     * Composite Chart
     *
     * @param  \AstroAPI\Model\CompositeRequest|null $composite_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcComposite'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \AstroAPI\Model\CompositeResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function postApiCalcCompositeWithHttpInfo($composite_request = null, string $contentType = self::contentTypes['postApiCalcComposite'][0])
    {
        $request = $this->postApiCalcCompositeRequest($composite_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\AstroAPI\Model\CompositeResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\AstroAPI\Model\CompositeResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\AstroAPI\Model\CompositeResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation postApiCalcCompositeAsync
     *
     * Composite Chart
     *
     * @param  \AstroAPI\Model\CompositeRequest|null $composite_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcComposite'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiCalcCompositeAsync($composite_request = null, string $contentType = self::contentTypes['postApiCalcComposite'][0])
    {
        return $this->postApiCalcCompositeAsyncWithHttpInfo($composite_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postApiCalcCompositeAsyncWithHttpInfo
     *
     * Composite Chart
     *
     * @param  \AstroAPI\Model\CompositeRequest|null $composite_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcComposite'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiCalcCompositeAsyncWithHttpInfo($composite_request = null, string $contentType = self::contentTypes['postApiCalcComposite'][0])
    {
        $returnType = '\AstroAPI\Model\CompositeResponse';
        $request = $this->postApiCalcCompositeRequest($composite_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postApiCalcComposite'
     *
     * @param  \AstroAPI\Model\CompositeRequest|null $composite_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcComposite'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postApiCalcCompositeRequest($composite_request = null, string $contentType = self::contentTypes['postApiCalcComposite'][0])
    {



        $resourcePath = '/api/calc/composite';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/vnd.api+json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($composite_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($composite_request));
            } else {
                $httpBody = $composite_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Api-Key');
        if ($apiKey !== null) {
            $headers['X-Api-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postApiCalcLunarReturn
     *
     * Lunar Return
     *
     * @param  \AstroAPI\Model\LunarReturnRequest|null $lunar_return_request lunar_return_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcLunarReturn'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \AstroAPI\Model\LunarReturnResponse
     */
    public function postApiCalcLunarReturn($lunar_return_request = null, string $contentType = self::contentTypes['postApiCalcLunarReturn'][0])
    {
        list($response) = $this->postApiCalcLunarReturnWithHttpInfo($lunar_return_request, $contentType);
        return $response;
    }

    /**
     * Operation postApiCalcLunarReturnWithHttpInfo
     *
     * Lunar Return
     *
     * @param  \AstroAPI\Model\LunarReturnRequest|null $lunar_return_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcLunarReturn'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \AstroAPI\Model\LunarReturnResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function postApiCalcLunarReturnWithHttpInfo($lunar_return_request = null, string $contentType = self::contentTypes['postApiCalcLunarReturn'][0])
    {
        $request = $this->postApiCalcLunarReturnRequest($lunar_return_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\AstroAPI\Model\LunarReturnResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\AstroAPI\Model\LunarReturnResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\AstroAPI\Model\LunarReturnResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation postApiCalcLunarReturnAsync
     *
     * Lunar Return
     *
     * @param  \AstroAPI\Model\LunarReturnRequest|null $lunar_return_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcLunarReturn'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiCalcLunarReturnAsync($lunar_return_request = null, string $contentType = self::contentTypes['postApiCalcLunarReturn'][0])
    {
        return $this->postApiCalcLunarReturnAsyncWithHttpInfo($lunar_return_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postApiCalcLunarReturnAsyncWithHttpInfo
     *
     * Lunar Return
     *
     * @param  \AstroAPI\Model\LunarReturnRequest|null $lunar_return_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcLunarReturn'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiCalcLunarReturnAsyncWithHttpInfo($lunar_return_request = null, string $contentType = self::contentTypes['postApiCalcLunarReturn'][0])
    {
        $returnType = '\AstroAPI\Model\LunarReturnResponse';
        $request = $this->postApiCalcLunarReturnRequest($lunar_return_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postApiCalcLunarReturn'
     *
     * @param  \AstroAPI\Model\LunarReturnRequest|null $lunar_return_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcLunarReturn'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postApiCalcLunarReturnRequest($lunar_return_request = null, string $contentType = self::contentTypes['postApiCalcLunarReturn'][0])
    {



        $resourcePath = '/api/calc/lunar-return';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/vnd.api+json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($lunar_return_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($lunar_return_request));
            } else {
                $httpBody = $lunar_return_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Api-Key');
        if ($apiKey !== null) {
            $headers['X-Api-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postApiCalcMoonSun
     *
     * Moon &amp; Sun Info
     *
     * @param  \AstroAPI\Model\MoonSunRequest|null $moon_sun_request moon_sun_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcMoonSun'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \AstroAPI\Model\MoonSunResponse
     */
    public function postApiCalcMoonSun($moon_sun_request = null, string $contentType = self::contentTypes['postApiCalcMoonSun'][0])
    {
        list($response) = $this->postApiCalcMoonSunWithHttpInfo($moon_sun_request, $contentType);
        return $response;
    }

    /**
     * Operation postApiCalcMoonSunWithHttpInfo
     *
     * Moon &amp; Sun Info
     *
     * @param  \AstroAPI\Model\MoonSunRequest|null $moon_sun_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcMoonSun'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \AstroAPI\Model\MoonSunResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function postApiCalcMoonSunWithHttpInfo($moon_sun_request = null, string $contentType = self::contentTypes['postApiCalcMoonSun'][0])
    {
        $request = $this->postApiCalcMoonSunRequest($moon_sun_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\AstroAPI\Model\MoonSunResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\AstroAPI\Model\MoonSunResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\AstroAPI\Model\MoonSunResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation postApiCalcMoonSunAsync
     *
     * Moon &amp; Sun Info
     *
     * @param  \AstroAPI\Model\MoonSunRequest|null $moon_sun_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcMoonSun'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiCalcMoonSunAsync($moon_sun_request = null, string $contentType = self::contentTypes['postApiCalcMoonSun'][0])
    {
        return $this->postApiCalcMoonSunAsyncWithHttpInfo($moon_sun_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postApiCalcMoonSunAsyncWithHttpInfo
     *
     * Moon &amp; Sun Info
     *
     * @param  \AstroAPI\Model\MoonSunRequest|null $moon_sun_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcMoonSun'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiCalcMoonSunAsyncWithHttpInfo($moon_sun_request = null, string $contentType = self::contentTypes['postApiCalcMoonSun'][0])
    {
        $returnType = '\AstroAPI\Model\MoonSunResponse';
        $request = $this->postApiCalcMoonSunRequest($moon_sun_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postApiCalcMoonSun'
     *
     * @param  \AstroAPI\Model\MoonSunRequest|null $moon_sun_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcMoonSun'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postApiCalcMoonSunRequest($moon_sun_request = null, string $contentType = self::contentTypes['postApiCalcMoonSun'][0])
    {



        $resourcePath = '/api/calc/moon-sun';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/vnd.api+json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($moon_sun_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($moon_sun_request));
            } else {
                $httpBody = $moon_sun_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Api-Key');
        if ($apiKey !== null) {
            $headers['X-Api-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postApiCalcNatal
     *
     * Natal Chart
     *
     * @param  \AstroAPI\Model\NatalRequest|null $natal_request natal_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcNatal'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \AstroAPI\Model\NatalResponse
     */
    public function postApiCalcNatal($natal_request = null, string $contentType = self::contentTypes['postApiCalcNatal'][0])
    {
        list($response) = $this->postApiCalcNatalWithHttpInfo($natal_request, $contentType);
        return $response;
    }

    /**
     * Operation postApiCalcNatalWithHttpInfo
     *
     * Natal Chart
     *
     * @param  \AstroAPI\Model\NatalRequest|null $natal_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcNatal'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \AstroAPI\Model\NatalResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function postApiCalcNatalWithHttpInfo($natal_request = null, string $contentType = self::contentTypes['postApiCalcNatal'][0])
    {
        $request = $this->postApiCalcNatalRequest($natal_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\AstroAPI\Model\NatalResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\AstroAPI\Model\NatalResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\AstroAPI\Model\NatalResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation postApiCalcNatalAsync
     *
     * Natal Chart
     *
     * @param  \AstroAPI\Model\NatalRequest|null $natal_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcNatal'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiCalcNatalAsync($natal_request = null, string $contentType = self::contentTypes['postApiCalcNatal'][0])
    {
        return $this->postApiCalcNatalAsyncWithHttpInfo($natal_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postApiCalcNatalAsyncWithHttpInfo
     *
     * Natal Chart
     *
     * @param  \AstroAPI\Model\NatalRequest|null $natal_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcNatal'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiCalcNatalAsyncWithHttpInfo($natal_request = null, string $contentType = self::contentTypes['postApiCalcNatal'][0])
    {
        $returnType = '\AstroAPI\Model\NatalResponse';
        $request = $this->postApiCalcNatalRequest($natal_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postApiCalcNatal'
     *
     * @param  \AstroAPI\Model\NatalRequest|null $natal_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcNatal'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postApiCalcNatalRequest($natal_request = null, string $contentType = self::contentTypes['postApiCalcNatal'][0])
    {



        $resourcePath = '/api/calc/natal';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/vnd.api+json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($natal_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($natal_request));
            } else {
                $httpBody = $natal_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Api-Key');
        if ($apiKey !== null) {
            $headers['X-Api-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postApiCalcProgressions
     *
     * Secondary Progressions
     *
     * @param  \AstroAPI\Model\ProgressionsRequest|null $progressions_request progressions_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcProgressions'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \AstroAPI\Model\ProgressionsResponse
     */
    public function postApiCalcProgressions($progressions_request = null, string $contentType = self::contentTypes['postApiCalcProgressions'][0])
    {
        list($response) = $this->postApiCalcProgressionsWithHttpInfo($progressions_request, $contentType);
        return $response;
    }

    /**
     * Operation postApiCalcProgressionsWithHttpInfo
     *
     * Secondary Progressions
     *
     * @param  \AstroAPI\Model\ProgressionsRequest|null $progressions_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcProgressions'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \AstroAPI\Model\ProgressionsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function postApiCalcProgressionsWithHttpInfo($progressions_request = null, string $contentType = self::contentTypes['postApiCalcProgressions'][0])
    {
        $request = $this->postApiCalcProgressionsRequest($progressions_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\AstroAPI\Model\ProgressionsResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\AstroAPI\Model\ProgressionsResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\AstroAPI\Model\ProgressionsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation postApiCalcProgressionsAsync
     *
     * Secondary Progressions
     *
     * @param  \AstroAPI\Model\ProgressionsRequest|null $progressions_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcProgressions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiCalcProgressionsAsync($progressions_request = null, string $contentType = self::contentTypes['postApiCalcProgressions'][0])
    {
        return $this->postApiCalcProgressionsAsyncWithHttpInfo($progressions_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postApiCalcProgressionsAsyncWithHttpInfo
     *
     * Secondary Progressions
     *
     * @param  \AstroAPI\Model\ProgressionsRequest|null $progressions_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcProgressions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiCalcProgressionsAsyncWithHttpInfo($progressions_request = null, string $contentType = self::contentTypes['postApiCalcProgressions'][0])
    {
        $returnType = '\AstroAPI\Model\ProgressionsResponse';
        $request = $this->postApiCalcProgressionsRequest($progressions_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postApiCalcProgressions'
     *
     * @param  \AstroAPI\Model\ProgressionsRequest|null $progressions_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcProgressions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postApiCalcProgressionsRequest($progressions_request = null, string $contentType = self::contentTypes['postApiCalcProgressions'][0])
    {



        $resourcePath = '/api/calc/progressions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/vnd.api+json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($progressions_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($progressions_request));
            } else {
                $httpBody = $progressions_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Api-Key');
        if ($apiKey !== null) {
            $headers['X-Api-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postApiCalcSolarReturn
     *
     * Solar Return
     *
     * @param  \AstroAPI\Model\SolarReturnRequest|null $solar_return_request solar_return_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcSolarReturn'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \AstroAPI\Model\SolarReturnResponse
     */
    public function postApiCalcSolarReturn($solar_return_request = null, string $contentType = self::contentTypes['postApiCalcSolarReturn'][0])
    {
        list($response) = $this->postApiCalcSolarReturnWithHttpInfo($solar_return_request, $contentType);
        return $response;
    }

    /**
     * Operation postApiCalcSolarReturnWithHttpInfo
     *
     * Solar Return
     *
     * @param  \AstroAPI\Model\SolarReturnRequest|null $solar_return_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcSolarReturn'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \AstroAPI\Model\SolarReturnResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function postApiCalcSolarReturnWithHttpInfo($solar_return_request = null, string $contentType = self::contentTypes['postApiCalcSolarReturn'][0])
    {
        $request = $this->postApiCalcSolarReturnRequest($solar_return_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\AstroAPI\Model\SolarReturnResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\AstroAPI\Model\SolarReturnResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\AstroAPI\Model\SolarReturnResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation postApiCalcSolarReturnAsync
     *
     * Solar Return
     *
     * @param  \AstroAPI\Model\SolarReturnRequest|null $solar_return_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcSolarReturn'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiCalcSolarReturnAsync($solar_return_request = null, string $contentType = self::contentTypes['postApiCalcSolarReturn'][0])
    {
        return $this->postApiCalcSolarReturnAsyncWithHttpInfo($solar_return_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postApiCalcSolarReturnAsyncWithHttpInfo
     *
     * Solar Return
     *
     * @param  \AstroAPI\Model\SolarReturnRequest|null $solar_return_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcSolarReturn'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiCalcSolarReturnAsyncWithHttpInfo($solar_return_request = null, string $contentType = self::contentTypes['postApiCalcSolarReturn'][0])
    {
        $returnType = '\AstroAPI\Model\SolarReturnResponse';
        $request = $this->postApiCalcSolarReturnRequest($solar_return_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postApiCalcSolarReturn'
     *
     * @param  \AstroAPI\Model\SolarReturnRequest|null $solar_return_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcSolarReturn'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postApiCalcSolarReturnRequest($solar_return_request = null, string $contentType = self::contentTypes['postApiCalcSolarReturn'][0])
    {



        $resourcePath = '/api/calc/solar-return';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/vnd.api+json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($solar_return_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($solar_return_request));
            } else {
                $httpBody = $solar_return_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Api-Key');
        if ($apiKey !== null) {
            $headers['X-Api-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postApiCalcSynastry
     *
     * Synastry Chart
     *
     * @param  \AstroAPI\Model\SynastryRequest|null $synastry_request synastry_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcSynastry'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \AstroAPI\Model\SynastryResponse
     */
    public function postApiCalcSynastry($synastry_request = null, string $contentType = self::contentTypes['postApiCalcSynastry'][0])
    {
        list($response) = $this->postApiCalcSynastryWithHttpInfo($synastry_request, $contentType);
        return $response;
    }

    /**
     * Operation postApiCalcSynastryWithHttpInfo
     *
     * Synastry Chart
     *
     * @param  \AstroAPI\Model\SynastryRequest|null $synastry_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcSynastry'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \AstroAPI\Model\SynastryResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function postApiCalcSynastryWithHttpInfo($synastry_request = null, string $contentType = self::contentTypes['postApiCalcSynastry'][0])
    {
        $request = $this->postApiCalcSynastryRequest($synastry_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\AstroAPI\Model\SynastryResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\AstroAPI\Model\SynastryResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\AstroAPI\Model\SynastryResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation postApiCalcSynastryAsync
     *
     * Synastry Chart
     *
     * @param  \AstroAPI\Model\SynastryRequest|null $synastry_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcSynastry'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiCalcSynastryAsync($synastry_request = null, string $contentType = self::contentTypes['postApiCalcSynastry'][0])
    {
        return $this->postApiCalcSynastryAsyncWithHttpInfo($synastry_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postApiCalcSynastryAsyncWithHttpInfo
     *
     * Synastry Chart
     *
     * @param  \AstroAPI\Model\SynastryRequest|null $synastry_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcSynastry'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiCalcSynastryAsyncWithHttpInfo($synastry_request = null, string $contentType = self::contentTypes['postApiCalcSynastry'][0])
    {
        $returnType = '\AstroAPI\Model\SynastryResponse';
        $request = $this->postApiCalcSynastryRequest($synastry_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postApiCalcSynastry'
     *
     * @param  \AstroAPI\Model\SynastryRequest|null $synastry_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcSynastry'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postApiCalcSynastryRequest($synastry_request = null, string $contentType = self::contentTypes['postApiCalcSynastry'][0])
    {



        $resourcePath = '/api/calc/synastry';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/vnd.api+json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($synastry_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($synastry_request));
            } else {
                $httpBody = $synastry_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Api-Key');
        if ($apiKey !== null) {
            $headers['X-Api-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postApiCalcTransit
     *
     * Transit Chart
     *
     * @param  \AstroAPI\Model\TransitRequest|null $transit_request transit_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcTransit'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \AstroAPI\Model\TransitResponse
     */
    public function postApiCalcTransit($transit_request = null, string $contentType = self::contentTypes['postApiCalcTransit'][0])
    {
        list($response) = $this->postApiCalcTransitWithHttpInfo($transit_request, $contentType);
        return $response;
    }

    /**
     * Operation postApiCalcTransitWithHttpInfo
     *
     * Transit Chart
     *
     * @param  \AstroAPI\Model\TransitRequest|null $transit_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcTransit'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \AstroAPI\Model\TransitResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function postApiCalcTransitWithHttpInfo($transit_request = null, string $contentType = self::contentTypes['postApiCalcTransit'][0])
    {
        $request = $this->postApiCalcTransitRequest($transit_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\AstroAPI\Model\TransitResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\AstroAPI\Model\TransitResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\AstroAPI\Model\TransitResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation postApiCalcTransitAsync
     *
     * Transit Chart
     *
     * @param  \AstroAPI\Model\TransitRequest|null $transit_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcTransit'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiCalcTransitAsync($transit_request = null, string $contentType = self::contentTypes['postApiCalcTransit'][0])
    {
        return $this->postApiCalcTransitAsyncWithHttpInfo($transit_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postApiCalcTransitAsyncWithHttpInfo
     *
     * Transit Chart
     *
     * @param  \AstroAPI\Model\TransitRequest|null $transit_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcTransit'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiCalcTransitAsyncWithHttpInfo($transit_request = null, string $contentType = self::contentTypes['postApiCalcTransit'][0])
    {
        $returnType = '\AstroAPI\Model\TransitResponse';
        $request = $this->postApiCalcTransitRequest($transit_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postApiCalcTransit'
     *
     * @param  \AstroAPI\Model\TransitRequest|null $transit_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiCalcTransit'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postApiCalcTransitRequest($transit_request = null, string $contentType = self::contentTypes['postApiCalcTransit'][0])
    {



        $resourcePath = '/api/calc/transit';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/vnd.api+json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($transit_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($transit_request));
            } else {
                $httpBody = $transit_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Api-Key');
        if ($apiKey !== null) {
            $headers['X-Api-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        if ($this->config->getCertFile()) {
            $options[RequestOptions::CERT] = $this->config->getCertFile();
        }

        if ($this->config->getKeyFile()) {
            $options[RequestOptions::SSL_KEY] = $this->config->getKeyFile();
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
