<?php
/**
 * ChatApi
 * PHP version 8.1
 *
 * @category Class
 * @package  AstroAPI
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * AstroAPI
 *
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.17.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace AstroAPI\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use AstroAPI\ApiException;
use AstroAPI\Configuration;
use AstroAPI\FormDataProcessor;
use AstroAPI\HeaderSelector;
use AstroAPI\ObjectSerializer;

/**
 * ChatApi Class Doc Comment
 *
 * @category Class
 * @package  AstroAPI
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ChatApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'chat' => [
            'application/json',
        ],
        'chatDirect' => [
            'application/json',
        ],
        'chatWithProfile' => [
            'application/json',
        ],
        'deleteConversation' => [
            'application/json',
        ],
        'getConversation' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation chat
     *
     * Chat with Chatbot
     *
     * @param  string $chatbot_id chatbot_id (required)
     * @param  \AstroAPI\Model\ChatRequest|null $chat_request chat_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['chat'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return mixed
     */
    public function chat($chatbot_id, $chat_request = null, string $contentType = self::contentTypes['chat'][0])
    {
        list($response) = $this->chatWithHttpInfo($chatbot_id, $chat_request, $contentType);
        return $response;
    }

    /**
     * Operation chatWithHttpInfo
     *
     * Chat with Chatbot
     *
     * @param  string $chatbot_id (required)
     * @param  \AstroAPI\Model\ChatRequest|null $chat_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['chat'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of mixed, HTTP status code, HTTP response headers (array of strings)
     */
    public function chatWithHttpInfo($chatbot_id, $chat_request = null, string $contentType = self::contentTypes['chat'][0])
    {
        $request = $this->chatRequest($chatbot_id, $chat_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'mixed',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'mixed',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'mixed',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation chatAsync
     *
     * Chat with Chatbot
     *
     * @param  string $chatbot_id (required)
     * @param  \AstroAPI\Model\ChatRequest|null $chat_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['chat'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function chatAsync($chatbot_id, $chat_request = null, string $contentType = self::contentTypes['chat'][0])
    {
        return $this->chatAsyncWithHttpInfo($chatbot_id, $chat_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation chatAsyncWithHttpInfo
     *
     * Chat with Chatbot
     *
     * @param  string $chatbot_id (required)
     * @param  \AstroAPI\Model\ChatRequest|null $chat_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['chat'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function chatAsyncWithHttpInfo($chatbot_id, $chat_request = null, string $contentType = self::contentTypes['chat'][0])
    {
        $returnType = 'mixed';
        $request = $this->chatRequest($chatbot_id, $chat_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'chat'
     *
     * @param  string $chatbot_id (required)
     * @param  \AstroAPI\Model\ChatRequest|null $chat_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['chat'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function chatRequest($chatbot_id, $chat_request = null, string $contentType = self::contentTypes['chat'][0])
    {

        // verify the required parameter 'chatbot_id' is set
        if ($chatbot_id === null || (is_array($chatbot_id) && count($chatbot_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $chatbot_id when calling chat'
            );
        }



        $resourcePath = '/api/chat/{chatbotId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($chatbot_id !== null) {
            $resourcePath = str_replace(
                '{' . 'chatbotId' . '}',
                ObjectSerializer::toPathValue($chatbot_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['text/event-stream', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($chat_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($chat_request));
            } else {
                $httpBody = $chat_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Api-Key');
        if ($apiKey !== null) {
            $headers['X-Api-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation chatDirect
     *
     * Chat with Birth Data
     *
     * @param  string $chatbot_id chatbot_id (required)
     * @param  \AstroAPI\Model\ChatDirectRequest|null $chat_direct_request chat_direct_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['chatDirect'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return mixed
     */
    public function chatDirect($chatbot_id, $chat_direct_request = null, string $contentType = self::contentTypes['chatDirect'][0])
    {
        list($response) = $this->chatDirectWithHttpInfo($chatbot_id, $chat_direct_request, $contentType);
        return $response;
    }

    /**
     * Operation chatDirectWithHttpInfo
     *
     * Chat with Birth Data
     *
     * @param  string $chatbot_id (required)
     * @param  \AstroAPI\Model\ChatDirectRequest|null $chat_direct_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['chatDirect'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of mixed, HTTP status code, HTTP response headers (array of strings)
     */
    public function chatDirectWithHttpInfo($chatbot_id, $chat_direct_request = null, string $contentType = self::contentTypes['chatDirect'][0])
    {
        $request = $this->chatDirectRequest($chatbot_id, $chat_direct_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'mixed',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'mixed',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'mixed',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation chatDirectAsync
     *
     * Chat with Birth Data
     *
     * @param  string $chatbot_id (required)
     * @param  \AstroAPI\Model\ChatDirectRequest|null $chat_direct_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['chatDirect'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function chatDirectAsync($chatbot_id, $chat_direct_request = null, string $contentType = self::contentTypes['chatDirect'][0])
    {
        return $this->chatDirectAsyncWithHttpInfo($chatbot_id, $chat_direct_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation chatDirectAsyncWithHttpInfo
     *
     * Chat with Birth Data
     *
     * @param  string $chatbot_id (required)
     * @param  \AstroAPI\Model\ChatDirectRequest|null $chat_direct_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['chatDirect'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function chatDirectAsyncWithHttpInfo($chatbot_id, $chat_direct_request = null, string $contentType = self::contentTypes['chatDirect'][0])
    {
        $returnType = 'mixed';
        $request = $this->chatDirectRequest($chatbot_id, $chat_direct_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'chatDirect'
     *
     * @param  string $chatbot_id (required)
     * @param  \AstroAPI\Model\ChatDirectRequest|null $chat_direct_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['chatDirect'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function chatDirectRequest($chatbot_id, $chat_direct_request = null, string $contentType = self::contentTypes['chatDirect'][0])
    {

        // verify the required parameter 'chatbot_id' is set
        if ($chatbot_id === null || (is_array($chatbot_id) && count($chatbot_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $chatbot_id when calling chatDirect'
            );
        }



        $resourcePath = '/api/chat/{chatbotId}/direct';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($chatbot_id !== null) {
            $resourcePath = str_replace(
                '{' . 'chatbotId' . '}',
                ObjectSerializer::toPathValue($chatbot_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['text/event-stream', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($chat_direct_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($chat_direct_request));
            } else {
                $httpBody = $chat_direct_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Api-Key');
        if ($apiKey !== null) {
            $headers['X-Api-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation chatWithProfile
     *
     * Chat with Profile
     *
     * @param  string $chatbot_id chatbot_id (required)
     * @param  string $profile_id profile_id (required)
     * @param  \AstroAPI\Model\ChatRequest|null $chat_request chat_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['chatWithProfile'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return mixed
     */
    public function chatWithProfile($chatbot_id, $profile_id, $chat_request = null, string $contentType = self::contentTypes['chatWithProfile'][0])
    {
        list($response) = $this->chatWithProfileWithHttpInfo($chatbot_id, $profile_id, $chat_request, $contentType);
        return $response;
    }

    /**
     * Operation chatWithProfileWithHttpInfo
     *
     * Chat with Profile
     *
     * @param  string $chatbot_id (required)
     * @param  string $profile_id (required)
     * @param  \AstroAPI\Model\ChatRequest|null $chat_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['chatWithProfile'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of mixed, HTTP status code, HTTP response headers (array of strings)
     */
    public function chatWithProfileWithHttpInfo($chatbot_id, $profile_id, $chat_request = null, string $contentType = self::contentTypes['chatWithProfile'][0])
    {
        $request = $this->chatWithProfileRequest($chatbot_id, $profile_id, $chat_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'mixed',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'mixed',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'mixed',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation chatWithProfileAsync
     *
     * Chat with Profile
     *
     * @param  string $chatbot_id (required)
     * @param  string $profile_id (required)
     * @param  \AstroAPI\Model\ChatRequest|null $chat_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['chatWithProfile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function chatWithProfileAsync($chatbot_id, $profile_id, $chat_request = null, string $contentType = self::contentTypes['chatWithProfile'][0])
    {
        return $this->chatWithProfileAsyncWithHttpInfo($chatbot_id, $profile_id, $chat_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation chatWithProfileAsyncWithHttpInfo
     *
     * Chat with Profile
     *
     * @param  string $chatbot_id (required)
     * @param  string $profile_id (required)
     * @param  \AstroAPI\Model\ChatRequest|null $chat_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['chatWithProfile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function chatWithProfileAsyncWithHttpInfo($chatbot_id, $profile_id, $chat_request = null, string $contentType = self::contentTypes['chatWithProfile'][0])
    {
        $returnType = 'mixed';
        $request = $this->chatWithProfileRequest($chatbot_id, $profile_id, $chat_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'chatWithProfile'
     *
     * @param  string $chatbot_id (required)
     * @param  string $profile_id (required)
     * @param  \AstroAPI\Model\ChatRequest|null $chat_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['chatWithProfile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function chatWithProfileRequest($chatbot_id, $profile_id, $chat_request = null, string $contentType = self::contentTypes['chatWithProfile'][0])
    {

        // verify the required parameter 'chatbot_id' is set
        if ($chatbot_id === null || (is_array($chatbot_id) && count($chatbot_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $chatbot_id when calling chatWithProfile'
            );
        }

        // verify the required parameter 'profile_id' is set
        if ($profile_id === null || (is_array($profile_id) && count($profile_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $profile_id when calling chatWithProfile'
            );
        }



        $resourcePath = '/api/chat/{chatbotId}/profile/{profileId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($chatbot_id !== null) {
            $resourcePath = str_replace(
                '{' . 'chatbotId' . '}',
                ObjectSerializer::toPathValue($chatbot_id),
                $resourcePath
            );
        }
        // path params
        if ($profile_id !== null) {
            $resourcePath = str_replace(
                '{' . 'profileId' . '}',
                ObjectSerializer::toPathValue($profile_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['text/event-stream', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($chat_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($chat_request));
            } else {
                $httpBody = $chat_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Api-Key');
        if ($apiKey !== null) {
            $headers['X-Api-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteConversation
     *
     * Delete Conversation
     *
     * @param  string $chatbot_id chatbot_id (required)
     * @param  string $conversation_id conversation_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteConversation'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteConversation($chatbot_id, $conversation_id, string $contentType = self::contentTypes['deleteConversation'][0])
    {
        $this->deleteConversationWithHttpInfo($chatbot_id, $conversation_id, $contentType);
    }

    /**
     * Operation deleteConversationWithHttpInfo
     *
     * Delete Conversation
     *
     * @param  string $chatbot_id (required)
     * @param  string $conversation_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteConversation'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteConversationWithHttpInfo($chatbot_id, $conversation_id, string $contentType = self::contentTypes['deleteConversation'][0])
    {
        $request = $this->deleteConversationRequest($chatbot_id, $conversation_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteConversationAsync
     *
     * Delete Conversation
     *
     * @param  string $chatbot_id (required)
     * @param  string $conversation_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteConversation'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteConversationAsync($chatbot_id, $conversation_id, string $contentType = self::contentTypes['deleteConversation'][0])
    {
        return $this->deleteConversationAsyncWithHttpInfo($chatbot_id, $conversation_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteConversationAsyncWithHttpInfo
     *
     * Delete Conversation
     *
     * @param  string $chatbot_id (required)
     * @param  string $conversation_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteConversation'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteConversationAsyncWithHttpInfo($chatbot_id, $conversation_id, string $contentType = self::contentTypes['deleteConversation'][0])
    {
        $returnType = '';
        $request = $this->deleteConversationRequest($chatbot_id, $conversation_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteConversation'
     *
     * @param  string $chatbot_id (required)
     * @param  string $conversation_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteConversation'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteConversationRequest($chatbot_id, $conversation_id, string $contentType = self::contentTypes['deleteConversation'][0])
    {

        // verify the required parameter 'chatbot_id' is set
        if ($chatbot_id === null || (is_array($chatbot_id) && count($chatbot_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $chatbot_id when calling deleteConversation'
            );
        }

        // verify the required parameter 'conversation_id' is set
        if ($conversation_id === null || (is_array($conversation_id) && count($conversation_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $conversation_id when calling deleteConversation'
            );
        }


        $resourcePath = '/api/chat/{chatbotId}/conversation/{conversationId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($chatbot_id !== null) {
            $resourcePath = str_replace(
                '{' . 'chatbotId' . '}',
                ObjectSerializer::toPathValue($chatbot_id),
                $resourcePath
            );
        }
        // path params
        if ($conversation_id !== null) {
            $resourcePath = str_replace(
                '{' . 'conversationId' . '}',
                ObjectSerializer::toPathValue($conversation_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Api-Key');
        if ($apiKey !== null) {
            $headers['X-Api-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getConversation
     *
     * Get Conversation
     *
     * @param  string $chatbot_id chatbot_id (required)
     * @param  string $conversation_id conversation_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getConversation'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function getConversation($chatbot_id, $conversation_id, string $contentType = self::contentTypes['getConversation'][0])
    {
        $this->getConversationWithHttpInfo($chatbot_id, $conversation_id, $contentType);
    }

    /**
     * Operation getConversationWithHttpInfo
     *
     * Get Conversation
     *
     * @param  string $chatbot_id (required)
     * @param  string $conversation_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getConversation'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function getConversationWithHttpInfo($chatbot_id, $conversation_id, string $contentType = self::contentTypes['getConversation'][0])
    {
        $request = $this->getConversationRequest($chatbot_id, $conversation_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation getConversationAsync
     *
     * Get Conversation
     *
     * @param  string $chatbot_id (required)
     * @param  string $conversation_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getConversation'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getConversationAsync($chatbot_id, $conversation_id, string $contentType = self::contentTypes['getConversation'][0])
    {
        return $this->getConversationAsyncWithHttpInfo($chatbot_id, $conversation_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getConversationAsyncWithHttpInfo
     *
     * Get Conversation
     *
     * @param  string $chatbot_id (required)
     * @param  string $conversation_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getConversation'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getConversationAsyncWithHttpInfo($chatbot_id, $conversation_id, string $contentType = self::contentTypes['getConversation'][0])
    {
        $returnType = '';
        $request = $this->getConversationRequest($chatbot_id, $conversation_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getConversation'
     *
     * @param  string $chatbot_id (required)
     * @param  string $conversation_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getConversation'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getConversationRequest($chatbot_id, $conversation_id, string $contentType = self::contentTypes['getConversation'][0])
    {

        // verify the required parameter 'chatbot_id' is set
        if ($chatbot_id === null || (is_array($chatbot_id) && count($chatbot_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $chatbot_id when calling getConversation'
            );
        }

        // verify the required parameter 'conversation_id' is set
        if ($conversation_id === null || (is_array($conversation_id) && count($conversation_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $conversation_id when calling getConversation'
            );
        }


        $resourcePath = '/api/chat/{chatbotId}/conversation/{conversationId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($chatbot_id !== null) {
            $resourcePath = str_replace(
                '{' . 'chatbotId' . '}',
                ObjectSerializer::toPathValue($chatbot_id),
                $resourcePath
            );
        }
        // path params
        if ($conversation_id !== null) {
            $resourcePath = str_replace(
                '{' . 'conversationId' . '}',
                ObjectSerializer::toPathValue($conversation_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Api-Key');
        if ($apiKey !== null) {
            $headers['X-Api-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        if ($this->config->getCertFile()) {
            $options[RequestOptions::CERT] = $this->config->getCertFile();
        }

        if ($this->config->getKeyFile()) {
            $options[RequestOptions::SSL_KEY] = $this->config->getKeyFile();
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
