<?php
/**
 * HoroscopeApi
 * PHP version 8.1
 *
 * @category Class
 * @package  AstroAPI
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * AstroAPI
 *
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.17.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace AstroAPI\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use AstroAPI\ApiException;
use AstroAPI\Configuration;
use AstroAPI\FormDataProcessor;
use AstroAPI\HeaderSelector;
use AstroAPI\ObjectSerializer;

/**
 * HoroscopeApi Class Doc Comment
 *
 * @category Class
 * @package  AstroAPI
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class HoroscopeApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'getDailyHoroscopes' => [
            'application/json',
        ],
        'getWeeklyHoroscope' => [
            'application/json',
        ],
        'getYearlyAscendantHoroscope' => [
            'application/json',
        ],
        'getYearlyHoroscope' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation getDailyHoroscopes
     *
     * Get Daily Horoscopes
     *
     * @param  string $date date (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDailyHoroscopes'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \AstroAPI\Model\DailyHoroscopeResponse
     */
    public function getDailyHoroscopes($date, string $contentType = self::contentTypes['getDailyHoroscopes'][0])
    {
        list($response) = $this->getDailyHoroscopesWithHttpInfo($date, $contentType);
        return $response;
    }

    /**
     * Operation getDailyHoroscopesWithHttpInfo
     *
     * Get Daily Horoscopes
     *
     * @param  string $date (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDailyHoroscopes'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \AstroAPI\Model\DailyHoroscopeResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDailyHoroscopesWithHttpInfo($date, string $contentType = self::contentTypes['getDailyHoroscopes'][0])
    {
        $request = $this->getDailyHoroscopesRequest($date, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\AstroAPI\Model\DailyHoroscopeResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\AstroAPI\Model\DailyHoroscopeResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\AstroAPI\Model\DailyHoroscopeResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getDailyHoroscopesAsync
     *
     * Get Daily Horoscopes
     *
     * @param  string $date (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDailyHoroscopes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getDailyHoroscopesAsync($date, string $contentType = self::contentTypes['getDailyHoroscopes'][0])
    {
        return $this->getDailyHoroscopesAsyncWithHttpInfo($date, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getDailyHoroscopesAsyncWithHttpInfo
     *
     * Get Daily Horoscopes
     *
     * @param  string $date (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDailyHoroscopes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getDailyHoroscopesAsyncWithHttpInfo($date, string $contentType = self::contentTypes['getDailyHoroscopes'][0])
    {
        $returnType = '\AstroAPI\Model\DailyHoroscopeResponse';
        $request = $this->getDailyHoroscopesRequest($date, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getDailyHoroscopes'
     *
     * @param  string $date (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDailyHoroscopes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getDailyHoroscopesRequest($date, string $contentType = self::contentTypes['getDailyHoroscopes'][0])
    {

        // verify the required parameter 'date' is set
        if ($date === null || (is_array($date) && count($date) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $date when calling getDailyHoroscopes'
            );
        }
        if (!preg_match("/^\\d{4}-\\d{2}-\\d{2}$/", $date)) {
            throw new \InvalidArgumentException("invalid value for \"date\" when calling HoroscopeApi.getDailyHoroscopes, must conform to the pattern /^\\d{4}-\\d{2}-\\d{2}$/.");
        }
        

        $resourcePath = '/api/horoscope/daily/{date}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($date !== null) {
            $resourcePath = str_replace(
                '{' . 'date' . '}',
                ObjectSerializer::toPathValue($date),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/vnd.api+json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Api-Key');
        if ($apiKey !== null) {
            $headers['X-Api-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getWeeklyHoroscope
     *
     * Get Weekly Horoscope Report
     *
     * @param  string $year year (required)
     * @param  string $week week (required)
     * @param  string $zodiac_sign zodiac_sign (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWeeklyHoroscope'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \AstroAPI\Model\HoroscopeReportResponse
     */
    public function getWeeklyHoroscope($year, $week, $zodiac_sign, string $contentType = self::contentTypes['getWeeklyHoroscope'][0])
    {
        list($response) = $this->getWeeklyHoroscopeWithHttpInfo($year, $week, $zodiac_sign, $contentType);
        return $response;
    }

    /**
     * Operation getWeeklyHoroscopeWithHttpInfo
     *
     * Get Weekly Horoscope Report
     *
     * @param  string $year (required)
     * @param  string $week (required)
     * @param  string $zodiac_sign (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWeeklyHoroscope'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \AstroAPI\Model\HoroscopeReportResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWeeklyHoroscopeWithHttpInfo($year, $week, $zodiac_sign, string $contentType = self::contentTypes['getWeeklyHoroscope'][0])
    {
        $request = $this->getWeeklyHoroscopeRequest($year, $week, $zodiac_sign, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\AstroAPI\Model\HoroscopeReportResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\AstroAPI\Model\HoroscopeReportResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\AstroAPI\Model\HoroscopeReportResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getWeeklyHoroscopeAsync
     *
     * Get Weekly Horoscope Report
     *
     * @param  string $year (required)
     * @param  string $week (required)
     * @param  string $zodiac_sign (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWeeklyHoroscope'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWeeklyHoroscopeAsync($year, $week, $zodiac_sign, string $contentType = self::contentTypes['getWeeklyHoroscope'][0])
    {
        return $this->getWeeklyHoroscopeAsyncWithHttpInfo($year, $week, $zodiac_sign, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getWeeklyHoroscopeAsyncWithHttpInfo
     *
     * Get Weekly Horoscope Report
     *
     * @param  string $year (required)
     * @param  string $week (required)
     * @param  string $zodiac_sign (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWeeklyHoroscope'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWeeklyHoroscopeAsyncWithHttpInfo($year, $week, $zodiac_sign, string $contentType = self::contentTypes['getWeeklyHoroscope'][0])
    {
        $returnType = '\AstroAPI\Model\HoroscopeReportResponse';
        $request = $this->getWeeklyHoroscopeRequest($year, $week, $zodiac_sign, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getWeeklyHoroscope'
     *
     * @param  string $year (required)
     * @param  string $week (required)
     * @param  string $zodiac_sign (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWeeklyHoroscope'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getWeeklyHoroscopeRequest($year, $week, $zodiac_sign, string $contentType = self::contentTypes['getWeeklyHoroscope'][0])
    {

        // verify the required parameter 'year' is set
        if ($year === null || (is_array($year) && count($year) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $year when calling getWeeklyHoroscope'
            );
        }
        if (!preg_match("/^\\d{4}$/", $year)) {
            throw new \InvalidArgumentException("invalid value for \"year\" when calling HoroscopeApi.getWeeklyHoroscope, must conform to the pattern /^\\d{4}$/.");
        }
        
        // verify the required parameter 'week' is set
        if ($week === null || (is_array($week) && count($week) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $week when calling getWeeklyHoroscope'
            );
        }
        if (!preg_match("/^(0[1-9]|[1-4]\\d|5[0-3])$/", $week)) {
            throw new \InvalidArgumentException("invalid value for \"week\" when calling HoroscopeApi.getWeeklyHoroscope, must conform to the pattern /^(0[1-9]|[1-4]\\d|5[0-3])$/.");
        }
        
        // verify the required parameter 'zodiac_sign' is set
        if ($zodiac_sign === null || (is_array($zodiac_sign) && count($zodiac_sign) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $zodiac_sign when calling getWeeklyHoroscope'
            );
        }


        $resourcePath = '/api/horoscope/weekly/{year}/{week}/{zodiacSign}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($year !== null) {
            $resourcePath = str_replace(
                '{' . 'year' . '}',
                ObjectSerializer::toPathValue($year),
                $resourcePath
            );
        }
        // path params
        if ($week !== null) {
            $resourcePath = str_replace(
                '{' . 'week' . '}',
                ObjectSerializer::toPathValue($week),
                $resourcePath
            );
        }
        // path params
        if ($zodiac_sign !== null) {
            $resourcePath = str_replace(
                '{' . 'zodiacSign' . '}',
                ObjectSerializer::toPathValue($zodiac_sign),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/vnd.api+json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Api-Key');
        if ($apiKey !== null) {
            $headers['X-Api-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getYearlyAscendantHoroscope
     *
     * Get Yearly Ascendant Horoscope Report
     *
     * @param  string $year year (required)
     * @param  string $zodiac_sign zodiac_sign (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getYearlyAscendantHoroscope'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \AstroAPI\Model\HoroscopeReportResponse
     */
    public function getYearlyAscendantHoroscope($year, $zodiac_sign, string $contentType = self::contentTypes['getYearlyAscendantHoroscope'][0])
    {
        list($response) = $this->getYearlyAscendantHoroscopeWithHttpInfo($year, $zodiac_sign, $contentType);
        return $response;
    }

    /**
     * Operation getYearlyAscendantHoroscopeWithHttpInfo
     *
     * Get Yearly Ascendant Horoscope Report
     *
     * @param  string $year (required)
     * @param  string $zodiac_sign (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getYearlyAscendantHoroscope'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \AstroAPI\Model\HoroscopeReportResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getYearlyAscendantHoroscopeWithHttpInfo($year, $zodiac_sign, string $contentType = self::contentTypes['getYearlyAscendantHoroscope'][0])
    {
        $request = $this->getYearlyAscendantHoroscopeRequest($year, $zodiac_sign, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\AstroAPI\Model\HoroscopeReportResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\AstroAPI\Model\HoroscopeReportResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\AstroAPI\Model\HoroscopeReportResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getYearlyAscendantHoroscopeAsync
     *
     * Get Yearly Ascendant Horoscope Report
     *
     * @param  string $year (required)
     * @param  string $zodiac_sign (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getYearlyAscendantHoroscope'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getYearlyAscendantHoroscopeAsync($year, $zodiac_sign, string $contentType = self::contentTypes['getYearlyAscendantHoroscope'][0])
    {
        return $this->getYearlyAscendantHoroscopeAsyncWithHttpInfo($year, $zodiac_sign, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getYearlyAscendantHoroscopeAsyncWithHttpInfo
     *
     * Get Yearly Ascendant Horoscope Report
     *
     * @param  string $year (required)
     * @param  string $zodiac_sign (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getYearlyAscendantHoroscope'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getYearlyAscendantHoroscopeAsyncWithHttpInfo($year, $zodiac_sign, string $contentType = self::contentTypes['getYearlyAscendantHoroscope'][0])
    {
        $returnType = '\AstroAPI\Model\HoroscopeReportResponse';
        $request = $this->getYearlyAscendantHoroscopeRequest($year, $zodiac_sign, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getYearlyAscendantHoroscope'
     *
     * @param  string $year (required)
     * @param  string $zodiac_sign (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getYearlyAscendantHoroscope'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getYearlyAscendantHoroscopeRequest($year, $zodiac_sign, string $contentType = self::contentTypes['getYearlyAscendantHoroscope'][0])
    {

        // verify the required parameter 'year' is set
        if ($year === null || (is_array($year) && count($year) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $year when calling getYearlyAscendantHoroscope'
            );
        }
        if (!preg_match("/^\\d{4}$/", $year)) {
            throw new \InvalidArgumentException("invalid value for \"year\" when calling HoroscopeApi.getYearlyAscendantHoroscope, must conform to the pattern /^\\d{4}$/.");
        }
        
        // verify the required parameter 'zodiac_sign' is set
        if ($zodiac_sign === null || (is_array($zodiac_sign) && count($zodiac_sign) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $zodiac_sign when calling getYearlyAscendantHoroscope'
            );
        }


        $resourcePath = '/api/horoscope/yearly-ascendant/{year}/{zodiacSign}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($year !== null) {
            $resourcePath = str_replace(
                '{' . 'year' . '}',
                ObjectSerializer::toPathValue($year),
                $resourcePath
            );
        }
        // path params
        if ($zodiac_sign !== null) {
            $resourcePath = str_replace(
                '{' . 'zodiacSign' . '}',
                ObjectSerializer::toPathValue($zodiac_sign),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/vnd.api+json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Api-Key');
        if ($apiKey !== null) {
            $headers['X-Api-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getYearlyHoroscope
     *
     * Get Yearly Horoscope Report
     *
     * @param  string $year year (required)
     * @param  string $zodiac_sign zodiac_sign (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getYearlyHoroscope'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \AstroAPI\Model\HoroscopeReportResponse
     */
    public function getYearlyHoroscope($year, $zodiac_sign, string $contentType = self::contentTypes['getYearlyHoroscope'][0])
    {
        list($response) = $this->getYearlyHoroscopeWithHttpInfo($year, $zodiac_sign, $contentType);
        return $response;
    }

    /**
     * Operation getYearlyHoroscopeWithHttpInfo
     *
     * Get Yearly Horoscope Report
     *
     * @param  string $year (required)
     * @param  string $zodiac_sign (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getYearlyHoroscope'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \AstroAPI\Model\HoroscopeReportResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getYearlyHoroscopeWithHttpInfo($year, $zodiac_sign, string $contentType = self::contentTypes['getYearlyHoroscope'][0])
    {
        $request = $this->getYearlyHoroscopeRequest($year, $zodiac_sign, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\AstroAPI\Model\HoroscopeReportResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\AstroAPI\Model\HoroscopeReportResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\AstroAPI\Model\HoroscopeReportResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getYearlyHoroscopeAsync
     *
     * Get Yearly Horoscope Report
     *
     * @param  string $year (required)
     * @param  string $zodiac_sign (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getYearlyHoroscope'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getYearlyHoroscopeAsync($year, $zodiac_sign, string $contentType = self::contentTypes['getYearlyHoroscope'][0])
    {
        return $this->getYearlyHoroscopeAsyncWithHttpInfo($year, $zodiac_sign, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getYearlyHoroscopeAsyncWithHttpInfo
     *
     * Get Yearly Horoscope Report
     *
     * @param  string $year (required)
     * @param  string $zodiac_sign (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getYearlyHoroscope'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getYearlyHoroscopeAsyncWithHttpInfo($year, $zodiac_sign, string $contentType = self::contentTypes['getYearlyHoroscope'][0])
    {
        $returnType = '\AstroAPI\Model\HoroscopeReportResponse';
        $request = $this->getYearlyHoroscopeRequest($year, $zodiac_sign, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getYearlyHoroscope'
     *
     * @param  string $year (required)
     * @param  string $zodiac_sign (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getYearlyHoroscope'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getYearlyHoroscopeRequest($year, $zodiac_sign, string $contentType = self::contentTypes['getYearlyHoroscope'][0])
    {

        // verify the required parameter 'year' is set
        if ($year === null || (is_array($year) && count($year) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $year when calling getYearlyHoroscope'
            );
        }
        if (!preg_match("/^\\d{4}$/", $year)) {
            throw new \InvalidArgumentException("invalid value for \"year\" when calling HoroscopeApi.getYearlyHoroscope, must conform to the pattern /^\\d{4}$/.");
        }
        
        // verify the required parameter 'zodiac_sign' is set
        if ($zodiac_sign === null || (is_array($zodiac_sign) && count($zodiac_sign) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $zodiac_sign when calling getYearlyHoroscope'
            );
        }


        $resourcePath = '/api/horoscope/yearly/{year}/{zodiacSign}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($year !== null) {
            $resourcePath = str_replace(
                '{' . 'year' . '}',
                ObjectSerializer::toPathValue($year),
                $resourcePath
            );
        }
        // path params
        if ($zodiac_sign !== null) {
            $resourcePath = str_replace(
                '{' . 'zodiacSign' . '}',
                ObjectSerializer::toPathValue($zodiac_sign),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/vnd.api+json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Api-Key');
        if ($apiKey !== null) {
            $headers['X-Api-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        if ($this->config->getCertFile()) {
            $options[RequestOptions::CERT] = $this->config->getCertFile();
        }

        if ($this->config->getKeyFile()) {
            $options[RequestOptions::SSL_KEY] = $this->config->getKeyFile();
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
