<?php
/**
 * NumerologyApi
 * PHP version 8.1
 *
 * @category Class
 * @package  AstroAPI
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * AstroAPI
 *
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.17.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace AstroAPI\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use AstroAPI\ApiException;
use AstroAPI\Configuration;
use AstroAPI\FormDataProcessor;
use AstroAPI\HeaderSelector;
use AstroAPI\ObjectSerializer;

/**
 * NumerologyApi Class Doc Comment
 *
 * @category Class
 * @package  AstroAPI
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class NumerologyApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'postApiNumerologyBirthday' => [
            'application/json',
        ],
        'postApiNumerologyCompatibility' => [
            'application/json',
        ],
        'postApiNumerologyExpression' => [
            'application/json',
        ],
        'postApiNumerologyLifePath' => [
            'application/json',
        ],
        'postApiNumerologyPersonalCycles' => [
            'application/json',
        ],
        'postApiNumerologyPersonality' => [
            'application/json',
        ],
        'postApiNumerologyProfile' => [
            'application/json',
        ],
        'postApiNumerologySoulUrge' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation postApiNumerologyBirthday
     *
     * Birthday Number
     *
     * @param  \AstroAPI\Model\NumerologyBirthdayRequest|null $numerology_birthday_request numerology_birthday_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiNumerologyBirthday'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \AstroAPI\Model\NumerologyBirthdayResponse
     */
    public function postApiNumerologyBirthday($numerology_birthday_request = null, string $contentType = self::contentTypes['postApiNumerologyBirthday'][0])
    {
        list($response) = $this->postApiNumerologyBirthdayWithHttpInfo($numerology_birthday_request, $contentType);
        return $response;
    }

    /**
     * Operation postApiNumerologyBirthdayWithHttpInfo
     *
     * Birthday Number
     *
     * @param  \AstroAPI\Model\NumerologyBirthdayRequest|null $numerology_birthday_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiNumerologyBirthday'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \AstroAPI\Model\NumerologyBirthdayResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function postApiNumerologyBirthdayWithHttpInfo($numerology_birthday_request = null, string $contentType = self::contentTypes['postApiNumerologyBirthday'][0])
    {
        $request = $this->postApiNumerologyBirthdayRequest($numerology_birthday_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\AstroAPI\Model\NumerologyBirthdayResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\AstroAPI\Model\NumerologyBirthdayResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\AstroAPI\Model\NumerologyBirthdayResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation postApiNumerologyBirthdayAsync
     *
     * Birthday Number
     *
     * @param  \AstroAPI\Model\NumerologyBirthdayRequest|null $numerology_birthday_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiNumerologyBirthday'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiNumerologyBirthdayAsync($numerology_birthday_request = null, string $contentType = self::contentTypes['postApiNumerologyBirthday'][0])
    {
        return $this->postApiNumerologyBirthdayAsyncWithHttpInfo($numerology_birthday_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postApiNumerologyBirthdayAsyncWithHttpInfo
     *
     * Birthday Number
     *
     * @param  \AstroAPI\Model\NumerologyBirthdayRequest|null $numerology_birthday_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiNumerologyBirthday'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiNumerologyBirthdayAsyncWithHttpInfo($numerology_birthday_request = null, string $contentType = self::contentTypes['postApiNumerologyBirthday'][0])
    {
        $returnType = '\AstroAPI\Model\NumerologyBirthdayResponse';
        $request = $this->postApiNumerologyBirthdayRequest($numerology_birthday_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postApiNumerologyBirthday'
     *
     * @param  \AstroAPI\Model\NumerologyBirthdayRequest|null $numerology_birthday_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiNumerologyBirthday'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postApiNumerologyBirthdayRequest($numerology_birthday_request = null, string $contentType = self::contentTypes['postApiNumerologyBirthday'][0])
    {



        $resourcePath = '/api/numerology/birthday';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/vnd.api+json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($numerology_birthday_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($numerology_birthday_request));
            } else {
                $httpBody = $numerology_birthday_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Api-Key');
        if ($apiKey !== null) {
            $headers['X-Api-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postApiNumerologyCompatibility
     *
     * Numerology Compatibility
     *
     * @param  \AstroAPI\Model\NumerologyCompatibilityRequest|null $numerology_compatibility_request numerology_compatibility_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiNumerologyCompatibility'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \AstroAPI\Model\NumerologyCompatibilityResponse
     */
    public function postApiNumerologyCompatibility($numerology_compatibility_request = null, string $contentType = self::contentTypes['postApiNumerologyCompatibility'][0])
    {
        list($response) = $this->postApiNumerologyCompatibilityWithHttpInfo($numerology_compatibility_request, $contentType);
        return $response;
    }

    /**
     * Operation postApiNumerologyCompatibilityWithHttpInfo
     *
     * Numerology Compatibility
     *
     * @param  \AstroAPI\Model\NumerologyCompatibilityRequest|null $numerology_compatibility_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiNumerologyCompatibility'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \AstroAPI\Model\NumerologyCompatibilityResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function postApiNumerologyCompatibilityWithHttpInfo($numerology_compatibility_request = null, string $contentType = self::contentTypes['postApiNumerologyCompatibility'][0])
    {
        $request = $this->postApiNumerologyCompatibilityRequest($numerology_compatibility_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\AstroAPI\Model\NumerologyCompatibilityResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\AstroAPI\Model\NumerologyCompatibilityResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\AstroAPI\Model\NumerologyCompatibilityResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation postApiNumerologyCompatibilityAsync
     *
     * Numerology Compatibility
     *
     * @param  \AstroAPI\Model\NumerologyCompatibilityRequest|null $numerology_compatibility_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiNumerologyCompatibility'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiNumerologyCompatibilityAsync($numerology_compatibility_request = null, string $contentType = self::contentTypes['postApiNumerologyCompatibility'][0])
    {
        return $this->postApiNumerologyCompatibilityAsyncWithHttpInfo($numerology_compatibility_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postApiNumerologyCompatibilityAsyncWithHttpInfo
     *
     * Numerology Compatibility
     *
     * @param  \AstroAPI\Model\NumerologyCompatibilityRequest|null $numerology_compatibility_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiNumerologyCompatibility'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiNumerologyCompatibilityAsyncWithHttpInfo($numerology_compatibility_request = null, string $contentType = self::contentTypes['postApiNumerologyCompatibility'][0])
    {
        $returnType = '\AstroAPI\Model\NumerologyCompatibilityResponse';
        $request = $this->postApiNumerologyCompatibilityRequest($numerology_compatibility_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postApiNumerologyCompatibility'
     *
     * @param  \AstroAPI\Model\NumerologyCompatibilityRequest|null $numerology_compatibility_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiNumerologyCompatibility'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postApiNumerologyCompatibilityRequest($numerology_compatibility_request = null, string $contentType = self::contentTypes['postApiNumerologyCompatibility'][0])
    {



        $resourcePath = '/api/numerology/compatibility';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/vnd.api+json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($numerology_compatibility_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($numerology_compatibility_request));
            } else {
                $httpBody = $numerology_compatibility_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Api-Key');
        if ($apiKey !== null) {
            $headers['X-Api-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postApiNumerologyExpression
     *
     * Expression Number
     *
     * @param  \AstroAPI\Model\NumerologyExpressionRequest|null $numerology_expression_request numerology_expression_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiNumerologyExpression'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \AstroAPI\Model\NumerologyExpressionResponse
     */
    public function postApiNumerologyExpression($numerology_expression_request = null, string $contentType = self::contentTypes['postApiNumerologyExpression'][0])
    {
        list($response) = $this->postApiNumerologyExpressionWithHttpInfo($numerology_expression_request, $contentType);
        return $response;
    }

    /**
     * Operation postApiNumerologyExpressionWithHttpInfo
     *
     * Expression Number
     *
     * @param  \AstroAPI\Model\NumerologyExpressionRequest|null $numerology_expression_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiNumerologyExpression'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \AstroAPI\Model\NumerologyExpressionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function postApiNumerologyExpressionWithHttpInfo($numerology_expression_request = null, string $contentType = self::contentTypes['postApiNumerologyExpression'][0])
    {
        $request = $this->postApiNumerologyExpressionRequest($numerology_expression_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\AstroAPI\Model\NumerologyExpressionResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\AstroAPI\Model\NumerologyExpressionResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\AstroAPI\Model\NumerologyExpressionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation postApiNumerologyExpressionAsync
     *
     * Expression Number
     *
     * @param  \AstroAPI\Model\NumerologyExpressionRequest|null $numerology_expression_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiNumerologyExpression'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiNumerologyExpressionAsync($numerology_expression_request = null, string $contentType = self::contentTypes['postApiNumerologyExpression'][0])
    {
        return $this->postApiNumerologyExpressionAsyncWithHttpInfo($numerology_expression_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postApiNumerologyExpressionAsyncWithHttpInfo
     *
     * Expression Number
     *
     * @param  \AstroAPI\Model\NumerologyExpressionRequest|null $numerology_expression_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiNumerologyExpression'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiNumerologyExpressionAsyncWithHttpInfo($numerology_expression_request = null, string $contentType = self::contentTypes['postApiNumerologyExpression'][0])
    {
        $returnType = '\AstroAPI\Model\NumerologyExpressionResponse';
        $request = $this->postApiNumerologyExpressionRequest($numerology_expression_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postApiNumerologyExpression'
     *
     * @param  \AstroAPI\Model\NumerologyExpressionRequest|null $numerology_expression_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiNumerologyExpression'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postApiNumerologyExpressionRequest($numerology_expression_request = null, string $contentType = self::contentTypes['postApiNumerologyExpression'][0])
    {



        $resourcePath = '/api/numerology/expression';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/vnd.api+json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($numerology_expression_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($numerology_expression_request));
            } else {
                $httpBody = $numerology_expression_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Api-Key');
        if ($apiKey !== null) {
            $headers['X-Api-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postApiNumerologyLifePath
     *
     * Life Path Number
     *
     * @param  \AstroAPI\Model\NumerologyLifePathRequest|null $numerology_life_path_request numerology_life_path_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiNumerologyLifePath'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \AstroAPI\Model\NumerologyLifePathResponse
     */
    public function postApiNumerologyLifePath($numerology_life_path_request = null, string $contentType = self::contentTypes['postApiNumerologyLifePath'][0])
    {
        list($response) = $this->postApiNumerologyLifePathWithHttpInfo($numerology_life_path_request, $contentType);
        return $response;
    }

    /**
     * Operation postApiNumerologyLifePathWithHttpInfo
     *
     * Life Path Number
     *
     * @param  \AstroAPI\Model\NumerologyLifePathRequest|null $numerology_life_path_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiNumerologyLifePath'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \AstroAPI\Model\NumerologyLifePathResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function postApiNumerologyLifePathWithHttpInfo($numerology_life_path_request = null, string $contentType = self::contentTypes['postApiNumerologyLifePath'][0])
    {
        $request = $this->postApiNumerologyLifePathRequest($numerology_life_path_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\AstroAPI\Model\NumerologyLifePathResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\AstroAPI\Model\NumerologyLifePathResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\AstroAPI\Model\NumerologyLifePathResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation postApiNumerologyLifePathAsync
     *
     * Life Path Number
     *
     * @param  \AstroAPI\Model\NumerologyLifePathRequest|null $numerology_life_path_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiNumerologyLifePath'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiNumerologyLifePathAsync($numerology_life_path_request = null, string $contentType = self::contentTypes['postApiNumerologyLifePath'][0])
    {
        return $this->postApiNumerologyLifePathAsyncWithHttpInfo($numerology_life_path_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postApiNumerologyLifePathAsyncWithHttpInfo
     *
     * Life Path Number
     *
     * @param  \AstroAPI\Model\NumerologyLifePathRequest|null $numerology_life_path_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiNumerologyLifePath'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiNumerologyLifePathAsyncWithHttpInfo($numerology_life_path_request = null, string $contentType = self::contentTypes['postApiNumerologyLifePath'][0])
    {
        $returnType = '\AstroAPI\Model\NumerologyLifePathResponse';
        $request = $this->postApiNumerologyLifePathRequest($numerology_life_path_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postApiNumerologyLifePath'
     *
     * @param  \AstroAPI\Model\NumerologyLifePathRequest|null $numerology_life_path_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiNumerologyLifePath'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postApiNumerologyLifePathRequest($numerology_life_path_request = null, string $contentType = self::contentTypes['postApiNumerologyLifePath'][0])
    {



        $resourcePath = '/api/numerology/life-path';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/vnd.api+json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($numerology_life_path_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($numerology_life_path_request));
            } else {
                $httpBody = $numerology_life_path_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Api-Key');
        if ($apiKey !== null) {
            $headers['X-Api-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postApiNumerologyPersonalCycles
     *
     * Personal Cycles
     *
     * @param  \AstroAPI\Model\NumerologyPersonalCyclesRequest|null $numerology_personal_cycles_request numerology_personal_cycles_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiNumerologyPersonalCycles'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \AstroAPI\Model\NumerologyPersonalCyclesResponse
     */
    public function postApiNumerologyPersonalCycles($numerology_personal_cycles_request = null, string $contentType = self::contentTypes['postApiNumerologyPersonalCycles'][0])
    {
        list($response) = $this->postApiNumerologyPersonalCyclesWithHttpInfo($numerology_personal_cycles_request, $contentType);
        return $response;
    }

    /**
     * Operation postApiNumerologyPersonalCyclesWithHttpInfo
     *
     * Personal Cycles
     *
     * @param  \AstroAPI\Model\NumerologyPersonalCyclesRequest|null $numerology_personal_cycles_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiNumerologyPersonalCycles'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \AstroAPI\Model\NumerologyPersonalCyclesResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function postApiNumerologyPersonalCyclesWithHttpInfo($numerology_personal_cycles_request = null, string $contentType = self::contentTypes['postApiNumerologyPersonalCycles'][0])
    {
        $request = $this->postApiNumerologyPersonalCyclesRequest($numerology_personal_cycles_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\AstroAPI\Model\NumerologyPersonalCyclesResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\AstroAPI\Model\NumerologyPersonalCyclesResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\AstroAPI\Model\NumerologyPersonalCyclesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation postApiNumerologyPersonalCyclesAsync
     *
     * Personal Cycles
     *
     * @param  \AstroAPI\Model\NumerologyPersonalCyclesRequest|null $numerology_personal_cycles_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiNumerologyPersonalCycles'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiNumerologyPersonalCyclesAsync($numerology_personal_cycles_request = null, string $contentType = self::contentTypes['postApiNumerologyPersonalCycles'][0])
    {
        return $this->postApiNumerologyPersonalCyclesAsyncWithHttpInfo($numerology_personal_cycles_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postApiNumerologyPersonalCyclesAsyncWithHttpInfo
     *
     * Personal Cycles
     *
     * @param  \AstroAPI\Model\NumerologyPersonalCyclesRequest|null $numerology_personal_cycles_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiNumerologyPersonalCycles'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiNumerologyPersonalCyclesAsyncWithHttpInfo($numerology_personal_cycles_request = null, string $contentType = self::contentTypes['postApiNumerologyPersonalCycles'][0])
    {
        $returnType = '\AstroAPI\Model\NumerologyPersonalCyclesResponse';
        $request = $this->postApiNumerologyPersonalCyclesRequest($numerology_personal_cycles_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postApiNumerologyPersonalCycles'
     *
     * @param  \AstroAPI\Model\NumerologyPersonalCyclesRequest|null $numerology_personal_cycles_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiNumerologyPersonalCycles'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postApiNumerologyPersonalCyclesRequest($numerology_personal_cycles_request = null, string $contentType = self::contentTypes['postApiNumerologyPersonalCycles'][0])
    {



        $resourcePath = '/api/numerology/personal-cycles';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/vnd.api+json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($numerology_personal_cycles_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($numerology_personal_cycles_request));
            } else {
                $httpBody = $numerology_personal_cycles_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Api-Key');
        if ($apiKey !== null) {
            $headers['X-Api-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postApiNumerologyPersonality
     *
     * Personality Number
     *
     * @param  \AstroAPI\Model\NumerologyPersonalityRequest|null $numerology_personality_request numerology_personality_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiNumerologyPersonality'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \AstroAPI\Model\NumerologyPersonalityResponse
     */
    public function postApiNumerologyPersonality($numerology_personality_request = null, string $contentType = self::contentTypes['postApiNumerologyPersonality'][0])
    {
        list($response) = $this->postApiNumerologyPersonalityWithHttpInfo($numerology_personality_request, $contentType);
        return $response;
    }

    /**
     * Operation postApiNumerologyPersonalityWithHttpInfo
     *
     * Personality Number
     *
     * @param  \AstroAPI\Model\NumerologyPersonalityRequest|null $numerology_personality_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiNumerologyPersonality'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \AstroAPI\Model\NumerologyPersonalityResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function postApiNumerologyPersonalityWithHttpInfo($numerology_personality_request = null, string $contentType = self::contentTypes['postApiNumerologyPersonality'][0])
    {
        $request = $this->postApiNumerologyPersonalityRequest($numerology_personality_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\AstroAPI\Model\NumerologyPersonalityResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\AstroAPI\Model\NumerologyPersonalityResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\AstroAPI\Model\NumerologyPersonalityResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation postApiNumerologyPersonalityAsync
     *
     * Personality Number
     *
     * @param  \AstroAPI\Model\NumerologyPersonalityRequest|null $numerology_personality_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiNumerologyPersonality'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiNumerologyPersonalityAsync($numerology_personality_request = null, string $contentType = self::contentTypes['postApiNumerologyPersonality'][0])
    {
        return $this->postApiNumerologyPersonalityAsyncWithHttpInfo($numerology_personality_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postApiNumerologyPersonalityAsyncWithHttpInfo
     *
     * Personality Number
     *
     * @param  \AstroAPI\Model\NumerologyPersonalityRequest|null $numerology_personality_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiNumerologyPersonality'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiNumerologyPersonalityAsyncWithHttpInfo($numerology_personality_request = null, string $contentType = self::contentTypes['postApiNumerologyPersonality'][0])
    {
        $returnType = '\AstroAPI\Model\NumerologyPersonalityResponse';
        $request = $this->postApiNumerologyPersonalityRequest($numerology_personality_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postApiNumerologyPersonality'
     *
     * @param  \AstroAPI\Model\NumerologyPersonalityRequest|null $numerology_personality_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiNumerologyPersonality'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postApiNumerologyPersonalityRequest($numerology_personality_request = null, string $contentType = self::contentTypes['postApiNumerologyPersonality'][0])
    {



        $resourcePath = '/api/numerology/personality';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/vnd.api+json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($numerology_personality_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($numerology_personality_request));
            } else {
                $httpBody = $numerology_personality_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Api-Key');
        if ($apiKey !== null) {
            $headers['X-Api-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postApiNumerologyProfile
     *
     * Full Numerology Profile
     *
     * @param  \AstroAPI\Model\NumerologyProfileRequest|null $numerology_profile_request numerology_profile_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiNumerologyProfile'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \AstroAPI\Model\NumerologyProfileResponse
     */
    public function postApiNumerologyProfile($numerology_profile_request = null, string $contentType = self::contentTypes['postApiNumerologyProfile'][0])
    {
        list($response) = $this->postApiNumerologyProfileWithHttpInfo($numerology_profile_request, $contentType);
        return $response;
    }

    /**
     * Operation postApiNumerologyProfileWithHttpInfo
     *
     * Full Numerology Profile
     *
     * @param  \AstroAPI\Model\NumerologyProfileRequest|null $numerology_profile_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiNumerologyProfile'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \AstroAPI\Model\NumerologyProfileResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function postApiNumerologyProfileWithHttpInfo($numerology_profile_request = null, string $contentType = self::contentTypes['postApiNumerologyProfile'][0])
    {
        $request = $this->postApiNumerologyProfileRequest($numerology_profile_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\AstroAPI\Model\NumerologyProfileResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\AstroAPI\Model\NumerologyProfileResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\AstroAPI\Model\NumerologyProfileResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation postApiNumerologyProfileAsync
     *
     * Full Numerology Profile
     *
     * @param  \AstroAPI\Model\NumerologyProfileRequest|null $numerology_profile_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiNumerologyProfile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiNumerologyProfileAsync($numerology_profile_request = null, string $contentType = self::contentTypes['postApiNumerologyProfile'][0])
    {
        return $this->postApiNumerologyProfileAsyncWithHttpInfo($numerology_profile_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postApiNumerologyProfileAsyncWithHttpInfo
     *
     * Full Numerology Profile
     *
     * @param  \AstroAPI\Model\NumerologyProfileRequest|null $numerology_profile_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiNumerologyProfile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiNumerologyProfileAsyncWithHttpInfo($numerology_profile_request = null, string $contentType = self::contentTypes['postApiNumerologyProfile'][0])
    {
        $returnType = '\AstroAPI\Model\NumerologyProfileResponse';
        $request = $this->postApiNumerologyProfileRequest($numerology_profile_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postApiNumerologyProfile'
     *
     * @param  \AstroAPI\Model\NumerologyProfileRequest|null $numerology_profile_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiNumerologyProfile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postApiNumerologyProfileRequest($numerology_profile_request = null, string $contentType = self::contentTypes['postApiNumerologyProfile'][0])
    {



        $resourcePath = '/api/numerology/profile';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/vnd.api+json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($numerology_profile_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($numerology_profile_request));
            } else {
                $httpBody = $numerology_profile_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Api-Key');
        if ($apiKey !== null) {
            $headers['X-Api-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postApiNumerologySoulUrge
     *
     * Soul Urge Number
     *
     * @param  \AstroAPI\Model\NumerologySoulUrgeRequest|null $numerology_soul_urge_request numerology_soul_urge_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiNumerologySoulUrge'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \AstroAPI\Model\NumerologySoulUrgeResponse
     */
    public function postApiNumerologySoulUrge($numerology_soul_urge_request = null, string $contentType = self::contentTypes['postApiNumerologySoulUrge'][0])
    {
        list($response) = $this->postApiNumerologySoulUrgeWithHttpInfo($numerology_soul_urge_request, $contentType);
        return $response;
    }

    /**
     * Operation postApiNumerologySoulUrgeWithHttpInfo
     *
     * Soul Urge Number
     *
     * @param  \AstroAPI\Model\NumerologySoulUrgeRequest|null $numerology_soul_urge_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiNumerologySoulUrge'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \AstroAPI\Model\NumerologySoulUrgeResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function postApiNumerologySoulUrgeWithHttpInfo($numerology_soul_urge_request = null, string $contentType = self::contentTypes['postApiNumerologySoulUrge'][0])
    {
        $request = $this->postApiNumerologySoulUrgeRequest($numerology_soul_urge_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\AstroAPI\Model\NumerologySoulUrgeResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\AstroAPI\Model\NumerologySoulUrgeResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\AstroAPI\Model\NumerologySoulUrgeResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation postApiNumerologySoulUrgeAsync
     *
     * Soul Urge Number
     *
     * @param  \AstroAPI\Model\NumerologySoulUrgeRequest|null $numerology_soul_urge_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiNumerologySoulUrge'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiNumerologySoulUrgeAsync($numerology_soul_urge_request = null, string $contentType = self::contentTypes['postApiNumerologySoulUrge'][0])
    {
        return $this->postApiNumerologySoulUrgeAsyncWithHttpInfo($numerology_soul_urge_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postApiNumerologySoulUrgeAsyncWithHttpInfo
     *
     * Soul Urge Number
     *
     * @param  \AstroAPI\Model\NumerologySoulUrgeRequest|null $numerology_soul_urge_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiNumerologySoulUrge'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiNumerologySoulUrgeAsyncWithHttpInfo($numerology_soul_urge_request = null, string $contentType = self::contentTypes['postApiNumerologySoulUrge'][0])
    {
        $returnType = '\AstroAPI\Model\NumerologySoulUrgeResponse';
        $request = $this->postApiNumerologySoulUrgeRequest($numerology_soul_urge_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postApiNumerologySoulUrge'
     *
     * @param  \AstroAPI\Model\NumerologySoulUrgeRequest|null $numerology_soul_urge_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiNumerologySoulUrge'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postApiNumerologySoulUrgeRequest($numerology_soul_urge_request = null, string $contentType = self::contentTypes['postApiNumerologySoulUrge'][0])
    {



        $resourcePath = '/api/numerology/soul-urge';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/vnd.api+json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($numerology_soul_urge_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($numerology_soul_urge_request));
            } else {
                $httpBody = $numerology_soul_urge_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Api-Key');
        if ($apiKey !== null) {
            $headers['X-Api-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        if ($this->config->getCertFile()) {
            $options[RequestOptions::CERT] = $this->config->getCertFile();
        }

        if ($this->config->getKeyFile()) {
            $options[RequestOptions::SSL_KEY] = $this->config->getKeyFile();
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
