<?php
/**
 * OrganizationsApi
 * PHP version 8.1
 *
 * @category Class
 * @package  AstroAPI
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * AstroAPI
 *
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.17.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace AstroAPI\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use AstroAPI\ApiException;
use AstroAPI\Configuration;
use AstroAPI\FormDataProcessor;
use AstroAPI\HeaderSelector;
use AstroAPI\ObjectSerializer;

/**
 * OrganizationsApi Class Doc Comment
 *
 * @category Class
 * @package  AstroAPI
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class OrganizationsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'deleteApiOrgUsersMemberId' => [
            'application/json',
        ],
        'getApiOrgUsers' => [
            'application/json',
        ],
        'patchApiOrgUsersMemberId' => [
            'application/json',
        ],
        'postApiOrg' => [
            'application/json',
        ],
        'postApiOrgUsers' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation deleteApiOrgUsersMemberId
     *
     * Remove Member
     *
     * @param  string $member_id member_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteApiOrgUsersMemberId'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteApiOrgUsersMemberId($member_id, string $contentType = self::contentTypes['deleteApiOrgUsersMemberId'][0])
    {
        $this->deleteApiOrgUsersMemberIdWithHttpInfo($member_id, $contentType);
    }

    /**
     * Operation deleteApiOrgUsersMemberIdWithHttpInfo
     *
     * Remove Member
     *
     * @param  string $member_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteApiOrgUsersMemberId'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteApiOrgUsersMemberIdWithHttpInfo($member_id, string $contentType = self::contentTypes['deleteApiOrgUsersMemberId'][0])
    {
        $request = $this->deleteApiOrgUsersMemberIdRequest($member_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteApiOrgUsersMemberIdAsync
     *
     * Remove Member
     *
     * @param  string $member_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteApiOrgUsersMemberId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteApiOrgUsersMemberIdAsync($member_id, string $contentType = self::contentTypes['deleteApiOrgUsersMemberId'][0])
    {
        return $this->deleteApiOrgUsersMemberIdAsyncWithHttpInfo($member_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteApiOrgUsersMemberIdAsyncWithHttpInfo
     *
     * Remove Member
     *
     * @param  string $member_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteApiOrgUsersMemberId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteApiOrgUsersMemberIdAsyncWithHttpInfo($member_id, string $contentType = self::contentTypes['deleteApiOrgUsersMemberId'][0])
    {
        $returnType = '';
        $request = $this->deleteApiOrgUsersMemberIdRequest($member_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteApiOrgUsersMemberId'
     *
     * @param  string $member_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteApiOrgUsersMemberId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteApiOrgUsersMemberIdRequest($member_id, string $contentType = self::contentTypes['deleteApiOrgUsersMemberId'][0])
    {

        // verify the required parameter 'member_id' is set
        if ($member_id === null || (is_array($member_id) && count($member_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $member_id when calling deleteApiOrgUsersMemberId'
            );
        }
        if (strlen($member_id) < 1) {
            throw new \InvalidArgumentException('invalid length for "$member_id" when calling OrganizationsApi.deleteApiOrgUsersMemberId, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/api/org/users/{memberId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($member_id !== null) {
            $resourcePath = str_replace(
                '{' . 'memberId' . '}',
                ObjectSerializer::toPathValue($member_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Api-Key');
        if ($apiKey !== null) {
            $headers['X-Api-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getApiOrgUsers
     *
     * List Members
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getApiOrgUsers'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \AstroAPI\Model\GetApiOrgUsers200Response
     */
    public function getApiOrgUsers(string $contentType = self::contentTypes['getApiOrgUsers'][0])
    {
        list($response) = $this->getApiOrgUsersWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getApiOrgUsersWithHttpInfo
     *
     * List Members
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getApiOrgUsers'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \AstroAPI\Model\GetApiOrgUsers200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getApiOrgUsersWithHttpInfo(string $contentType = self::contentTypes['getApiOrgUsers'][0])
    {
        $request = $this->getApiOrgUsersRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\AstroAPI\Model\GetApiOrgUsers200Response',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\AstroAPI\Model\GetApiOrgUsers200Response',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\AstroAPI\Model\GetApiOrgUsers200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getApiOrgUsersAsync
     *
     * List Members
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getApiOrgUsers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getApiOrgUsersAsync(string $contentType = self::contentTypes['getApiOrgUsers'][0])
    {
        return $this->getApiOrgUsersAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getApiOrgUsersAsyncWithHttpInfo
     *
     * List Members
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getApiOrgUsers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getApiOrgUsersAsyncWithHttpInfo(string $contentType = self::contentTypes['getApiOrgUsers'][0])
    {
        $returnType = '\AstroAPI\Model\GetApiOrgUsers200Response';
        $request = $this->getApiOrgUsersRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getApiOrgUsers'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getApiOrgUsers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getApiOrgUsersRequest(string $contentType = self::contentTypes['getApiOrgUsers'][0])
    {


        $resourcePath = '/api/org/users';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/vnd.api+json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Api-Key');
        if ($apiKey !== null) {
            $headers['X-Api-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation patchApiOrgUsersMemberId
     *
     * Update Member
     *
     * @param  string $member_id member_id (required)
     * @param  \AstroAPI\Model\PatchApiOrgUsersMemberIdRequest|null $patch_api_org_users_member_id_request patch_api_org_users_member_id_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['patchApiOrgUsersMemberId'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \AstroAPI\Model\PatchApiOrgUsersMemberId200Response
     */
    public function patchApiOrgUsersMemberId($member_id, $patch_api_org_users_member_id_request = null, string $contentType = self::contentTypes['patchApiOrgUsersMemberId'][0])
    {
        list($response) = $this->patchApiOrgUsersMemberIdWithHttpInfo($member_id, $patch_api_org_users_member_id_request, $contentType);
        return $response;
    }

    /**
     * Operation patchApiOrgUsersMemberIdWithHttpInfo
     *
     * Update Member
     *
     * @param  string $member_id (required)
     * @param  \AstroAPI\Model\PatchApiOrgUsersMemberIdRequest|null $patch_api_org_users_member_id_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['patchApiOrgUsersMemberId'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \AstroAPI\Model\PatchApiOrgUsersMemberId200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function patchApiOrgUsersMemberIdWithHttpInfo($member_id, $patch_api_org_users_member_id_request = null, string $contentType = self::contentTypes['patchApiOrgUsersMemberId'][0])
    {
        $request = $this->patchApiOrgUsersMemberIdRequest($member_id, $patch_api_org_users_member_id_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\AstroAPI\Model\PatchApiOrgUsersMemberId200Response',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\AstroAPI\Model\PatchApiOrgUsersMemberId200Response',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\AstroAPI\Model\PatchApiOrgUsersMemberId200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation patchApiOrgUsersMemberIdAsync
     *
     * Update Member
     *
     * @param  string $member_id (required)
     * @param  \AstroAPI\Model\PatchApiOrgUsersMemberIdRequest|null $patch_api_org_users_member_id_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['patchApiOrgUsersMemberId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function patchApiOrgUsersMemberIdAsync($member_id, $patch_api_org_users_member_id_request = null, string $contentType = self::contentTypes['patchApiOrgUsersMemberId'][0])
    {
        return $this->patchApiOrgUsersMemberIdAsyncWithHttpInfo($member_id, $patch_api_org_users_member_id_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation patchApiOrgUsersMemberIdAsyncWithHttpInfo
     *
     * Update Member
     *
     * @param  string $member_id (required)
     * @param  \AstroAPI\Model\PatchApiOrgUsersMemberIdRequest|null $patch_api_org_users_member_id_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['patchApiOrgUsersMemberId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function patchApiOrgUsersMemberIdAsyncWithHttpInfo($member_id, $patch_api_org_users_member_id_request = null, string $contentType = self::contentTypes['patchApiOrgUsersMemberId'][0])
    {
        $returnType = '\AstroAPI\Model\PatchApiOrgUsersMemberId200Response';
        $request = $this->patchApiOrgUsersMemberIdRequest($member_id, $patch_api_org_users_member_id_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'patchApiOrgUsersMemberId'
     *
     * @param  string $member_id (required)
     * @param  \AstroAPI\Model\PatchApiOrgUsersMemberIdRequest|null $patch_api_org_users_member_id_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['patchApiOrgUsersMemberId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function patchApiOrgUsersMemberIdRequest($member_id, $patch_api_org_users_member_id_request = null, string $contentType = self::contentTypes['patchApiOrgUsersMemberId'][0])
    {

        // verify the required parameter 'member_id' is set
        if ($member_id === null || (is_array($member_id) && count($member_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $member_id when calling patchApiOrgUsersMemberId'
            );
        }
        if (strlen($member_id) < 1) {
            throw new \InvalidArgumentException('invalid length for "$member_id" when calling OrganizationsApi.patchApiOrgUsersMemberId, must be bigger than or equal to 1.');
        }
        


        $resourcePath = '/api/org/users/{memberId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($member_id !== null) {
            $resourcePath = str_replace(
                '{' . 'memberId' . '}',
                ObjectSerializer::toPathValue($member_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/vnd.api+json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($patch_api_org_users_member_id_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($patch_api_org_users_member_id_request));
            } else {
                $httpBody = $patch_api_org_users_member_id_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Api-Key');
        if ($apiKey !== null) {
            $headers['X-Api-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postApiOrg
     *
     * Create Organization
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiOrg'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return mixed
     */
    public function postApiOrg(string $contentType = self::contentTypes['postApiOrg'][0])
    {
        list($response) = $this->postApiOrgWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation postApiOrgWithHttpInfo
     *
     * Create Organization
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiOrg'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of mixed, HTTP status code, HTTP response headers (array of strings)
     */
    public function postApiOrgWithHttpInfo(string $contentType = self::contentTypes['postApiOrg'][0])
    {
        $request = $this->postApiOrgRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'mixed',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'mixed',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'mixed',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation postApiOrgAsync
     *
     * Create Organization
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiOrg'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiOrgAsync(string $contentType = self::contentTypes['postApiOrg'][0])
    {
        return $this->postApiOrgAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postApiOrgAsyncWithHttpInfo
     *
     * Create Organization
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiOrg'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiOrgAsyncWithHttpInfo(string $contentType = self::contentTypes['postApiOrg'][0])
    {
        $returnType = 'mixed';
        $request = $this->postApiOrgRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postApiOrg'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiOrg'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postApiOrgRequest(string $contentType = self::contentTypes['postApiOrg'][0])
    {


        $resourcePath = '/api/org';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/vnd.api+json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Api-Key');
        if ($apiKey !== null) {
            $headers['X-Api-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postApiOrgUsers
     *
     * Add Member
     *
     * @param  \AstroAPI\Model\PostApiOrgUsersRequest|null $post_api_org_users_request post_api_org_users_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiOrgUsers'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \AstroAPI\Model\PostApiOrgUsers201Response
     */
    public function postApiOrgUsers($post_api_org_users_request = null, string $contentType = self::contentTypes['postApiOrgUsers'][0])
    {
        list($response) = $this->postApiOrgUsersWithHttpInfo($post_api_org_users_request, $contentType);
        return $response;
    }

    /**
     * Operation postApiOrgUsersWithHttpInfo
     *
     * Add Member
     *
     * @param  \AstroAPI\Model\PostApiOrgUsersRequest|null $post_api_org_users_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiOrgUsers'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \AstroAPI\Model\PostApiOrgUsers201Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function postApiOrgUsersWithHttpInfo($post_api_org_users_request = null, string $contentType = self::contentTypes['postApiOrgUsers'][0])
    {
        $request = $this->postApiOrgUsersRequest($post_api_org_users_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        '\AstroAPI\Model\PostApiOrgUsers201Response',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\AstroAPI\Model\PostApiOrgUsers201Response',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\AstroAPI\Model\PostApiOrgUsers201Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation postApiOrgUsersAsync
     *
     * Add Member
     *
     * @param  \AstroAPI\Model\PostApiOrgUsersRequest|null $post_api_org_users_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiOrgUsers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiOrgUsersAsync($post_api_org_users_request = null, string $contentType = self::contentTypes['postApiOrgUsers'][0])
    {
        return $this->postApiOrgUsersAsyncWithHttpInfo($post_api_org_users_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postApiOrgUsersAsyncWithHttpInfo
     *
     * Add Member
     *
     * @param  \AstroAPI\Model\PostApiOrgUsersRequest|null $post_api_org_users_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiOrgUsers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postApiOrgUsersAsyncWithHttpInfo($post_api_org_users_request = null, string $contentType = self::contentTypes['postApiOrgUsers'][0])
    {
        $returnType = '\AstroAPI\Model\PostApiOrgUsers201Response';
        $request = $this->postApiOrgUsersRequest($post_api_org_users_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postApiOrgUsers'
     *
     * @param  \AstroAPI\Model\PostApiOrgUsersRequest|null $post_api_org_users_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postApiOrgUsers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postApiOrgUsersRequest($post_api_org_users_request = null, string $contentType = self::contentTypes['postApiOrgUsers'][0])
    {



        $resourcePath = '/api/org/users';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/vnd.api+json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($post_api_org_users_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($post_api_org_users_request));
            } else {
                $httpBody = $post_api_org_users_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Api-Key');
        if ($apiKey !== null) {
            $headers['X-Api-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        if ($this->config->getCertFile()) {
            $options[RequestOptions::CERT] = $this->config->getCertFile();
        }

        if ($this->config->getKeyFile()) {
            $options[RequestOptions::SSL_KEY] = $this->config->getKeyFile();
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
