<?php
/**
 * WidgetApi
 * PHP version 8.1
 *
 * @category Class
 * @package  AstroAPI
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * AstroAPI
 *
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.17.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace AstroAPI\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use AstroAPI\ApiException;
use AstroAPI\Configuration;
use AstroAPI\FormDataProcessor;
use AstroAPI\HeaderSelector;
use AstroAPI\ObjectSerializer;

/**
 * WidgetApi Class Doc Comment
 *
 * @category Class
 * @package  AstroAPI
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class WidgetApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'getWidgetConfig' => [
            'application/json',
        ],
        'widgetChat' => [
            'application/json',
        ],
        'widgetChatWithUser' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation getWidgetConfig
     *
     * Get Widget Configuration
     *
     * @param  string $chatbot_id chatbot_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWidgetConfig'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function getWidgetConfig($chatbot_id, string $contentType = self::contentTypes['getWidgetConfig'][0])
    {
        $this->getWidgetConfigWithHttpInfo($chatbot_id, $contentType);
    }

    /**
     * Operation getWidgetConfigWithHttpInfo
     *
     * Get Widget Configuration
     *
     * @param  string $chatbot_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWidgetConfig'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWidgetConfigWithHttpInfo($chatbot_id, string $contentType = self::contentTypes['getWidgetConfig'][0])
    {
        $request = $this->getWidgetConfigRequest($chatbot_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation getWidgetConfigAsync
     *
     * Get Widget Configuration
     *
     * @param  string $chatbot_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWidgetConfig'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWidgetConfigAsync($chatbot_id, string $contentType = self::contentTypes['getWidgetConfig'][0])
    {
        return $this->getWidgetConfigAsyncWithHttpInfo($chatbot_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getWidgetConfigAsyncWithHttpInfo
     *
     * Get Widget Configuration
     *
     * @param  string $chatbot_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWidgetConfig'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWidgetConfigAsyncWithHttpInfo($chatbot_id, string $contentType = self::contentTypes['getWidgetConfig'][0])
    {
        $returnType = '';
        $request = $this->getWidgetConfigRequest($chatbot_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getWidgetConfig'
     *
     * @param  string $chatbot_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWidgetConfig'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getWidgetConfigRequest($chatbot_id, string $contentType = self::contentTypes['getWidgetConfig'][0])
    {

        // verify the required parameter 'chatbot_id' is set
        if ($chatbot_id === null || (is_array($chatbot_id) && count($chatbot_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $chatbot_id when calling getWidgetConfig'
            );
        }


        $resourcePath = '/widget/config/{chatbotId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($chatbot_id !== null) {
            $resourcePath = str_replace(
                '{' . 'chatbotId' . '}',
                ObjectSerializer::toPathValue($chatbot_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Api-Key');
        if ($apiKey !== null) {
            $headers['X-Api-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation widgetChat
     *
     * Widget Chat
     *
     * @param  string $chatbot_id chatbot_id (required)
     * @param  \AstroAPI\Model\WidgetChatRequest|null $widget_chat_request widget_chat_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['widgetChat'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return mixed
     */
    public function widgetChat($chatbot_id, $widget_chat_request = null, string $contentType = self::contentTypes['widgetChat'][0])
    {
        list($response) = $this->widgetChatWithHttpInfo($chatbot_id, $widget_chat_request, $contentType);
        return $response;
    }

    /**
     * Operation widgetChatWithHttpInfo
     *
     * Widget Chat
     *
     * @param  string $chatbot_id (required)
     * @param  \AstroAPI\Model\WidgetChatRequest|null $widget_chat_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['widgetChat'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of mixed, HTTP status code, HTTP response headers (array of strings)
     */
    public function widgetChatWithHttpInfo($chatbot_id, $widget_chat_request = null, string $contentType = self::contentTypes['widgetChat'][0])
    {
        $request = $this->widgetChatRequest($chatbot_id, $widget_chat_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'mixed',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'mixed',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'mixed',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation widgetChatAsync
     *
     * Widget Chat
     *
     * @param  string $chatbot_id (required)
     * @param  \AstroAPI\Model\WidgetChatRequest|null $widget_chat_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['widgetChat'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function widgetChatAsync($chatbot_id, $widget_chat_request = null, string $contentType = self::contentTypes['widgetChat'][0])
    {
        return $this->widgetChatAsyncWithHttpInfo($chatbot_id, $widget_chat_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation widgetChatAsyncWithHttpInfo
     *
     * Widget Chat
     *
     * @param  string $chatbot_id (required)
     * @param  \AstroAPI\Model\WidgetChatRequest|null $widget_chat_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['widgetChat'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function widgetChatAsyncWithHttpInfo($chatbot_id, $widget_chat_request = null, string $contentType = self::contentTypes['widgetChat'][0])
    {
        $returnType = 'mixed';
        $request = $this->widgetChatRequest($chatbot_id, $widget_chat_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'widgetChat'
     *
     * @param  string $chatbot_id (required)
     * @param  \AstroAPI\Model\WidgetChatRequest|null $widget_chat_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['widgetChat'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function widgetChatRequest($chatbot_id, $widget_chat_request = null, string $contentType = self::contentTypes['widgetChat'][0])
    {

        // verify the required parameter 'chatbot_id' is set
        if ($chatbot_id === null || (is_array($chatbot_id) && count($chatbot_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $chatbot_id when calling widgetChat'
            );
        }



        $resourcePath = '/widget/chat/{chatbotId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($chatbot_id !== null) {
            $resourcePath = str_replace(
                '{' . 'chatbotId' . '}',
                ObjectSerializer::toPathValue($chatbot_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['text/event-stream', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($widget_chat_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($widget_chat_request));
            } else {
                $httpBody = $widget_chat_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Api-Key');
        if ($apiKey !== null) {
            $headers['X-Api-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation widgetChatWithUser
     *
     * Widget Chat with User Profile
     *
     * @param  string $chatbot_id chatbot_id (required)
     * @param  string $external_user_id external_user_id (required)
     * @param  \AstroAPI\Model\WidgetChatWithUserRequest|null $widget_chat_with_user_request widget_chat_with_user_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['widgetChatWithUser'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return mixed
     */
    public function widgetChatWithUser($chatbot_id, $external_user_id, $widget_chat_with_user_request = null, string $contentType = self::contentTypes['widgetChatWithUser'][0])
    {
        list($response) = $this->widgetChatWithUserWithHttpInfo($chatbot_id, $external_user_id, $widget_chat_with_user_request, $contentType);
        return $response;
    }

    /**
     * Operation widgetChatWithUserWithHttpInfo
     *
     * Widget Chat with User Profile
     *
     * @param  string $chatbot_id (required)
     * @param  string $external_user_id (required)
     * @param  \AstroAPI\Model\WidgetChatWithUserRequest|null $widget_chat_with_user_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['widgetChatWithUser'] to see the possible values for this operation
     *
     * @throws \AstroAPI\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of mixed, HTTP status code, HTTP response headers (array of strings)
     */
    public function widgetChatWithUserWithHttpInfo($chatbot_id, $external_user_id, $widget_chat_with_user_request = null, string $contentType = self::contentTypes['widgetChatWithUser'][0])
    {
        $request = $this->widgetChatWithUserRequest($chatbot_id, $external_user_id, $widget_chat_with_user_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'mixed',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'mixed',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'mixed',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation widgetChatWithUserAsync
     *
     * Widget Chat with User Profile
     *
     * @param  string $chatbot_id (required)
     * @param  string $external_user_id (required)
     * @param  \AstroAPI\Model\WidgetChatWithUserRequest|null $widget_chat_with_user_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['widgetChatWithUser'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function widgetChatWithUserAsync($chatbot_id, $external_user_id, $widget_chat_with_user_request = null, string $contentType = self::contentTypes['widgetChatWithUser'][0])
    {
        return $this->widgetChatWithUserAsyncWithHttpInfo($chatbot_id, $external_user_id, $widget_chat_with_user_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation widgetChatWithUserAsyncWithHttpInfo
     *
     * Widget Chat with User Profile
     *
     * @param  string $chatbot_id (required)
     * @param  string $external_user_id (required)
     * @param  \AstroAPI\Model\WidgetChatWithUserRequest|null $widget_chat_with_user_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['widgetChatWithUser'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function widgetChatWithUserAsyncWithHttpInfo($chatbot_id, $external_user_id, $widget_chat_with_user_request = null, string $contentType = self::contentTypes['widgetChatWithUser'][0])
    {
        $returnType = 'mixed';
        $request = $this->widgetChatWithUserRequest($chatbot_id, $external_user_id, $widget_chat_with_user_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'widgetChatWithUser'
     *
     * @param  string $chatbot_id (required)
     * @param  string $external_user_id (required)
     * @param  \AstroAPI\Model\WidgetChatWithUserRequest|null $widget_chat_with_user_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['widgetChatWithUser'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function widgetChatWithUserRequest($chatbot_id, $external_user_id, $widget_chat_with_user_request = null, string $contentType = self::contentTypes['widgetChatWithUser'][0])
    {

        // verify the required parameter 'chatbot_id' is set
        if ($chatbot_id === null || (is_array($chatbot_id) && count($chatbot_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $chatbot_id when calling widgetChatWithUser'
            );
        }

        // verify the required parameter 'external_user_id' is set
        if ($external_user_id === null || (is_array($external_user_id) && count($external_user_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_user_id when calling widgetChatWithUser'
            );
        }



        $resourcePath = '/widget/chat/{chatbotId}/user/{externalUserId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($chatbot_id !== null) {
            $resourcePath = str_replace(
                '{' . 'chatbotId' . '}',
                ObjectSerializer::toPathValue($chatbot_id),
                $resourcePath
            );
        }
        // path params
        if ($external_user_id !== null) {
            $resourcePath = str_replace(
                '{' . 'externalUserId' . '}',
                ObjectSerializer::toPathValue($external_user_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['text/event-stream', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($widget_chat_with_user_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($widget_chat_with_user_request));
            } else {
                $httpBody = $widget_chat_with_user_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Api-Key');
        if ($apiKey !== null) {
            $headers['X-Api-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        if ($this->config->getCertFile()) {
            $options[RequestOptions::CERT] = $this->config->getCertFile();
        }

        if ($this->config->getKeyFile()) {
            $options[RequestOptions::SSL_KEY] = $this->config->getKeyFile();
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
