<?php
/**
 * Aspect1
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  AstroAPI
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * AstroAPI
 *
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.17.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace AstroAPI\Model;

use \ArrayAccess;
use \AstroAPI\ObjectSerializer;

/**
 * Aspect1 Class Doc Comment
 *
 * @category Class
 * @package  AstroAPI
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Aspect1 implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Aspect_1';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'point_a' => 'string',
        'point_b' => 'string',
        'aspect' => 'string',
        'angle' => 'float',
        'orb' => 'float',
        'applying' => 'bool',
        'text' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'point_a' => null,
        'point_b' => null,
        'aspect' => null,
        'angle' => null,
        'orb' => null,
        'applying' => null,
        'text' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'point_a' => false,
        'point_b' => false,
        'aspect' => false,
        'angle' => false,
        'orb' => false,
        'applying' => false,
        'text' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'point_a' => 'pointA',
        'point_b' => 'pointB',
        'aspect' => 'aspect',
        'angle' => 'angle',
        'orb' => 'orb',
        'applying' => 'applying',
        'text' => 'text'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'point_a' => 'setPointA',
        'point_b' => 'setPointB',
        'aspect' => 'setAspect',
        'angle' => 'setAngle',
        'orb' => 'setOrb',
        'applying' => 'setApplying',
        'text' => 'setText'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'point_a' => 'getPointA',
        'point_b' => 'getPointB',
        'aspect' => 'getAspect',
        'angle' => 'getAngle',
        'orb' => 'getOrb',
        'applying' => 'getApplying',
        'text' => 'getText'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('point_a', $data ?? [], null);
        $this->setIfExists('point_b', $data ?? [], null);
        $this->setIfExists('aspect', $data ?? [], null);
        $this->setIfExists('angle', $data ?? [], null);
        $this->setIfExists('orb', $data ?? [], null);
        $this->setIfExists('applying', $data ?? [], null);
        $this->setIfExists('text', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['point_a'] === null) {
            $invalidProperties[] = "'point_a' can't be null";
        }
        if ($this->container['point_b'] === null) {
            $invalidProperties[] = "'point_b' can't be null";
        }
        if ($this->container['aspect'] === null) {
            $invalidProperties[] = "'aspect' can't be null";
        }
        if ($this->container['angle'] === null) {
            $invalidProperties[] = "'angle' can't be null";
        }
        if ($this->container['orb'] === null) {
            $invalidProperties[] = "'orb' can't be null";
        }
        if ($this->container['applying'] === null) {
            $invalidProperties[] = "'applying' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets point_a
     *
     * @return string
     */
    public function getPointA()
    {
        return $this->container['point_a'];
    }

    /**
     * Sets point_a
     *
     * @param string $point_a point_a
     *
     * @return self
     */
    public function setPointA($point_a)
    {
        if (is_null($point_a)) {
            throw new \InvalidArgumentException('non-nullable point_a cannot be null');
        }
        $this->container['point_a'] = $point_a;

        return $this;
    }

    /**
     * Gets point_b
     *
     * @return string
     */
    public function getPointB()
    {
        return $this->container['point_b'];
    }

    /**
     * Sets point_b
     *
     * @param string $point_b point_b
     *
     * @return self
     */
    public function setPointB($point_b)
    {
        if (is_null($point_b)) {
            throw new \InvalidArgumentException('non-nullable point_b cannot be null');
        }
        $this->container['point_b'] = $point_b;

        return $this;
    }

    /**
     * Gets aspect
     *
     * @return string
     */
    public function getAspect()
    {
        return $this->container['aspect'];
    }

    /**
     * Sets aspect
     *
     * @param string $aspect aspect
     *
     * @return self
     */
    public function setAspect($aspect)
    {
        if (is_null($aspect)) {
            throw new \InvalidArgumentException('non-nullable aspect cannot be null');
        }
        $this->container['aspect'] = $aspect;

        return $this;
    }

    /**
     * Gets angle
     *
     * @return float
     */
    public function getAngle()
    {
        return $this->container['angle'];
    }

    /**
     * Sets angle
     *
     * @param float $angle angle
     *
     * @return self
     */
    public function setAngle($angle)
    {
        if (is_null($angle)) {
            throw new \InvalidArgumentException('non-nullable angle cannot be null');
        }
        $this->container['angle'] = $angle;

        return $this;
    }

    /**
     * Gets orb
     *
     * @return float
     */
    public function getOrb()
    {
        return $this->container['orb'];
    }

    /**
     * Sets orb
     *
     * @param float $orb orb
     *
     * @return self
     */
    public function setOrb($orb)
    {
        if (is_null($orb)) {
            throw new \InvalidArgumentException('non-nullable orb cannot be null');
        }
        $this->container['orb'] = $orb;

        return $this;
    }

    /**
     * Gets applying
     *
     * @return bool
     */
    public function getApplying()
    {
        return $this->container['applying'];
    }

    /**
     * Sets applying
     *
     * @param bool $applying applying
     *
     * @return self
     */
    public function setApplying($applying)
    {
        if (is_null($applying)) {
            throw new \InvalidArgumentException('non-nullable applying cannot be null');
        }
        $this->container['applying'] = $applying;

        return $this;
    }

    /**
     * Gets text
     *
     * @return string|null
     */
    public function getText()
    {
        return $this->container['text'];
    }

    /**
     * Sets text
     *
     * @param string|null $text text
     *
     * @return self
     */
    public function setText($text)
    {
        if (is_null($text)) {
            throw new \InvalidArgumentException('non-nullable text cannot be null');
        }
        $this->container['text'] = $text;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer|string $offset Offset
     *
     * @return boolean
     */
    public function offsetExists(mixed $offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet(mixed $offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return void
     */
    public function offsetUnset(mixed $offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


