<?php
/**
 * CelestialPoint
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  AstroAPI
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * AstroAPI
 *
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.17.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace AstroAPI\Model;

use \ArrayAccess;
use \AstroAPI\ObjectSerializer;

/**
 * CelestialPoint Class Doc Comment
 *
 * @category Class
 * @package  AstroAPI
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class CelestialPoint implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'CelestialPoint';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'point_id' => 'string',
        'longitude' => 'float',
        'speed_longitude' => 'float',
        'speed_latitude' => 'float',
        'speed_distance' => 'float',
        'retrograde' => 'bool',
        'house_id' => 'string',
        'house_number' => 'float',
        'degrees_in_sign' => 'float',
        'degrees_in_sign_dms' => 'float[]',
        'sign' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'point_id' => null,
        'longitude' => null,
        'speed_longitude' => null,
        'speed_latitude' => null,
        'speed_distance' => null,
        'retrograde' => null,
        'house_id' => null,
        'house_number' => null,
        'degrees_in_sign' => null,
        'degrees_in_sign_dms' => null,
        'sign' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'point_id' => true,
        'longitude' => true,
        'speed_longitude' => true,
        'speed_latitude' => true,
        'speed_distance' => true,
        'retrograde' => false,
        'house_id' => true,
        'house_number' => true,
        'degrees_in_sign' => true,
        'degrees_in_sign_dms' => false,
        'sign' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'point_id' => 'pointId',
        'longitude' => 'longitude',
        'speed_longitude' => 'speedLongitude',
        'speed_latitude' => 'speedLatitude',
        'speed_distance' => 'speedDistance',
        'retrograde' => 'retrograde',
        'house_id' => 'houseId',
        'house_number' => 'houseNumber',
        'degrees_in_sign' => 'degreesInSign',
        'degrees_in_sign_dms' => 'degreesInSignDms',
        'sign' => 'sign'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'point_id' => 'setPointId',
        'longitude' => 'setLongitude',
        'speed_longitude' => 'setSpeedLongitude',
        'speed_latitude' => 'setSpeedLatitude',
        'speed_distance' => 'setSpeedDistance',
        'retrograde' => 'setRetrograde',
        'house_id' => 'setHouseId',
        'house_number' => 'setHouseNumber',
        'degrees_in_sign' => 'setDegreesInSign',
        'degrees_in_sign_dms' => 'setDegreesInSignDms',
        'sign' => 'setSign'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'point_id' => 'getPointId',
        'longitude' => 'getLongitude',
        'speed_longitude' => 'getSpeedLongitude',
        'speed_latitude' => 'getSpeedLatitude',
        'speed_distance' => 'getSpeedDistance',
        'retrograde' => 'getRetrograde',
        'house_id' => 'getHouseId',
        'house_number' => 'getHouseNumber',
        'degrees_in_sign' => 'getDegreesInSign',
        'degrees_in_sign_dms' => 'getDegreesInSignDms',
        'sign' => 'getSign'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('point_id', $data ?? [], null);
        $this->setIfExists('longitude', $data ?? [], null);
        $this->setIfExists('speed_longitude', $data ?? [], null);
        $this->setIfExists('speed_latitude', $data ?? [], null);
        $this->setIfExists('speed_distance', $data ?? [], null);
        $this->setIfExists('retrograde', $data ?? [], null);
        $this->setIfExists('house_id', $data ?? [], null);
        $this->setIfExists('house_number', $data ?? [], null);
        $this->setIfExists('degrees_in_sign', $data ?? [], null);
        $this->setIfExists('degrees_in_sign_dms', $data ?? [], null);
        $this->setIfExists('sign', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['point_id'] === null) {
            $invalidProperties[] = "'point_id' can't be null";
        }
        if ($this->container['longitude'] === null) {
            $invalidProperties[] = "'longitude' can't be null";
        }
        if ($this->container['speed_longitude'] === null) {
            $invalidProperties[] = "'speed_longitude' can't be null";
        }
        if ($this->container['speed_latitude'] === null) {
            $invalidProperties[] = "'speed_latitude' can't be null";
        }
        if ($this->container['speed_distance'] === null) {
            $invalidProperties[] = "'speed_distance' can't be null";
        }
        if ($this->container['retrograde'] === null) {
            $invalidProperties[] = "'retrograde' can't be null";
        }
        if ($this->container['house_id'] === null) {
            $invalidProperties[] = "'house_id' can't be null";
        }
        if ($this->container['house_number'] === null) {
            $invalidProperties[] = "'house_number' can't be null";
        }
        if ($this->container['degrees_in_sign'] === null) {
            $invalidProperties[] = "'degrees_in_sign' can't be null";
        }
        if ($this->container['degrees_in_sign_dms'] === null) {
            $invalidProperties[] = "'degrees_in_sign_dms' can't be null";
        }
        if ($this->container['sign'] === null) {
            $invalidProperties[] = "'sign' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets point_id
     *
     * @return string
     */
    public function getPointId()
    {
        return $this->container['point_id'];
    }

    /**
     * Sets point_id
     *
     * @param string $point_id point_id
     *
     * @return self
     */
    public function setPointId($point_id)
    {
        if (is_null($point_id)) {
            array_push($this->openAPINullablesSetToNull, 'point_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('point_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['point_id'] = $point_id;

        return $this;
    }

    /**
     * Gets longitude
     *
     * @return float
     */
    public function getLongitude()
    {
        return $this->container['longitude'];
    }

    /**
     * Sets longitude
     *
     * @param float $longitude longitude
     *
     * @return self
     */
    public function setLongitude($longitude)
    {
        if (is_null($longitude)) {
            array_push($this->openAPINullablesSetToNull, 'longitude');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('longitude', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['longitude'] = $longitude;

        return $this;
    }

    /**
     * Gets speed_longitude
     *
     * @return float
     */
    public function getSpeedLongitude()
    {
        return $this->container['speed_longitude'];
    }

    /**
     * Sets speed_longitude
     *
     * @param float $speed_longitude speed_longitude
     *
     * @return self
     */
    public function setSpeedLongitude($speed_longitude)
    {
        if (is_null($speed_longitude)) {
            array_push($this->openAPINullablesSetToNull, 'speed_longitude');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('speed_longitude', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['speed_longitude'] = $speed_longitude;

        return $this;
    }

    /**
     * Gets speed_latitude
     *
     * @return float
     */
    public function getSpeedLatitude()
    {
        return $this->container['speed_latitude'];
    }

    /**
     * Sets speed_latitude
     *
     * @param float $speed_latitude speed_latitude
     *
     * @return self
     */
    public function setSpeedLatitude($speed_latitude)
    {
        if (is_null($speed_latitude)) {
            array_push($this->openAPINullablesSetToNull, 'speed_latitude');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('speed_latitude', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['speed_latitude'] = $speed_latitude;

        return $this;
    }

    /**
     * Gets speed_distance
     *
     * @return float
     */
    public function getSpeedDistance()
    {
        return $this->container['speed_distance'];
    }

    /**
     * Sets speed_distance
     *
     * @param float $speed_distance speed_distance
     *
     * @return self
     */
    public function setSpeedDistance($speed_distance)
    {
        if (is_null($speed_distance)) {
            array_push($this->openAPINullablesSetToNull, 'speed_distance');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('speed_distance', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['speed_distance'] = $speed_distance;

        return $this;
    }

    /**
     * Gets retrograde
     *
     * @return bool
     */
    public function getRetrograde()
    {
        return $this->container['retrograde'];
    }

    /**
     * Sets retrograde
     *
     * @param bool $retrograde retrograde
     *
     * @return self
     */
    public function setRetrograde($retrograde)
    {
        if (is_null($retrograde)) {
            throw new \InvalidArgumentException('non-nullable retrograde cannot be null');
        }
        $this->container['retrograde'] = $retrograde;

        return $this;
    }

    /**
     * Gets house_id
     *
     * @return string
     */
    public function getHouseId()
    {
        return $this->container['house_id'];
    }

    /**
     * Sets house_id
     *
     * @param string $house_id house_id
     *
     * @return self
     */
    public function setHouseId($house_id)
    {
        if (is_null($house_id)) {
            array_push($this->openAPINullablesSetToNull, 'house_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('house_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['house_id'] = $house_id;

        return $this;
    }

    /**
     * Gets house_number
     *
     * @return float
     */
    public function getHouseNumber()
    {
        return $this->container['house_number'];
    }

    /**
     * Sets house_number
     *
     * @param float $house_number house_number
     *
     * @return self
     */
    public function setHouseNumber($house_number)
    {
        if (is_null($house_number)) {
            array_push($this->openAPINullablesSetToNull, 'house_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('house_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['house_number'] = $house_number;

        return $this;
    }

    /**
     * Gets degrees_in_sign
     *
     * @return float
     */
    public function getDegreesInSign()
    {
        return $this->container['degrees_in_sign'];
    }

    /**
     * Sets degrees_in_sign
     *
     * @param float $degrees_in_sign degrees_in_sign
     *
     * @return self
     */
    public function setDegreesInSign($degrees_in_sign)
    {
        if (is_null($degrees_in_sign)) {
            array_push($this->openAPINullablesSetToNull, 'degrees_in_sign');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('degrees_in_sign', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['degrees_in_sign'] = $degrees_in_sign;

        return $this;
    }

    /**
     * Gets degrees_in_sign_dms
     *
     * @return float[]
     */
    public function getDegreesInSignDms()
    {
        return $this->container['degrees_in_sign_dms'];
    }

    /**
     * Sets degrees_in_sign_dms
     *
     * @param float[] $degrees_in_sign_dms degrees_in_sign_dms
     *
     * @return self
     */
    public function setDegreesInSignDms($degrees_in_sign_dms)
    {
        if (is_null($degrees_in_sign_dms)) {
            throw new \InvalidArgumentException('non-nullable degrees_in_sign_dms cannot be null');
        }
        $this->container['degrees_in_sign_dms'] = $degrees_in_sign_dms;

        return $this;
    }

    /**
     * Gets sign
     *
     * @return string
     */
    public function getSign()
    {
        return $this->container['sign'];
    }

    /**
     * Sets sign
     *
     * @param string $sign sign
     *
     * @return self
     */
    public function setSign($sign)
    {
        if (is_null($sign)) {
            array_push($this->openAPINullablesSetToNull, 'sign');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('sign', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['sign'] = $sign;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer|string $offset Offset
     *
     * @return boolean
     */
    public function offsetExists(mixed $offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet(mixed $offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return void
     */
    public function offsetUnset(mixed $offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


