<?php
/**
 * CompositeRequest
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  AstroAPI
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * AstroAPI
 *
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.17.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace AstroAPI\Model;

use \ArrayAccess;
use \AstroAPI\ObjectSerializer;

/**
 * CompositeRequest Class Doc Comment
 *
 * @category Class
 * @package  AstroAPI
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class CompositeRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'CompositeRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'date_time1' => 'string',
        'location1' => '\AstroAPI\Model\Location',
        'date_time2' => 'string',
        'location2' => '\AstroAPI\Model\Location',
        'house_system' => 'string',
        'language' => 'string',
        'include_text' => 'bool',
        'include_readable_entities' => 'bool',
        'points' => 'string[]',
        'orbs' => 'array<string,float>'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'date_time1' => null,
        'location1' => null,
        'date_time2' => null,
        'location2' => null,
        'house_system' => null,
        'language' => null,
        'include_text' => null,
        'include_readable_entities' => null,
        'points' => null,
        'orbs' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'date_time1' => false,
        'location1' => false,
        'date_time2' => false,
        'location2' => false,
        'house_system' => false,
        'language' => false,
        'include_text' => false,
        'include_readable_entities' => false,
        'points' => false,
        'orbs' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'date_time1' => 'dateTime1',
        'location1' => 'location1',
        'date_time2' => 'dateTime2',
        'location2' => 'location2',
        'house_system' => 'houseSystem',
        'language' => 'language',
        'include_text' => 'includeText',
        'include_readable_entities' => 'includeReadableEntities',
        'points' => 'points',
        'orbs' => 'orbs'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'date_time1' => 'setDateTime1',
        'location1' => 'setLocation1',
        'date_time2' => 'setDateTime2',
        'location2' => 'setLocation2',
        'house_system' => 'setHouseSystem',
        'language' => 'setLanguage',
        'include_text' => 'setIncludeText',
        'include_readable_entities' => 'setIncludeReadableEntities',
        'points' => 'setPoints',
        'orbs' => 'setOrbs'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'date_time1' => 'getDateTime1',
        'location1' => 'getLocation1',
        'date_time2' => 'getDateTime2',
        'location2' => 'getLocation2',
        'house_system' => 'getHouseSystem',
        'language' => 'getLanguage',
        'include_text' => 'getIncludeText',
        'include_readable_entities' => 'getIncludeReadableEntities',
        'points' => 'getPoints',
        'orbs' => 'getOrbs'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const HOUSE_SYSTEM_PLACIDUS = 'placidus';
    public const HOUSE_SYSTEM_KOCH = 'koch';
    public const HOUSE_SYSTEM_EQUAL = 'equal';
    public const HOUSE_SYSTEM_WHOLE = 'whole';
    public const HOUSE_SYSTEM_CAMPANUS = 'campanus';
    public const HOUSE_SYSTEM_REGIOMONTANUS = 'regiomontanus';
    public const HOUSE_SYSTEM_PORPHYRY = 'porphyry';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getHouseSystemAllowableValues()
    {
        return [
            self::HOUSE_SYSTEM_PLACIDUS,
            self::HOUSE_SYSTEM_KOCH,
            self::HOUSE_SYSTEM_EQUAL,
            self::HOUSE_SYSTEM_WHOLE,
            self::HOUSE_SYSTEM_CAMPANUS,
            self::HOUSE_SYSTEM_REGIOMONTANUS,
            self::HOUSE_SYSTEM_PORPHYRY,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('date_time1', $data ?? [], null);
        $this->setIfExists('location1', $data ?? [], null);
        $this->setIfExists('date_time2', $data ?? [], null);
        $this->setIfExists('location2', $data ?? [], null);
        $this->setIfExists('house_system', $data ?? [], 'placidus');
        $this->setIfExists('language', $data ?? [], 'en');
        $this->setIfExists('include_text', $data ?? [], true);
        $this->setIfExists('include_readable_entities', $data ?? [], false);
        $this->setIfExists('points', $data ?? [], null);
        $this->setIfExists('orbs', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['date_time1'] === null) {
            $invalidProperties[] = "'date_time1' can't be null";
        }
        if ($this->container['location1'] === null) {
            $invalidProperties[] = "'location1' can't be null";
        }
        if ($this->container['date_time2'] === null) {
            $invalidProperties[] = "'date_time2' can't be null";
        }
        if ($this->container['location2'] === null) {
            $invalidProperties[] = "'location2' can't be null";
        }
        $allowedValues = $this->getHouseSystemAllowableValues();
        if (!is_null($this->container['house_system']) && !in_array($this->container['house_system'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'house_system', must be one of '%s'",
                $this->container['house_system'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets date_time1
     *
     * @return string
     */
    public function getDateTime1()
    {
        return $this->container['date_time1'];
    }

    /**
     * Sets date_time1
     *
     * @param string $date_time1 First person birth date/time in YYYY-MM-DDTHH:mm format
     *
     * @return self
     */
    public function setDateTime1($date_time1)
    {
        if (is_null($date_time1)) {
            throw new \InvalidArgumentException('non-nullable date_time1 cannot be null');
        }
        $this->container['date_time1'] = $date_time1;

        return $this;
    }

    /**
     * Gets location1
     *
     * @return \AstroAPI\Model\Location
     */
    public function getLocation1()
    {
        return $this->container['location1'];
    }

    /**
     * Sets location1
     *
     * @param \AstroAPI\Model\Location $location1 location1
     *
     * @return self
     */
    public function setLocation1($location1)
    {
        if (is_null($location1)) {
            throw new \InvalidArgumentException('non-nullable location1 cannot be null');
        }
        $this->container['location1'] = $location1;

        return $this;
    }

    /**
     * Gets date_time2
     *
     * @return string
     */
    public function getDateTime2()
    {
        return $this->container['date_time2'];
    }

    /**
     * Sets date_time2
     *
     * @param string $date_time2 Second person birth date/time in YYYY-MM-DDTHH:mm format
     *
     * @return self
     */
    public function setDateTime2($date_time2)
    {
        if (is_null($date_time2)) {
            throw new \InvalidArgumentException('non-nullable date_time2 cannot be null');
        }
        $this->container['date_time2'] = $date_time2;

        return $this;
    }

    /**
     * Gets location2
     *
     * @return \AstroAPI\Model\Location
     */
    public function getLocation2()
    {
        return $this->container['location2'];
    }

    /**
     * Sets location2
     *
     * @param \AstroAPI\Model\Location $location2 location2
     *
     * @return self
     */
    public function setLocation2($location2)
    {
        if (is_null($location2)) {
            throw new \InvalidArgumentException('non-nullable location2 cannot be null');
        }
        $this->container['location2'] = $location2;

        return $this;
    }

    /**
     * Gets house_system
     *
     * @return string|null
     */
    public function getHouseSystem()
    {
        return $this->container['house_system'];
    }

    /**
     * Sets house_system
     *
     * @param string|null $house_system House system for calculations (default: \"placidus\")
     *
     * @return self
     */
    public function setHouseSystem($house_system)
    {
        if (is_null($house_system)) {
            throw new \InvalidArgumentException('non-nullable house_system cannot be null');
        }
        $allowedValues = $this->getHouseSystemAllowableValues();
        if (!in_array($house_system, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'house_system', must be one of '%s'",
                    $house_system,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['house_system'] = $house_system;

        return $this;
    }

    /**
     * Gets language
     *
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->container['language'];
    }

    /**
     * Sets language
     *
     * @param string|null $language Language code for text content
     *
     * @return self
     */
    public function setLanguage($language)
    {
        if (is_null($language)) {
            throw new \InvalidArgumentException('non-nullable language cannot be null');
        }
        $this->container['language'] = $language;

        return $this;
    }

    /**
     * Gets include_text
     *
     * @return bool|null
     */
    public function getIncludeText()
    {
        return $this->container['include_text'];
    }

    /**
     * Sets include_text
     *
     * @param bool|null $include_text Include interpretation text
     *
     * @return self
     */
    public function setIncludeText($include_text)
    {
        if (is_null($include_text)) {
            throw new \InvalidArgumentException('non-nullable include_text cannot be null');
        }
        $this->container['include_text'] = $include_text;

        return $this;
    }

    /**
     * Gets include_readable_entities
     *
     * @return bool|null
     */
    public function getIncludeReadableEntities()
    {
        return $this->container['include_readable_entities'];
    }

    /**
     * Sets include_readable_entities
     *
     * @param bool|null $include_readable_entities Include human-readable entity titles
     *
     * @return self
     */
    public function setIncludeReadableEntities($include_readable_entities)
    {
        if (is_null($include_readable_entities)) {
            throw new \InvalidArgumentException('non-nullable include_readable_entities cannot be null');
        }
        $this->container['include_readable_entities'] = $include_readable_entities;

        return $this;
    }

    /**
     * Gets points
     *
     * @return string[]|null
     */
    public function getPoints()
    {
        return $this->container['points'];
    }

    /**
     * Sets points
     *
     * @param string[]|null $points Celestial points to calculate (e.g., [\"sun\", \"moon\", \"mercury\"]). Defaults to all major planets.
     *
     * @return self
     */
    public function setPoints($points)
    {
        if (is_null($points)) {
            throw new \InvalidArgumentException('non-nullable points cannot be null');
        }
        $this->container['points'] = $points;

        return $this;
    }

    /**
     * Gets orbs
     *
     * @return array<string,float>|null
     */
    public function getOrbs()
    {
        return $this->container['orbs'];
    }

    /**
     * Sets orbs
     *
     * @param array<string,float>|null $orbs Custom orb values per aspect type (e.g., { \"conjunction\": 8, \"opposition\": 6 })
     *
     * @return self
     */
    public function setOrbs($orbs)
    {
        if (is_null($orbs)) {
            throw new \InvalidArgumentException('non-nullable orbs cannot be null');
        }
        $this->container['orbs'] = $orbs;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer|string $offset Offset
     *
     * @return boolean
     */
    public function offsetExists(mixed $offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet(mixed $offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return void
     */
    public function offsetUnset(mixed $offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


