<?php
/**
 * CreateChatProfileRequestDataAttributes
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  AstroAPI
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * AstroAPI
 *
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.17.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace AstroAPI\Model;

use \ArrayAccess;
use \AstroAPI\ObjectSerializer;

/**
 * CreateChatProfileRequestDataAttributes Class Doc Comment
 *
 * @category Class
 * @package  AstroAPI
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class CreateChatProfileRequestDataAttributes implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'createChatProfile_request_data_attributes';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'external_user_id' => 'string',
        'birth_date' => 'string',
        'birth_time' => 'string',
        'birth_place_lat' => 'float',
        'birth_place_lng' => 'float',
        'birth_place_name' => 'string',
        'timezone' => 'string',
        'metadata' => 'array<string,mixed>'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'external_user_id' => null,
        'birth_date' => null,
        'birth_time' => null,
        'birth_place_lat' => null,
        'birth_place_lng' => null,
        'birth_place_name' => null,
        'timezone' => null,
        'metadata' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'external_user_id' => true,
        'birth_date' => false,
        'birth_time' => false,
        'birth_place_lat' => true,
        'birth_place_lng' => true,
        'birth_place_name' => true,
        'timezone' => true,
        'metadata' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'external_user_id' => 'externalUserId',
        'birth_date' => 'birthDate',
        'birth_time' => 'birthTime',
        'birth_place_lat' => 'birthPlaceLat',
        'birth_place_lng' => 'birthPlaceLng',
        'birth_place_name' => 'birthPlaceName',
        'timezone' => 'timezone',
        'metadata' => 'metadata'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'external_user_id' => 'setExternalUserId',
        'birth_date' => 'setBirthDate',
        'birth_time' => 'setBirthTime',
        'birth_place_lat' => 'setBirthPlaceLat',
        'birth_place_lng' => 'setBirthPlaceLng',
        'birth_place_name' => 'setBirthPlaceName',
        'timezone' => 'setTimezone',
        'metadata' => 'setMetadata'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'external_user_id' => 'getExternalUserId',
        'birth_date' => 'getBirthDate',
        'birth_time' => 'getBirthTime',
        'birth_place_lat' => 'getBirthPlaceLat',
        'birth_place_lng' => 'getBirthPlaceLng',
        'birth_place_name' => 'getBirthPlaceName',
        'timezone' => 'getTimezone',
        'metadata' => 'getMetadata'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('external_user_id', $data ?? [], null);
        $this->setIfExists('birth_date', $data ?? [], null);
        $this->setIfExists('birth_time', $data ?? [], null);
        $this->setIfExists('birth_place_lat', $data ?? [], null);
        $this->setIfExists('birth_place_lng', $data ?? [], null);
        $this->setIfExists('birth_place_name', $data ?? [], null);
        $this->setIfExists('timezone', $data ?? [], null);
        $this->setIfExists('metadata', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['birth_date'] === null) {
            $invalidProperties[] = "'birth_date' can't be null";
        }
        if (!preg_match("/^\\d{4}-\\d{2}-\\d{2}$/", $this->container['birth_date'])) {
            $invalidProperties[] = "invalid value for 'birth_date', must be conform to the pattern /^\\d{4}-\\d{2}-\\d{2}$/.";
        }

        if (!is_null($this->container['birth_time']) && !preg_match("/^\\d{2}:\\d{2}$/", $this->container['birth_time'])) {
            $invalidProperties[] = "invalid value for 'birth_time', must be conform to the pattern /^\\d{2}:\\d{2}$/.";
        }

        if ($this->container['birth_place_lat'] === null) {
            $invalidProperties[] = "'birth_place_lat' can't be null";
        }
        if ($this->container['birth_place_lng'] === null) {
            $invalidProperties[] = "'birth_place_lng' can't be null";
        }
        if ($this->container['timezone'] === null) {
            $invalidProperties[] = "'timezone' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets external_user_id
     *
     * @return string|null
     */
    public function getExternalUserId()
    {
        return $this->container['external_user_id'];
    }

    /**
     * Sets external_user_id
     *
     * @param string|null $external_user_id external_user_id
     *
     * @return self
     */
    public function setExternalUserId($external_user_id)
    {
        if (is_null($external_user_id)) {
            array_push($this->openAPINullablesSetToNull, 'external_user_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('external_user_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['external_user_id'] = $external_user_id;

        return $this;
    }

    /**
     * Gets birth_date
     *
     * @return string
     */
    public function getBirthDate()
    {
        return $this->container['birth_date'];
    }

    /**
     * Sets birth_date
     *
     * @param string $birth_date birth_date
     *
     * @return self
     */
    public function setBirthDate($birth_date)
    {
        if (is_null($birth_date)) {
            throw new \InvalidArgumentException('non-nullable birth_date cannot be null');
        }

        if ((!preg_match("/^\\d{4}-\\d{2}-\\d{2}$/", ObjectSerializer::toString($birth_date)))) {
            throw new \InvalidArgumentException("invalid value for \$birth_date when calling CreateChatProfileRequestDataAttributes., must conform to the pattern /^\\d{4}-\\d{2}-\\d{2}$/.");
        }

        $this->container['birth_date'] = $birth_date;

        return $this;
    }

    /**
     * Gets birth_time
     *
     * @return string|null
     */
    public function getBirthTime()
    {
        return $this->container['birth_time'];
    }

    /**
     * Sets birth_time
     *
     * @param string|null $birth_time birth_time
     *
     * @return self
     */
    public function setBirthTime($birth_time)
    {
        if (is_null($birth_time)) {
            throw new \InvalidArgumentException('non-nullable birth_time cannot be null');
        }

        if ((!preg_match("/^\\d{2}:\\d{2}$/", ObjectSerializer::toString($birth_time)))) {
            throw new \InvalidArgumentException("invalid value for \$birth_time when calling CreateChatProfileRequestDataAttributes., must conform to the pattern /^\\d{2}:\\d{2}$/.");
        }

        $this->container['birth_time'] = $birth_time;

        return $this;
    }

    /**
     * Gets birth_place_lat
     *
     * @return float
     */
    public function getBirthPlaceLat()
    {
        return $this->container['birth_place_lat'];
    }

    /**
     * Sets birth_place_lat
     *
     * @param float $birth_place_lat birth_place_lat
     *
     * @return self
     */
    public function setBirthPlaceLat($birth_place_lat)
    {
        if (is_null($birth_place_lat)) {
            array_push($this->openAPINullablesSetToNull, 'birth_place_lat');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('birth_place_lat', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['birth_place_lat'] = $birth_place_lat;

        return $this;
    }

    /**
     * Gets birth_place_lng
     *
     * @return float
     */
    public function getBirthPlaceLng()
    {
        return $this->container['birth_place_lng'];
    }

    /**
     * Sets birth_place_lng
     *
     * @param float $birth_place_lng birth_place_lng
     *
     * @return self
     */
    public function setBirthPlaceLng($birth_place_lng)
    {
        if (is_null($birth_place_lng)) {
            array_push($this->openAPINullablesSetToNull, 'birth_place_lng');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('birth_place_lng', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['birth_place_lng'] = $birth_place_lng;

        return $this;
    }

    /**
     * Gets birth_place_name
     *
     * @return string|null
     */
    public function getBirthPlaceName()
    {
        return $this->container['birth_place_name'];
    }

    /**
     * Sets birth_place_name
     *
     * @param string|null $birth_place_name birth_place_name
     *
     * @return self
     */
    public function setBirthPlaceName($birth_place_name)
    {
        if (is_null($birth_place_name)) {
            array_push($this->openAPINullablesSetToNull, 'birth_place_name');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('birth_place_name', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['birth_place_name'] = $birth_place_name;

        return $this;
    }

    /**
     * Gets timezone
     *
     * @return string
     */
    public function getTimezone()
    {
        return $this->container['timezone'];
    }

    /**
     * Sets timezone
     *
     * @param string $timezone timezone
     *
     * @return self
     */
    public function setTimezone($timezone)
    {
        if (is_null($timezone)) {
            array_push($this->openAPINullablesSetToNull, 'timezone');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('timezone', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['timezone'] = $timezone;

        return $this;
    }

    /**
     * Gets metadata
     *
     * @return array<string,mixed>|null
     */
    public function getMetadata()
    {
        return $this->container['metadata'];
    }

    /**
     * Sets metadata
     *
     * @param array<string,mixed>|null $metadata metadata
     *
     * @return self
     */
    public function setMetadata($metadata)
    {
        if (is_null($metadata)) {
            throw new \InvalidArgumentException('non-nullable metadata cannot be null');
        }
        $this->container['metadata'] = $metadata;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer|string $offset Offset
     *
     * @return boolean
     */
    public function offsetExists(mixed $offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet(mixed $offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return void
     */
    public function offsetUnset(mixed $offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


