<?php
/**
 * MoonInfo
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  AstroAPI
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * AstroAPI
 *
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.17.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace AstroAPI\Model;

use \ArrayAccess;
use \AstroAPI\ObjectSerializer;

/**
 * MoonInfo Class Doc Comment
 *
 * @category Class
 * @package  AstroAPI
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class MoonInfo implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'MoonInfo';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'phase_name' => 'string',
        'phase' => 'float',
        'illumination' => 'float',
        'age' => 'float',
        'distance' => 'float',
        'diameter_degrees' => 'float',
        'rise' => 'string',
        'set' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'phase_name' => null,
        'phase' => null,
        'illumination' => null,
        'age' => null,
        'distance' => null,
        'diameter_degrees' => null,
        'rise' => null,
        'set' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'phase_name' => true,
        'phase' => true,
        'illumination' => true,
        'age' => true,
        'distance' => true,
        'diameter_degrees' => true,
        'rise' => true,
        'set' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'phase_name' => 'phaseName',
        'phase' => 'phase',
        'illumination' => 'illumination',
        'age' => 'age',
        'distance' => 'distance',
        'diameter_degrees' => 'diameterDegrees',
        'rise' => 'rise',
        'set' => 'set'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'phase_name' => 'setPhaseName',
        'phase' => 'setPhase',
        'illumination' => 'setIllumination',
        'age' => 'setAge',
        'distance' => 'setDistance',
        'diameter_degrees' => 'setDiameterDegrees',
        'rise' => 'setRise',
        'set' => 'setSet'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'phase_name' => 'getPhaseName',
        'phase' => 'getPhase',
        'illumination' => 'getIllumination',
        'age' => 'getAge',
        'distance' => 'getDistance',
        'diameter_degrees' => 'getDiameterDegrees',
        'rise' => 'getRise',
        'set' => 'getSet'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('phase_name', $data ?? [], null);
        $this->setIfExists('phase', $data ?? [], null);
        $this->setIfExists('illumination', $data ?? [], null);
        $this->setIfExists('age', $data ?? [], null);
        $this->setIfExists('distance', $data ?? [], null);
        $this->setIfExists('diameter_degrees', $data ?? [], null);
        $this->setIfExists('rise', $data ?? [], null);
        $this->setIfExists('set', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['phase_name'] === null) {
            $invalidProperties[] = "'phase_name' can't be null";
        }
        if ($this->container['phase'] === null) {
            $invalidProperties[] = "'phase' can't be null";
        }
        if ($this->container['illumination'] === null) {
            $invalidProperties[] = "'illumination' can't be null";
        }
        if ($this->container['age'] === null) {
            $invalidProperties[] = "'age' can't be null";
        }
        if ($this->container['distance'] === null) {
            $invalidProperties[] = "'distance' can't be null";
        }
        if ($this->container['diameter_degrees'] === null) {
            $invalidProperties[] = "'diameter_degrees' can't be null";
        }
        if ($this->container['rise'] === null) {
            $invalidProperties[] = "'rise' can't be null";
        }
        if ($this->container['set'] === null) {
            $invalidProperties[] = "'set' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets phase_name
     *
     * @return string
     */
    public function getPhaseName()
    {
        return $this->container['phase_name'];
    }

    /**
     * Sets phase_name
     *
     * @param string $phase_name phase_name
     *
     * @return self
     */
    public function setPhaseName($phase_name)
    {
        if (is_null($phase_name)) {
            array_push($this->openAPINullablesSetToNull, 'phase_name');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('phase_name', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['phase_name'] = $phase_name;

        return $this;
    }

    /**
     * Gets phase
     *
     * @return float
     */
    public function getPhase()
    {
        return $this->container['phase'];
    }

    /**
     * Sets phase
     *
     * @param float $phase phase
     *
     * @return self
     */
    public function setPhase($phase)
    {
        if (is_null($phase)) {
            array_push($this->openAPINullablesSetToNull, 'phase');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('phase', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['phase'] = $phase;

        return $this;
    }

    /**
     * Gets illumination
     *
     * @return float
     */
    public function getIllumination()
    {
        return $this->container['illumination'];
    }

    /**
     * Sets illumination
     *
     * @param float $illumination illumination
     *
     * @return self
     */
    public function setIllumination($illumination)
    {
        if (is_null($illumination)) {
            array_push($this->openAPINullablesSetToNull, 'illumination');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('illumination', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['illumination'] = $illumination;

        return $this;
    }

    /**
     * Gets age
     *
     * @return float
     */
    public function getAge()
    {
        return $this->container['age'];
    }

    /**
     * Sets age
     *
     * @param float $age age
     *
     * @return self
     */
    public function setAge($age)
    {
        if (is_null($age)) {
            array_push($this->openAPINullablesSetToNull, 'age');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('age', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['age'] = $age;

        return $this;
    }

    /**
     * Gets distance
     *
     * @return float
     */
    public function getDistance()
    {
        return $this->container['distance'];
    }

    /**
     * Sets distance
     *
     * @param float $distance distance
     *
     * @return self
     */
    public function setDistance($distance)
    {
        if (is_null($distance)) {
            array_push($this->openAPINullablesSetToNull, 'distance');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('distance', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['distance'] = $distance;

        return $this;
    }

    /**
     * Gets diameter_degrees
     *
     * @return float
     */
    public function getDiameterDegrees()
    {
        return $this->container['diameter_degrees'];
    }

    /**
     * Sets diameter_degrees
     *
     * @param float $diameter_degrees diameter_degrees
     *
     * @return self
     */
    public function setDiameterDegrees($diameter_degrees)
    {
        if (is_null($diameter_degrees)) {
            array_push($this->openAPINullablesSetToNull, 'diameter_degrees');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('diameter_degrees', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['diameter_degrees'] = $diameter_degrees;

        return $this;
    }

    /**
     * Gets rise
     *
     * @return string
     */
    public function getRise()
    {
        return $this->container['rise'];
    }

    /**
     * Sets rise
     *
     * @param string $rise rise
     *
     * @return self
     */
    public function setRise($rise)
    {
        if (is_null($rise)) {
            array_push($this->openAPINullablesSetToNull, 'rise');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('rise', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['rise'] = $rise;

        return $this;
    }

    /**
     * Gets set
     *
     * @return string
     */
    public function getSet()
    {
        return $this->container['set'];
    }

    /**
     * Sets set
     *
     * @param string $set set
     *
     * @return self
     */
    public function setSet($set)
    {
        if (is_null($set)) {
            array_push($this->openAPINullablesSetToNull, 'set');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('set', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['set'] = $set;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer|string $offset Offset
     *
     * @return boolean
     */
    public function offsetExists(mixed $offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet(mixed $offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return void
     */
    public function offsetUnset(mixed $offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


