<?php
/**
 * NumerologyNumber1
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  AstroAPI
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * AstroAPI
 *
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.17.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace AstroAPI\Model;

use \ArrayAccess;
use \AstroAPI\ObjectSerializer;

/**
 * NumerologyNumber1 Class Doc Comment
 *
 * @category Class
 * @package  AstroAPI
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class NumerologyNumber1 implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'NumerologyNumber_1';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'value' => 'float',
        'is_master_number' => 'bool',
        'is_karmic_debt' => 'bool',
        'reduced_from' => 'float',
        'calculation' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'value' => null,
        'is_master_number' => null,
        'is_karmic_debt' => null,
        'reduced_from' => null,
        'calculation' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'value' => false,
        'is_master_number' => false,
        'is_karmic_debt' => false,
        'reduced_from' => false,
        'calculation' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'value' => 'value',
        'is_master_number' => 'isMasterNumber',
        'is_karmic_debt' => 'isKarmicDebt',
        'reduced_from' => 'reducedFrom',
        'calculation' => 'calculation'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'value' => 'setValue',
        'is_master_number' => 'setIsMasterNumber',
        'is_karmic_debt' => 'setIsKarmicDebt',
        'reduced_from' => 'setReducedFrom',
        'calculation' => 'setCalculation'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'value' => 'getValue',
        'is_master_number' => 'getIsMasterNumber',
        'is_karmic_debt' => 'getIsKarmicDebt',
        'reduced_from' => 'getReducedFrom',
        'calculation' => 'getCalculation'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('value', $data ?? [], null);
        $this->setIfExists('is_master_number', $data ?? [], null);
        $this->setIfExists('is_karmic_debt', $data ?? [], null);
        $this->setIfExists('reduced_from', $data ?? [], null);
        $this->setIfExists('calculation', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['value'] === null) {
            $invalidProperties[] = "'value' can't be null";
        }
        if ($this->container['is_master_number'] === null) {
            $invalidProperties[] = "'is_master_number' can't be null";
        }
        if ($this->container['is_karmic_debt'] === null) {
            $invalidProperties[] = "'is_karmic_debt' can't be null";
        }
        if ($this->container['calculation'] === null) {
            $invalidProperties[] = "'calculation' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets value
     *
     * @return float
     */
    public function getValue()
    {
        return $this->container['value'];
    }

    /**
     * Sets value
     *
     * @param float $value value
     *
     * @return self
     */
    public function setValue($value)
    {
        if (is_null($value)) {
            throw new \InvalidArgumentException('non-nullable value cannot be null');
        }
        $this->container['value'] = $value;

        return $this;
    }

    /**
     * Gets is_master_number
     *
     * @return bool
     */
    public function getIsMasterNumber()
    {
        return $this->container['is_master_number'];
    }

    /**
     * Sets is_master_number
     *
     * @param bool $is_master_number is_master_number
     *
     * @return self
     */
    public function setIsMasterNumber($is_master_number)
    {
        if (is_null($is_master_number)) {
            throw new \InvalidArgumentException('non-nullable is_master_number cannot be null');
        }
        $this->container['is_master_number'] = $is_master_number;

        return $this;
    }

    /**
     * Gets is_karmic_debt
     *
     * @return bool
     */
    public function getIsKarmicDebt()
    {
        return $this->container['is_karmic_debt'];
    }

    /**
     * Sets is_karmic_debt
     *
     * @param bool $is_karmic_debt is_karmic_debt
     *
     * @return self
     */
    public function setIsKarmicDebt($is_karmic_debt)
    {
        if (is_null($is_karmic_debt)) {
            throw new \InvalidArgumentException('non-nullable is_karmic_debt cannot be null');
        }
        $this->container['is_karmic_debt'] = $is_karmic_debt;

        return $this;
    }

    /**
     * Gets reduced_from
     *
     * @return float|null
     */
    public function getReducedFrom()
    {
        return $this->container['reduced_from'];
    }

    /**
     * Sets reduced_from
     *
     * @param float|null $reduced_from reduced_from
     *
     * @return self
     */
    public function setReducedFrom($reduced_from)
    {
        if (is_null($reduced_from)) {
            throw new \InvalidArgumentException('non-nullable reduced_from cannot be null');
        }
        $this->container['reduced_from'] = $reduced_from;

        return $this;
    }

    /**
     * Gets calculation
     *
     * @return string
     */
    public function getCalculation()
    {
        return $this->container['calculation'];
    }

    /**
     * Sets calculation
     *
     * @param string $calculation calculation
     *
     * @return self
     */
    public function setCalculation($calculation)
    {
        if (is_null($calculation)) {
            throw new \InvalidArgumentException('non-nullable calculation cannot be null');
        }
        $this->container['calculation'] = $calculation;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer|string $offset Offset
     *
     * @return boolean
     */
    public function offsetExists(mixed $offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet(mixed $offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return void
     */
    public function offsetUnset(mixed $offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


