<?php
/**
 * NumerologyProfile
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  AstroAPI
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * AstroAPI
 *
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.17.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace AstroAPI\Model;

use \ArrayAccess;
use \AstroAPI\ObjectSerializer;

/**
 * NumerologyProfile Class Doc Comment
 *
 * @category Class
 * @package  AstroAPI
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class NumerologyProfile implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'NumerologyProfile';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'life_path_number' => '\AstroAPI\Model\NumerologyNumber',
        'expression_number' => '\AstroAPI\Model\NumerologyNumber1',
        'soul_urge_number' => '\AstroAPI\Model\NumerologyNumber1',
        'personality_number' => '\AstroAPI\Model\NumerologyNumber1',
        'birthday_number' => '\AstroAPI\Model\NumerologyNumber1',
        'personal_year' => '\AstroAPI\Model\NumerologyNumber1',
        'personal_month' => '\AstroAPI\Model\NumerologyNumber1',
        'personal_day' => '\AstroAPI\Model\NumerologyNumber1',
        'karmic_debt_numbers' => 'float[]',
        'master_numbers' => 'float[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'life_path_number' => null,
        'expression_number' => null,
        'soul_urge_number' => null,
        'personality_number' => null,
        'birthday_number' => null,
        'personal_year' => null,
        'personal_month' => null,
        'personal_day' => null,
        'karmic_debt_numbers' => null,
        'master_numbers' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'life_path_number' => false,
        'expression_number' => false,
        'soul_urge_number' => false,
        'personality_number' => false,
        'birthday_number' => false,
        'personal_year' => false,
        'personal_month' => false,
        'personal_day' => false,
        'karmic_debt_numbers' => false,
        'master_numbers' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'life_path_number' => 'lifePathNumber',
        'expression_number' => 'expressionNumber',
        'soul_urge_number' => 'soulUrgeNumber',
        'personality_number' => 'personalityNumber',
        'birthday_number' => 'birthdayNumber',
        'personal_year' => 'personalYear',
        'personal_month' => 'personalMonth',
        'personal_day' => 'personalDay',
        'karmic_debt_numbers' => 'karmicDebtNumbers',
        'master_numbers' => 'masterNumbers'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'life_path_number' => 'setLifePathNumber',
        'expression_number' => 'setExpressionNumber',
        'soul_urge_number' => 'setSoulUrgeNumber',
        'personality_number' => 'setPersonalityNumber',
        'birthday_number' => 'setBirthdayNumber',
        'personal_year' => 'setPersonalYear',
        'personal_month' => 'setPersonalMonth',
        'personal_day' => 'setPersonalDay',
        'karmic_debt_numbers' => 'setKarmicDebtNumbers',
        'master_numbers' => 'setMasterNumbers'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'life_path_number' => 'getLifePathNumber',
        'expression_number' => 'getExpressionNumber',
        'soul_urge_number' => 'getSoulUrgeNumber',
        'personality_number' => 'getPersonalityNumber',
        'birthday_number' => 'getBirthdayNumber',
        'personal_year' => 'getPersonalYear',
        'personal_month' => 'getPersonalMonth',
        'personal_day' => 'getPersonalDay',
        'karmic_debt_numbers' => 'getKarmicDebtNumbers',
        'master_numbers' => 'getMasterNumbers'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('life_path_number', $data ?? [], null);
        $this->setIfExists('expression_number', $data ?? [], null);
        $this->setIfExists('soul_urge_number', $data ?? [], null);
        $this->setIfExists('personality_number', $data ?? [], null);
        $this->setIfExists('birthday_number', $data ?? [], null);
        $this->setIfExists('personal_year', $data ?? [], null);
        $this->setIfExists('personal_month', $data ?? [], null);
        $this->setIfExists('personal_day', $data ?? [], null);
        $this->setIfExists('karmic_debt_numbers', $data ?? [], null);
        $this->setIfExists('master_numbers', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['life_path_number'] === null) {
            $invalidProperties[] = "'life_path_number' can't be null";
        }
        if ($this->container['expression_number'] === null) {
            $invalidProperties[] = "'expression_number' can't be null";
        }
        if ($this->container['soul_urge_number'] === null) {
            $invalidProperties[] = "'soul_urge_number' can't be null";
        }
        if ($this->container['personality_number'] === null) {
            $invalidProperties[] = "'personality_number' can't be null";
        }
        if ($this->container['birthday_number'] === null) {
            $invalidProperties[] = "'birthday_number' can't be null";
        }
        if ($this->container['personal_year'] === null) {
            $invalidProperties[] = "'personal_year' can't be null";
        }
        if ($this->container['personal_month'] === null) {
            $invalidProperties[] = "'personal_month' can't be null";
        }
        if ($this->container['personal_day'] === null) {
            $invalidProperties[] = "'personal_day' can't be null";
        }
        if ($this->container['karmic_debt_numbers'] === null) {
            $invalidProperties[] = "'karmic_debt_numbers' can't be null";
        }
        if ($this->container['master_numbers'] === null) {
            $invalidProperties[] = "'master_numbers' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets life_path_number
     *
     * @return \AstroAPI\Model\NumerologyNumber
     */
    public function getLifePathNumber()
    {
        return $this->container['life_path_number'];
    }

    /**
     * Sets life_path_number
     *
     * @param \AstroAPI\Model\NumerologyNumber $life_path_number life_path_number
     *
     * @return self
     */
    public function setLifePathNumber($life_path_number)
    {
        if (is_null($life_path_number)) {
            throw new \InvalidArgumentException('non-nullable life_path_number cannot be null');
        }
        $this->container['life_path_number'] = $life_path_number;

        return $this;
    }

    /**
     * Gets expression_number
     *
     * @return \AstroAPI\Model\NumerologyNumber1
     */
    public function getExpressionNumber()
    {
        return $this->container['expression_number'];
    }

    /**
     * Sets expression_number
     *
     * @param \AstroAPI\Model\NumerologyNumber1 $expression_number expression_number
     *
     * @return self
     */
    public function setExpressionNumber($expression_number)
    {
        if (is_null($expression_number)) {
            throw new \InvalidArgumentException('non-nullable expression_number cannot be null');
        }
        $this->container['expression_number'] = $expression_number;

        return $this;
    }

    /**
     * Gets soul_urge_number
     *
     * @return \AstroAPI\Model\NumerologyNumber1
     */
    public function getSoulUrgeNumber()
    {
        return $this->container['soul_urge_number'];
    }

    /**
     * Sets soul_urge_number
     *
     * @param \AstroAPI\Model\NumerologyNumber1 $soul_urge_number soul_urge_number
     *
     * @return self
     */
    public function setSoulUrgeNumber($soul_urge_number)
    {
        if (is_null($soul_urge_number)) {
            throw new \InvalidArgumentException('non-nullable soul_urge_number cannot be null');
        }
        $this->container['soul_urge_number'] = $soul_urge_number;

        return $this;
    }

    /**
     * Gets personality_number
     *
     * @return \AstroAPI\Model\NumerologyNumber1
     */
    public function getPersonalityNumber()
    {
        return $this->container['personality_number'];
    }

    /**
     * Sets personality_number
     *
     * @param \AstroAPI\Model\NumerologyNumber1 $personality_number personality_number
     *
     * @return self
     */
    public function setPersonalityNumber($personality_number)
    {
        if (is_null($personality_number)) {
            throw new \InvalidArgumentException('non-nullable personality_number cannot be null');
        }
        $this->container['personality_number'] = $personality_number;

        return $this;
    }

    /**
     * Gets birthday_number
     *
     * @return \AstroAPI\Model\NumerologyNumber1
     */
    public function getBirthdayNumber()
    {
        return $this->container['birthday_number'];
    }

    /**
     * Sets birthday_number
     *
     * @param \AstroAPI\Model\NumerologyNumber1 $birthday_number birthday_number
     *
     * @return self
     */
    public function setBirthdayNumber($birthday_number)
    {
        if (is_null($birthday_number)) {
            throw new \InvalidArgumentException('non-nullable birthday_number cannot be null');
        }
        $this->container['birthday_number'] = $birthday_number;

        return $this;
    }

    /**
     * Gets personal_year
     *
     * @return \AstroAPI\Model\NumerologyNumber1
     */
    public function getPersonalYear()
    {
        return $this->container['personal_year'];
    }

    /**
     * Sets personal_year
     *
     * @param \AstroAPI\Model\NumerologyNumber1 $personal_year personal_year
     *
     * @return self
     */
    public function setPersonalYear($personal_year)
    {
        if (is_null($personal_year)) {
            throw new \InvalidArgumentException('non-nullable personal_year cannot be null');
        }
        $this->container['personal_year'] = $personal_year;

        return $this;
    }

    /**
     * Gets personal_month
     *
     * @return \AstroAPI\Model\NumerologyNumber1
     */
    public function getPersonalMonth()
    {
        return $this->container['personal_month'];
    }

    /**
     * Sets personal_month
     *
     * @param \AstroAPI\Model\NumerologyNumber1 $personal_month personal_month
     *
     * @return self
     */
    public function setPersonalMonth($personal_month)
    {
        if (is_null($personal_month)) {
            throw new \InvalidArgumentException('non-nullable personal_month cannot be null');
        }
        $this->container['personal_month'] = $personal_month;

        return $this;
    }

    /**
     * Gets personal_day
     *
     * @return \AstroAPI\Model\NumerologyNumber1
     */
    public function getPersonalDay()
    {
        return $this->container['personal_day'];
    }

    /**
     * Sets personal_day
     *
     * @param \AstroAPI\Model\NumerologyNumber1 $personal_day personal_day
     *
     * @return self
     */
    public function setPersonalDay($personal_day)
    {
        if (is_null($personal_day)) {
            throw new \InvalidArgumentException('non-nullable personal_day cannot be null');
        }
        $this->container['personal_day'] = $personal_day;

        return $this;
    }

    /**
     * Gets karmic_debt_numbers
     *
     * @return float[]
     */
    public function getKarmicDebtNumbers()
    {
        return $this->container['karmic_debt_numbers'];
    }

    /**
     * Sets karmic_debt_numbers
     *
     * @param float[] $karmic_debt_numbers karmic_debt_numbers
     *
     * @return self
     */
    public function setKarmicDebtNumbers($karmic_debt_numbers)
    {
        if (is_null($karmic_debt_numbers)) {
            throw new \InvalidArgumentException('non-nullable karmic_debt_numbers cannot be null');
        }
        $this->container['karmic_debt_numbers'] = $karmic_debt_numbers;

        return $this;
    }

    /**
     * Gets master_numbers
     *
     * @return float[]
     */
    public function getMasterNumbers()
    {
        return $this->container['master_numbers'];
    }

    /**
     * Sets master_numbers
     *
     * @param float[] $master_numbers master_numbers
     *
     * @return self
     */
    public function setMasterNumbers($master_numbers)
    {
        if (is_null($master_numbers)) {
            throw new \InvalidArgumentException('non-nullable master_numbers cannot be null');
        }
        $this->container['master_numbers'] = $master_numbers;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer|string $offset Offset
     *
     * @return boolean
     */
    public function offsetExists(mixed $offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet(mixed $offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return void
     */
    public function offsetUnset(mixed $offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


