<?php
/**
 * ProgressionsData
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  AstroAPI
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * AstroAPI
 *
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.17.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace AstroAPI\Model;

use \ArrayAccess;
use \AstroAPI\ObjectSerializer;

/**
 * ProgressionsData Class Doc Comment
 *
 * @category Class
 * @package  AstroAPI
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ProgressionsData implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ProgressionsData';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'progressed_date' => 'string',
        'natal_date' => 'string',
        'target_date' => 'string',
        'aspects' => '\AstroAPI\Model\Aspect1[]',
        'aspects_to_natal' => '\AstroAPI\Model\Aspect1[]',
        'points' => 'array<string,\AstroAPI\Model\CelestialPoint1>',
        'natal_points' => 'array<string,\AstroAPI\Model\CelestialPoint1>',
        'houses' => '\AstroAPI\Model\Houses',
        'charts' => 'array<string,\AstroAPI\Model\ChartEntry1>'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'progressed_date' => null,
        'natal_date' => null,
        'target_date' => null,
        'aspects' => null,
        'aspects_to_natal' => null,
        'points' => null,
        'natal_points' => null,
        'houses' => null,
        'charts' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'progressed_date' => true,
        'natal_date' => true,
        'target_date' => true,
        'aspects' => false,
        'aspects_to_natal' => false,
        'points' => false,
        'natal_points' => false,
        'houses' => false,
        'charts' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'progressed_date' => 'progressedDate',
        'natal_date' => 'natalDate',
        'target_date' => 'targetDate',
        'aspects' => 'aspects',
        'aspects_to_natal' => 'aspectsToNatal',
        'points' => 'points',
        'natal_points' => 'natalPoints',
        'houses' => 'houses',
        'charts' => 'charts'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'progressed_date' => 'setProgressedDate',
        'natal_date' => 'setNatalDate',
        'target_date' => 'setTargetDate',
        'aspects' => 'setAspects',
        'aspects_to_natal' => 'setAspectsToNatal',
        'points' => 'setPoints',
        'natal_points' => 'setNatalPoints',
        'houses' => 'setHouses',
        'charts' => 'setCharts'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'progressed_date' => 'getProgressedDate',
        'natal_date' => 'getNatalDate',
        'target_date' => 'getTargetDate',
        'aspects' => 'getAspects',
        'aspects_to_natal' => 'getAspectsToNatal',
        'points' => 'getPoints',
        'natal_points' => 'getNatalPoints',
        'houses' => 'getHouses',
        'charts' => 'getCharts'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('progressed_date', $data ?? [], null);
        $this->setIfExists('natal_date', $data ?? [], null);
        $this->setIfExists('target_date', $data ?? [], null);
        $this->setIfExists('aspects', $data ?? [], null);
        $this->setIfExists('aspects_to_natal', $data ?? [], null);
        $this->setIfExists('points', $data ?? [], null);
        $this->setIfExists('natal_points', $data ?? [], null);
        $this->setIfExists('houses', $data ?? [], null);
        $this->setIfExists('charts', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['progressed_date'] === null) {
            $invalidProperties[] = "'progressed_date' can't be null";
        }
        if ($this->container['natal_date'] === null) {
            $invalidProperties[] = "'natal_date' can't be null";
        }
        if ($this->container['target_date'] === null) {
            $invalidProperties[] = "'target_date' can't be null";
        }
        if ($this->container['aspects'] === null) {
            $invalidProperties[] = "'aspects' can't be null";
        }
        if ($this->container['aspects_to_natal'] === null) {
            $invalidProperties[] = "'aspects_to_natal' can't be null";
        }
        if ($this->container['points'] === null) {
            $invalidProperties[] = "'points' can't be null";
        }
        if ($this->container['natal_points'] === null) {
            $invalidProperties[] = "'natal_points' can't be null";
        }
        if ($this->container['houses'] === null) {
            $invalidProperties[] = "'houses' can't be null";
        }
        if ($this->container['charts'] === null) {
            $invalidProperties[] = "'charts' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets progressed_date
     *
     * @return string
     */
    public function getProgressedDate()
    {
        return $this->container['progressed_date'];
    }

    /**
     * Sets progressed_date
     *
     * @param string $progressed_date progressed_date
     *
     * @return self
     */
    public function setProgressedDate($progressed_date)
    {
        if (is_null($progressed_date)) {
            array_push($this->openAPINullablesSetToNull, 'progressed_date');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('progressed_date', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['progressed_date'] = $progressed_date;

        return $this;
    }

    /**
     * Gets natal_date
     *
     * @return string
     */
    public function getNatalDate()
    {
        return $this->container['natal_date'];
    }

    /**
     * Sets natal_date
     *
     * @param string $natal_date natal_date
     *
     * @return self
     */
    public function setNatalDate($natal_date)
    {
        if (is_null($natal_date)) {
            array_push($this->openAPINullablesSetToNull, 'natal_date');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('natal_date', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['natal_date'] = $natal_date;

        return $this;
    }

    /**
     * Gets target_date
     *
     * @return string
     */
    public function getTargetDate()
    {
        return $this->container['target_date'];
    }

    /**
     * Sets target_date
     *
     * @param string $target_date target_date
     *
     * @return self
     */
    public function setTargetDate($target_date)
    {
        if (is_null($target_date)) {
            array_push($this->openAPINullablesSetToNull, 'target_date');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('target_date', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['target_date'] = $target_date;

        return $this;
    }

    /**
     * Gets aspects
     *
     * @return \AstroAPI\Model\Aspect1[]
     */
    public function getAspects()
    {
        return $this->container['aspects'];
    }

    /**
     * Sets aspects
     *
     * @param \AstroAPI\Model\Aspect1[] $aspects aspects
     *
     * @return self
     */
    public function setAspects($aspects)
    {
        if (is_null($aspects)) {
            throw new \InvalidArgumentException('non-nullable aspects cannot be null');
        }
        $this->container['aspects'] = $aspects;

        return $this;
    }

    /**
     * Gets aspects_to_natal
     *
     * @return \AstroAPI\Model\Aspect1[]
     */
    public function getAspectsToNatal()
    {
        return $this->container['aspects_to_natal'];
    }

    /**
     * Sets aspects_to_natal
     *
     * @param \AstroAPI\Model\Aspect1[] $aspects_to_natal aspects_to_natal
     *
     * @return self
     */
    public function setAspectsToNatal($aspects_to_natal)
    {
        if (is_null($aspects_to_natal)) {
            throw new \InvalidArgumentException('non-nullable aspects_to_natal cannot be null');
        }
        $this->container['aspects_to_natal'] = $aspects_to_natal;

        return $this;
    }

    /**
     * Gets points
     *
     * @return array<string,\AstroAPI\Model\CelestialPoint1>
     */
    public function getPoints()
    {
        return $this->container['points'];
    }

    /**
     * Sets points
     *
     * @param array<string,\AstroAPI\Model\CelestialPoint1> $points points
     *
     * @return self
     */
    public function setPoints($points)
    {
        if (is_null($points)) {
            throw new \InvalidArgumentException('non-nullable points cannot be null');
        }
        $this->container['points'] = $points;

        return $this;
    }

    /**
     * Gets natal_points
     *
     * @return array<string,\AstroAPI\Model\CelestialPoint1>
     */
    public function getNatalPoints()
    {
        return $this->container['natal_points'];
    }

    /**
     * Sets natal_points
     *
     * @param array<string,\AstroAPI\Model\CelestialPoint1> $natal_points natal_points
     *
     * @return self
     */
    public function setNatalPoints($natal_points)
    {
        if (is_null($natal_points)) {
            throw new \InvalidArgumentException('non-nullable natal_points cannot be null');
        }
        $this->container['natal_points'] = $natal_points;

        return $this;
    }

    /**
     * Gets houses
     *
     * @return \AstroAPI\Model\Houses
     */
    public function getHouses()
    {
        return $this->container['houses'];
    }

    /**
     * Sets houses
     *
     * @param \AstroAPI\Model\Houses $houses houses
     *
     * @return self
     */
    public function setHouses($houses)
    {
        if (is_null($houses)) {
            throw new \InvalidArgumentException('non-nullable houses cannot be null');
        }
        $this->container['houses'] = $houses;

        return $this;
    }

    /**
     * Gets charts
     *
     * @return array<string,\AstroAPI\Model\ChartEntry1>
     */
    public function getCharts()
    {
        return $this->container['charts'];
    }

    /**
     * Sets charts
     *
     * @param array<string,\AstroAPI\Model\ChartEntry1> $charts charts
     *
     * @return self
     */
    public function setCharts($charts)
    {
        if (is_null($charts)) {
            throw new \InvalidArgumentException('non-nullable charts cannot be null');
        }
        $this->container['charts'] = $charts;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer|string $offset Offset
     *
     * @return boolean
     */
    public function offsetExists(mixed $offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet(mixed $offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return void
     */
    public function offsetUnset(mixed $offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


